/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.harmony.x.imageio.internal.nls.Messages;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class IIOMetadataNode
implements Element,
NodeList {
    private String nodeName;
    private String nodeValue;
    private IIOMetadataNodeList attrs = new IIOMetadataNodeList(new ArrayList<IIOMetadataNode>());
    private IIOMetadataNode parent;
    private IIOMetadataNode firstChild;
    private IIOMetadataNode lastChild;
    private IIOMetadataNode previousSibling;
    private IIOMetadataNode nextSibling;
    private int nChildren;
    private Object userObject;
    private String textContent;

    public IIOMetadataNode() {
    }

    public IIOMetadataNode(String nodeName) {
        this.nodeName = nodeName;
    }

    private IIOMetadataNode(String nodeName, String nodeValue) {
        this.nodeName = nodeName;
        this.nodeValue = nodeValue;
    }

    @Override
    public String getTagName() {
        return this.nodeName;
    }

    @Override
    public String getAttribute(String name) {
        Attr attrNode = (Attr)this.attrs.getNamedItem(name);
        return attrNode == null ? "" : attrNode.getValue();
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        Attr attr = (Attr)this.attrs.getNamedItem(name);
        if (attr != null) {
            attr.setValue(value);
        } else {
            this.attrs.list.add(new IIOMetadataAttr(name, value, this));
        }
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        IIOMetadataAttr attr = (IIOMetadataAttr)this.attrs.getNamedItem(name);
        if (attr != null) {
            attr.setOwnerElement(null);
            this.attrs.list.remove(attr);
        }
    }

    @Override
    public Attr getAttributeNode(String name) {
        return (Attr)this.attrs.getNamedItem(name);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        IIOMetadataAttr iioAttr;
        Element owner = newAttr.getOwnerElement();
        if (owner != null) {
            if (owner == this) {
                return null;
            }
            throw new DOMException(10, Messages.getString("imageio.8E"));
        }
        String name = newAttr.getName();
        Attr oldAttr = this.getAttributeNode(name);
        if (oldAttr != null) {
            this.removeAttributeNode(oldAttr);
        }
        if (newAttr instanceof IIOMetadataAttr) {
            iioAttr = (IIOMetadataAttr)newAttr;
            iioAttr.setOwnerElement(this);
        } else {
            iioAttr = new IIOMetadataAttr(name, newAttr.getValue(), this);
        }
        this.attrs.list.add(iioAttr);
        return oldAttr;
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (!this.attrs.list.remove(oldAttr)) {
            throw new DOMException(8, Messages.getString("imageio.8F"));
        }
        ((IIOMetadataAttr)oldAttr).setOwnerElement(null);
        return oldAttr;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        ArrayList<IIOMetadataNode> nodes = new ArrayList<IIOMetadataNode>();
        Node pos = this;
        while (pos != null) {
            if (pos.getNodeName().equals(name)) {
                nodes.add((IIOMetadataNode)pos);
            }
            Node nextNode = pos.getFirstChild();
            while (nextNode == null && pos != this) {
                nextNode = pos.getNextSibling();
                if (nextNode != null || (pos = pos.getParentNode()) != null && pos != this) continue;
                nextNode = null;
                break;
            }
            pos = nextNode;
        }
        return new IIOMetadataNodeList(nodes);
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttribute(localName);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.setAttribute(qualifiedName, value);
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.removeAttribute(localName);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttributeNode(localName);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return this.getElementsByTagName(localName);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attrs.getNamedItem(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.hasAttribute(localName);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.nodeValue = nodeValue;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        return this;
    }

    @Override
    public Node getFirstChild() {
        return this.firstChild;
    }

    @Override
    public Node getLastChild() {
        return this.lastChild;
    }

    @Override
    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public Node getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attrs;
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.61"));
        }
        IIOMetadataNode newIIOChild = (IIOMetadataNode)newChild;
        IIOMetadataNode refIIOChild = (IIOMetadataNode)refChild;
        newIIOChild.parent = this;
        if (refIIOChild == null) {
            newIIOChild.nextSibling = null;
            newIIOChild.previousSibling = this.lastChild;
            this.lastChild = newIIOChild;
            if (this.firstChild == null) {
                this.firstChild = newIIOChild;
            }
        } else {
            newIIOChild.nextSibling = refIIOChild;
            newIIOChild.previousSibling = refIIOChild.previousSibling;
            if (this.firstChild == refIIOChild) {
                this.firstChild = newIIOChild;
            }
            if (refIIOChild != null) {
                refIIOChild.previousSibling = newIIOChild;
            }
        }
        if (newIIOChild.previousSibling != null) {
            newIIOChild.previousSibling.nextSibling = newIIOChild;
        }
        ++this.nChildren;
        return newIIOChild;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (newChild == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.61"));
        }
        IIOMetadataNode newIIOChild = (IIOMetadataNode)newChild;
        IIOMetadataNode oldIIOChild = (IIOMetadataNode)oldChild;
        IIOMetadataNode next = oldIIOChild.nextSibling;
        IIOMetadataNode previous = oldIIOChild.previousSibling;
        newIIOChild.parent = this;
        newIIOChild.nextSibling = next;
        newIIOChild.previousSibling = previous;
        if (this.lastChild == oldIIOChild) {
            this.lastChild = newIIOChild;
        }
        if (this.firstChild == oldIIOChild) {
            this.firstChild = newIIOChild;
        }
        if (next != null) {
            next.previousSibling = newIIOChild;
        }
        if (previous != null) {
            previous.nextSibling = newIIOChild;
        }
        oldIIOChild.parent = null;
        oldIIOChild.nextSibling = next;
        oldIIOChild.previousSibling = previous;
        return oldIIOChild;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.62"));
        }
        IIOMetadataNode oldIIOChild = (IIOMetadataNode)oldChild;
        IIOMetadataNode previous = oldIIOChild.previousSibling;
        IIOMetadataNode next = oldIIOChild.nextSibling;
        if (previous != null) {
            previous.nextSibling = next;
        }
        if (next != null) {
            next.previousSibling = previous;
        }
        if (this.lastChild == oldIIOChild) {
            this.lastChild = previous;
        }
        if (this.firstChild == oldIIOChild) {
            this.firstChild = next;
        }
        --this.nChildren;
        oldIIOChild.parent = null;
        oldIIOChild.previousSibling = null;
        oldIIOChild.nextSibling = null;
        return oldIIOChild;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    @Override
    public boolean hasChildNodes() {
        return this.nChildren != 0;
    }

    @Override
    public Node cloneNode(boolean deep) {
        IIOMetadataNode cloned = new IIOMetadataNode(this.nodeName);
        cloned.setUserObject(this.getUserObject());
        if (deep) {
            IIOMetadataNode c = this.firstChild;
            while (c != null) {
                cloned.insertBefore(c.cloneNode(true), null);
                c = c.nextSibling;
            }
        }
        return cloned;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return this.nodeName;
    }

    @Override
    public boolean hasAttributes() {
        return this.attrs.list.size() > 0;
    }

    @Override
    public String getBaseURI() {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.textContent;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.textContent = textContent;
    }

    @Override
    public boolean isSameNode(Node other) {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public Object getUserData(String key) {
        throw new DOMException(9, Messages.getString("imageio.90"));
    }

    @Override
    public Node item(int index) {
        if (index < 0 || index >= this.nChildren) {
            return null;
        }
        Node n = this.getFirstChild();
        while (index > 0) {
            n = n.getNextSibling();
            --index;
        }
        return n;
    }

    @Override
    public int getLength() {
        return this.nChildren;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    private class IIOMetadataNodeList
    implements NodeList,
    NamedNodeMap {
        private List<IIOMetadataNode> list;

        IIOMetadataNodeList(List<IIOMetadataNode> list) {
            this.list = list;
        }

        @Override
        public Node item(int index) {
            try {
                return this.list.get(index);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public Node getNamedItem(String name) {
            for (IIOMetadataNode node : this.list) {
                if (!name.equals(node.getNodeName())) continue;
                return node;
            }
            return null;
        }

        @Override
        public Node setNamedItem(Node arg) throws DOMException {
            throw new DOMException(7, Messages.getString("imageio.91"));
        }

        @Override
        public Node removeNamedItem(String name) throws DOMException {
            throw new DOMException(7, Messages.getString("imageio.91"));
        }

        @Override
        public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
            return this.getNamedItem(localName);
        }

        @Override
        public Node setNamedItemNS(Node arg) throws DOMException {
            throw new DOMException(7, Messages.getString("imageio.91"));
        }

        @Override
        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            throw new DOMException(7, Messages.getString("imageio.91"));
        }
    }

    private class IIOMetadataAttr
    extends IIOMetadataNode
    implements Attr {
        private Element ownerElement;

        public IIOMetadataAttr(String name, String value, Element owner) {
            super(name, value);
            this.ownerElement = owner;
        }

        @Override
        public String getName() {
            return this.getNodeName();
        }

        @Override
        public boolean getSpecified() {
            return true;
        }

        @Override
        public String getValue() {
            return IIOMetadataNode.this.nodeValue;
        }

        @Override
        public void setValue(String value) throws DOMException {
            IIOMetadataNode.this.nodeValue = value;
        }

        @Override
        public Element getOwnerElement() {
            return this.ownerElement;
        }

        public void setOwnerElement(Element ownerElement) {
            this.ownerElement = ownerElement;
        }

        @Override
        public boolean isId() {
            throw new DOMException(9, Messages.getString("imageio.90"));
        }

        @Override
        public short getNodeType() {
            return 2;
        }
    }
}

