/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOStandardMetadataFormat;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public abstract class IIOMetadataFormatImpl
implements IIOMetadataFormat {
    public static final String standardMetadataFormatName = "javax_imageio_1.0";
    private static IIOMetadataFormatImpl standardFormat;
    private String rootName;
    private HashMap<String, Element> elementHash = new HashMap();
    private String resourceBaseName = this.getClass().getName() + "Resources";

    public IIOMetadataFormatImpl(String rootName, int childPolicy) {
        if (rootName == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.63"));
        }
        if (childPolicy < 0 || childPolicy > 5 || childPolicy == 5) {
            throw new IllegalArgumentException(Messages.getString("imageio.64"));
        }
        this.rootName = rootName;
        Element root = new Element();
        root.name = rootName;
        root.childPolicy = childPolicy;
        this.elementHash.put(rootName, root);
    }

    public IIOMetadataFormatImpl(String rootName, int minChildren, int maxChildren) {
        if (rootName == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.63"));
        }
        if (minChildren < 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.65"));
        }
        if (minChildren > maxChildren) {
            throw new IllegalArgumentException(Messages.getString("imageio.66"));
        }
        this.rootName = rootName;
        Element root = new Element();
        root.name = rootName;
        root.minChildren = minChildren;
        root.maxChildren = maxChildren;
        root.childPolicy = 5;
        this.elementHash.put(rootName, root);
    }

    @Override
    public abstract boolean canNodeAppear(String var1, ImageTypeSpecifier var2);

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, int listMinLength, int listMaxLength) {
        if (attrName == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.67"));
        }
        if (dataType < 0 || dataType > 4) {
            throw new IllegalArgumentException(Messages.getString("imageio.68"));
        }
        if (listMinLength < 0 || listMinLength > listMaxLength) {
            throw new IllegalArgumentException(Messages.getString("imageio.69"));
        }
        Element element = this.findElement(elementName);
        Attlist attr = new Attlist();
        attr.name = attrName;
        attr.dataType = dataType;
        attr.required = required;
        attr.listMinLength = listMinLength;
        attr.listMaxLength = listMaxLength;
        attr.valueType = 32;
        element.attributes.put(attrName, attr);
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, String defaultValue) {
        if (attrName == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.67"));
        }
        if (dataType < 0 || dataType > 4) {
            throw new IllegalArgumentException(Messages.getString("imageio.68"));
        }
        Element element = this.findElement(elementName);
        Attlist attr = new Attlist();
        attr.name = attrName;
        attr.dataType = dataType;
        attr.required = required;
        attr.defaultValue = defaultValue;
        attr.valueType = 1;
        element.attributes.put(attrName, attr);
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, String defaultValue, List<String> enumeratedValues) {
        if (attrName == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.67"));
        }
        if (dataType < 0 || dataType > 4) {
            throw new IllegalArgumentException(Messages.getString("imageio.68"));
        }
        if (enumeratedValues == null || enumeratedValues.isEmpty()) {
            throw new IllegalArgumentException(Messages.getString("imageio.6A"));
        }
        try {
            for (String enumeratedValue : enumeratedValues) {
                if (enumeratedValue != null) continue;
                throw new IllegalArgumentException(Messages.getString("imageio.6B"));
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(Messages.getString("imageio.6C"));
        }
        Element element = this.findElement(elementName);
        Attlist attr = new Attlist();
        attr.name = attrName;
        attr.dataType = dataType;
        attr.required = required;
        attr.defaultValue = defaultValue;
        attr.enumeratedValues = enumeratedValues;
        attr.valueType = 16;
        element.attributes.put(attrName, attr);
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, String defaultValue, String minValue, String maxValue, boolean minInclusive, boolean maxInclusive) {
        if (attrName == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.67"));
        }
        if (dataType < 0 || dataType > 4) {
            throw new IllegalArgumentException(Messages.getString("imageio.68"));
        }
        Element element = this.findElement(elementName);
        Attlist attr = new Attlist();
        attr.name = attrName;
        attr.dataType = dataType;
        attr.required = required;
        attr.defaultValue = defaultValue;
        attr.minValue = minValue;
        attr.maxValue = maxValue;
        attr.minInclusive = minInclusive;
        attr.maxInclusive = maxInclusive;
        attr.valueType = 2;
        attr.valueType = attr.valueType | (minInclusive ? 4 : 0);
        attr.valueType = attr.valueType | (maxInclusive ? 8 : 0);
        element.attributes.put(attrName, attr);
    }

    protected void addBooleanAttribute(String elementName, String attrName, boolean hasDefaultValue, boolean defaultValue) {
        String defaultVal = hasDefaultValue ? (defaultValue ? "TRUE" : "FALSE") : null;
        ArrayList<String> values = new ArrayList<String>(2);
        values.add("TRUE");
        values.add("FALSE");
        this.addAttribute(elementName, attrName, 1, true, defaultVal, values);
    }

    protected void addChildElement(String elementName, String parentName) {
        Element parent = this.findElement(parentName);
        Element element = this.findElement(elementName);
        parent.children.add(element.name);
    }

    protected void addElement(String elementName, String parentName, int childPolicy) {
        if (childPolicy < 0 || childPolicy > 5 || childPolicy == 5) {
            throw new IllegalArgumentException(Messages.getString("imageio.64"));
        }
        Element parent = this.findElement(parentName);
        Element element = new Element();
        element.name = elementName;
        element.childPolicy = childPolicy;
        this.elementHash.put(elementName, element);
        parent.children.add(elementName);
    }

    protected void addElement(String elementName, String parentName, int minChildren, int maxChildren) {
        if (minChildren < 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.65"));
        }
        if (minChildren > maxChildren) {
            throw new IllegalArgumentException(Messages.getString("imageio.66"));
        }
        Element parent = this.findElement(parentName);
        Element element = new Element();
        element.name = elementName;
        element.childPolicy = 5;
        element.minChildren = minChildren;
        element.maxChildren = maxChildren;
        this.elementHash.put(elementName, element);
        parent.children.add(elementName);
    }

    protected void addObjectValue(String elementName, Class<?> classType, int arrayMinLength, int arrayMaxLength) {
        Element element = this.findElement(elementName);
        ObjectValue objVal = new ObjectValue();
        objVal.classType = classType;
        objVal.arrayMaxLength = arrayMaxLength;
        objVal.arrayMinLength = arrayMinLength;
        objVal.valueType = 32;
        element.objectValue = objVal;
    }

    protected <T> void addObjectValue(String elementName, Class<T> classType, boolean required, T defaultValue) {
        Element element = this.findElement(elementName);
        ObjectValue objVal = new ObjectValue();
        objVal.classType = classType;
        objVal.defaultValue = defaultValue;
        objVal.valueType = 1;
        element.objectValue = objVal;
    }

    protected <T> void addObjectValue(String elementName, Class<T> classType, boolean required, T defaultValue, List<? extends T> enumeratedValues) {
        if (enumeratedValues == null || enumeratedValues.isEmpty()) {
            throw new IllegalArgumentException(Messages.getString("imageio.6A"));
        }
        try {
            for (T enumeratedValue : enumeratedValues) {
                if (enumeratedValue != null) continue;
                throw new IllegalArgumentException(Messages.getString("imageio.6B"));
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(Messages.getString("imageio.6D"));
        }
        Element element = this.findElement(elementName);
        ObjectValue objVal = new ObjectValue();
        objVal.classType = classType;
        objVal.defaultValue = defaultValue;
        objVal.enumeratedValues = enumeratedValues;
        objVal.valueType = 16;
        element.objectValue = objVal;
    }

    protected <T> void addObjectValue(String elementName, Class<T> classType, T defaultValue, Comparable<? super T> minValue, Comparable<? super T> maxValue, boolean minInclusive, boolean maxInclusive) {
        Element element = this.findElement(elementName);
        ObjectValue objVal = new ObjectValue();
        objVal.classType = classType;
        objVal.defaultValue = defaultValue;
        objVal.minValue = minValue;
        objVal.maxValue = maxValue;
        objVal.minInclusive = minInclusive;
        objVal.maxInclusive = maxInclusive;
        objVal.valueType = 2;
        objVal.valueType = objVal.valueType | (minInclusive ? 4 : 0);
        objVal.valueType = objVal.valueType | (maxInclusive ? 8 : 0);
        element.objectValue = objVal;
    }

    @Override
    public int getAttributeDataType(String elementName, String attrName) {
        Attlist attr = this.findAttribute(elementName, attrName);
        return attr.dataType;
    }

    @Override
    public String getAttributeDefaultValue(String elementName, String attrName) {
        Attlist attr = this.findAttribute(elementName, attrName);
        return attr.defaultValue;
    }

    @Override
    public String getAttributeDescription(String elementName, String attrName, Locale locale) {
        this.findAttribute(elementName, attrName);
        return this.getResourceString(elementName + "/" + attrName, locale);
    }

    @Override
    public String[] getAttributeEnumerations(String elementName, String attrName) {
        Attlist attr = this.findAttribute(elementName, attrName);
        if (attr.valueType != 16) {
            throw new IllegalArgumentException(Messages.getString("imageio.6E"));
        }
        return attr.enumeratedValues.toArray(new String[attr.enumeratedValues.size()]);
    }

    @Override
    public int getAttributeListMaxLength(String elementName, String attrName) {
        Attlist attr = this.findAttribute(elementName, attrName);
        if (attr.valueType != 32) {
            throw new IllegalArgumentException(Messages.getString("imageio.6F"));
        }
        return attr.listMaxLength;
    }

    @Override
    public int getAttributeListMinLength(String elementName, String attrName) {
        Attlist attr = this.findAttribute(elementName, attrName);
        if (attr.valueType != 32) {
            throw new IllegalArgumentException(Messages.getString("imageio.6F"));
        }
        return attr.listMinLength;
    }

    @Override
    public String getAttributeMaxValue(String elementName, String attrName) {
        Attlist attr = this.findAttribute(elementName, attrName);
        if ((attr.valueType & 2) == 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.70"));
        }
        return attr.maxValue;
    }

    @Override
    public String getAttributeMinValue(String elementName, String attrName) {
        Attlist attr = this.findAttribute(elementName, attrName);
        if ((attr.valueType & 2) == 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.70"));
        }
        return attr.minValue;
    }

    @Override
    public String[] getAttributeNames(String elementName) {
        Element element = this.findElement(elementName);
        return element.attributes.keySet().toArray(new String[element.attributes.size()]);
    }

    @Override
    public int getAttributeValueType(String elementName, String attrName) {
        Attlist attr = this.findAttribute(elementName, attrName);
        return attr.valueType;
    }

    @Override
    public String[] getChildNames(String elementName) {
        Element element = this.findElement(elementName);
        if (element.childPolicy == 0) {
            return null;
        }
        return element.children.toArray(new String[element.children.size()]);
    }

    @Override
    public int getChildPolicy(String elementName) {
        Element element = this.findElement(elementName);
        return element.childPolicy;
    }

    @Override
    public String getElementDescription(String elementName, Locale locale) {
        this.findElement(elementName);
        return this.getResourceString(elementName, locale);
    }

    @Override
    public int getElementMaxChildren(String elementName) {
        Element element = this.findElement(elementName);
        if (element.childPolicy != 5) {
            throw new IllegalArgumentException(Messages.getString("imageio.71"));
        }
        return element.maxChildren;
    }

    @Override
    public int getElementMinChildren(String elementName) {
        Element element = this.findElement(elementName);
        if (element.childPolicy != 5) {
            throw new IllegalArgumentException(Messages.getString("imageio.71"));
        }
        return element.minChildren;
    }

    @Override
    public int getObjectArrayMaxLength(String elementName) {
        Element element = this.findElement(elementName);
        ObjectValue v = element.objectValue;
        if (v == null || v.valueType != 32) {
            throw new IllegalArgumentException(Messages.getString("imageio.72"));
        }
        return v.arrayMaxLength;
    }

    @Override
    public int getObjectArrayMinLength(String elementName) {
        Element element = this.findElement(elementName);
        ObjectValue v = element.objectValue;
        if (v == null || v.valueType != 32) {
            throw new IllegalArgumentException(Messages.getString("imageio.72"));
        }
        return v.arrayMinLength;
    }

    @Override
    public Class<?> getObjectClass(String elementName) {
        ObjectValue v = this.findObjectValue(elementName);
        return v.classType;
    }

    @Override
    public Object getObjectDefaultValue(String elementName) {
        ObjectValue v = this.findObjectValue(elementName);
        return v.defaultValue;
    }

    @Override
    public Object[] getObjectEnumerations(String elementName) {
        Element element = this.findElement(elementName);
        ObjectValue v = element.objectValue;
        if (v == null || v.valueType != 16) {
            throw new IllegalArgumentException(Messages.getString("imageio.73"));
        }
        return v.enumeratedValues.toArray();
    }

    @Override
    public Comparable<?> getObjectMaxValue(String elementName) {
        Element element = this.findElement(elementName);
        ObjectValue v = element.objectValue;
        if (v == null || (v.valueType & 2) == 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.74"));
        }
        return v.maxValue;
    }

    @Override
    public Comparable<?> getObjectMinValue(String elementName) {
        Element element = this.findElement(elementName);
        ObjectValue v = element.objectValue;
        if (v == null || (v.valueType & 2) == 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.74"));
        }
        return v.minValue;
    }

    @Override
    public int getObjectValueType(String elementName) {
        Element element = this.findElement(elementName);
        if (element.objectValue == null) {
            return 0;
        }
        return element.objectValue.valueType;
    }

    protected String getResourceBaseName() {
        return this.resourceBaseName;
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    public static IIOMetadataFormat getStandardFormatInstance() {
        if (standardFormat == null) {
            standardFormat = new IIOStandardMetadataFormat();
        }
        return standardFormat;
    }

    @Override
    public boolean isAttributeRequired(String elementName, String attrName) {
        return this.findAttribute((String)elementName, (String)attrName).required;
    }

    protected void removeAttribute(String elementName, String attrName) {
        Element element = this.findElement(elementName);
        element.attributes.remove(attrName);
    }

    protected void removeElement(String elementName) {
        Element element = this.elementHash.get(elementName);
        if (element != null) {
            this.elementHash.remove(elementName);
            for (Element e : this.elementHash.values()) {
                e.children.remove(element.name);
            }
        }
    }

    protected void removeObjectValue(String elementName) {
        Element element = this.findElement(elementName);
        element.objectValue = null;
    }

    protected void setResourceBaseName(String resourceBaseName) {
        if (resourceBaseName == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.75"));
        }
        this.resourceBaseName = resourceBaseName;
    }

    private Element findElement(String name) {
        Element element = this.elementHash.get(name);
        if (element == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.8C", name));
        }
        return element;
    }

    private Attlist findAttribute(String elementName, String attributeName) {
        Element element = this.findElement(elementName);
        Attlist attribute = element.attributes.get(attributeName);
        if (attribute == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.8D", attributeName));
        }
        return attribute;
    }

    private ObjectValue findObjectValue(String elementName) {
        Element element = this.findElement(elementName);
        ObjectValue v = element.objectValue;
        if (v == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.76"));
        }
        return v;
    }

    private String getResourceString(String key, Locale locale) {
        ResourceBundle rb;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ClassLoader contextClassloader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            rb = ResourceBundle.getBundle(this.resourceBaseName, locale, contextClassloader);
        }
        catch (MissingResourceException e) {
            try {
                rb = ResourceBundle.getBundle(this.resourceBaseName, locale);
            }
            catch (MissingResourceException e1) {
                return null;
            }
        }
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private class ObjectValue<T> {
        Class<T> classType;
        int arrayMinLength;
        int arrayMaxLength;
        T defaultValue;
        List<? extends T> enumeratedValues;
        Comparable<? super T> minValue;
        Comparable<? super T> maxValue;
        boolean minInclusive;
        boolean maxInclusive;
        int valueType;

        private ObjectValue() {
        }
    }

    private class Attlist {
        String name;
        int dataType;
        boolean required;
        int listMinLength;
        int listMaxLength;
        String defaultValue;
        List<String> enumeratedValues;
        String minValue;
        String maxValue;
        boolean minInclusive;
        boolean maxInclusive;
        int valueType;

        private Attlist() {
        }
    }

    private class Element {
        String name;
        ArrayList<String> children = new ArrayList();
        HashMap<String, Attlist> attributes = new HashMap();
        int minChildren;
        int maxChildren;
        int childPolicy;
        ObjectValue objectValue;

        private Element() {
        }
    }
}

