/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public abstract class ImageReader {
    protected ImageReaderSpi originatingProvider;
    protected Object input;
    protected boolean seekForwardOnly;
    protected boolean ignoreMetadata;
    protected int minIndex;
    protected Locale[] availableLocales;
    protected Locale locale;
    protected List<IIOReadWarningListener> warningListeners;
    protected List<Locale> warningLocales;
    protected List<IIOReadProgressListener> progressListeners;
    protected List<IIOReadUpdateListener> updateListeners;
    private boolean isAborted;

    protected ImageReader(ImageReaderSpi originatingProvider) {
        this.originatingProvider = originatingProvider;
    }

    public String getFormatName() throws IOException {
        return this.originatingProvider.getFormatNames()[0];
    }

    public ImageReaderSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        if (input != null && !this.isSupported(input) && !(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException(Messages.getString("imageio.2", input));
        }
        this.minIndex = 0;
        this.seekForwardOnly = seekForwardOnly;
        this.ignoreMetadata = ignoreMetadata;
        this.input = input;
    }

    private boolean isSupported(Object input) {
        ImageReaderSpi spi = this.getOriginatingProvider();
        if (null != spi) {
            Class[] outTypes;
            for (Class element : outTypes = spi.getInputTypes()) {
                if (!element.isInstance(input)) continue;
                return true;
            }
        }
        return false;
    }

    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input, seekForwardOnly, false);
    }

    public void setInput(Object input) {
        this.setInput(input, false, false);
    }

    public Object getInput() {
        return this.input;
    }

    public boolean isSeekForwardOnly() {
        return this.seekForwardOnly;
    }

    public boolean isIgnoringMetadata() {
        return this.ignoreMetadata;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public Locale[] getAvailableLocales() {
        return this.availableLocales;
    }

    public void setLocale(Locale locale) {
        Locale[] locales;
        if (!(locale == null || (locales = this.getAvailableLocales()) != null && ImageReader.arrayContains(locales, locale))) {
            throw new IllegalArgumentException(Messages.getString("imageio.3", "Locale " + locale));
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract int getNumImages(boolean var1) throws IOException;

    public abstract int getWidth(int var1) throws IOException;

    public abstract int getHeight(int var1) throws IOException;

    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        return false;
    }

    public float getAspectRatio(int imageIndex) throws IOException {
        return (float)this.getWidth(imageIndex) / (float)this.getHeight(imageIndex);
    }

    public ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        return this.getImageTypes(imageIndex).next();
    }

    public abstract Iterator<ImageTypeSpecifier> getImageTypes(int var1) throws IOException;

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public abstract IIOMetadata getStreamMetadata() throws IOException;

    public IIOMetadata getStreamMetadata(String formatName, Set<String> nodeNames) throws IOException {
        ImageReader.iaeIfNull("formatName", formatName);
        ImageReader.iaeIfNull("nodeNames", nodeNames);
        IIOMetadata data = this.getStreamMetadata();
        return ImageReader.isSupportedFormat(formatName, data) ? data : null;
    }

    public abstract IIOMetadata getImageMetadata(int var1) throws IOException;

    public IIOMetadata getImageMetadata(int imageIndex, String formatName, Set<String> nodeNames) throws IOException {
        ImageReader.iaeIfNull("formatName", formatName);
        ImageReader.iaeIfNull("nodeNames", nodeNames);
        IIOMetadata data = this.getImageMetadata(imageIndex);
        return ImageReader.isSupportedFormat(formatName, data) ? data : null;
    }

    public BufferedImage read(int imageIndex) throws IOException {
        return this.read(imageIndex, null);
    }

    public abstract BufferedImage read(int var1, ImageReadParam var2) throws IOException;

    public IIOImage readAll(int imageIndex, ImageReadParam param) throws IOException {
        ArrayList<BufferedImage> th = null;
        BufferedImage img = this.read(imageIndex, param);
        int num = this.getNumThumbnails(imageIndex);
        if (num > 0) {
            th = new ArrayList<BufferedImage>(num);
            for (int i = 0; i < num; ++i) {
                th.add(this.readThumbnail(imageIndex, i));
            }
        }
        return new IIOImage(img, th, this.getImageMetadata(imageIndex));
    }

    public Iterator<IIOImage> readAll(Iterator<? extends ImageReadParam> params) throws IOException {
        int index = this.getMinIndex();
        LinkedList<IIOImage> list = new LinkedList<IIOImage>();
        this.processSequenceStarted(index);
        while (params.hasNext()) {
            try {
                list.add(this.readAll(index, params.next()));
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        this.processSequenceComplete();
        return list.iterator();
    }

    public boolean canReadRaster() {
        return false;
    }

    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        throw new UnsupportedOperationException(Messages.getString("imageio.7", "readRaster()"));
    }

    public boolean isImageTiled(int imageIndex) throws IOException {
        return false;
    }

    public int getTileWidth(int imageIndex) throws IOException {
        return this.getWidth(imageIndex);
    }

    public int getTileHeight(int imageIndex) throws IOException {
        return this.getHeight(imageIndex);
    }

    public int getTileGridXOffset(int imageIndex) throws IOException {
        return 0;
    }

    public int getTileGridYOffset(int imageIndex) throws IOException {
        return 0;
    }

    public BufferedImage readTile(int imageIndex, int tileX, int tileY) throws IOException {
        if (tileX != 0 || tileY != 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.5", "0", "tileX & tileY"));
        }
        return this.read(imageIndex);
    }

    public Raster readTileRaster(int imageIndex, int tileX, int tileY) throws IOException {
        if (this.canReadRaster()) {
            if (tileX != 0 || tileY != 0) {
                throw new IllegalArgumentException(Messages.getString("imageio.5", "0", "tileX & tileY"));
            }
            return this.readRaster(imageIndex, null);
        }
        throw new UnsupportedOperationException(Messages.getString("imageio.7", "readTileRaster()"));
    }

    public RenderedImage readAsRenderedImage(int imageIndex, ImageReadParam param) throws IOException {
        return this.read(imageIndex, param);
    }

    public boolean readerSupportsThumbnails() {
        return false;
    }

    public boolean hasThumbnails(int imageIndex) throws IOException {
        return this.getNumThumbnails(imageIndex) > 0;
    }

    public int getNumThumbnails(int imageIndex) throws IOException {
        return 0;
    }

    public int getThumbnailWidth(int imageIndex, int thumbnailIndex) throws IOException {
        return this.readThumbnail(imageIndex, thumbnailIndex).getWidth();
    }

    public int getThumbnailHeight(int imageIndex, int thumbnailIndex) throws IOException {
        return this.readThumbnail(imageIndex, thumbnailIndex).getHeight();
    }

    public BufferedImage readThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        throw new UnsupportedOperationException(Messages.getString("imageio.7", "readThumbnail()"));
    }

    public void abort() {
        this.isAborted = true;
    }

    protected boolean abortRequested() {
        return this.isAborted;
    }

    protected void clearAbortRequest() {
        this.isAborted = false;
    }

    public void addIIOReadWarningListener(IIOReadWarningListener listener) {
        if (listener != null) {
            this.warningListeners = ImageReader.addToList(this.warningListeners, listener);
            this.warningLocales = ImageReader.addToList(this.warningLocales, this.getLocale());
        }
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener listener) {
        int ind;
        if (this.warningListeners != null && listener != null && (ind = this.warningListeners.indexOf(listener)) != -1) {
            this.warningListeners.remove(ind);
            this.warningLocales.remove(ind);
        }
    }

    public void removeAllIIOReadWarningListeners() {
        this.warningListeners = null;
        this.warningLocales = null;
    }

    public void addIIOReadProgressListener(IIOReadProgressListener listener) {
        if (listener != null) {
            this.progressListeners = ImageReader.addToList(this.progressListeners, listener);
        }
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener listener) {
        if (this.progressListeners != null && listener != null) {
            this.progressListeners.remove(listener);
        }
    }

    public void removeAllIIOReadProgressListeners() {
        this.progressListeners = null;
    }

    public void addIIOReadUpdateListener(IIOReadUpdateListener listener) {
        if (listener != null) {
            this.updateListeners = ImageReader.addToList(this.updateListeners, listener);
        }
    }

    public void removeIIOReadUpdateListener(IIOReadUpdateListener listener) {
        if (this.updateListeners != null && listener != null) {
            this.updateListeners.remove(listener);
        }
    }

    public void removeAllIIOReadUpdateListeners() {
        this.updateListeners = null;
    }

    protected void processSequenceStarted(int minIndex) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.sequenceStarted(this, minIndex);
            }
        }
    }

    protected void processSequenceComplete() {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.sequenceComplete(this);
            }
        }
    }

    protected void processImageStarted(int imageIndex) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.imageStarted(this, imageIndex);
            }
        }
    }

    protected void processImageProgress(float percentageDone) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.imageProgress(this, percentageDone);
            }
        }
    }

    protected void processImageComplete() {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.imageComplete(this);
            }
        }
    }

    protected void processThumbnailStarted(int imageIndex, int thumbnailIndex) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.thumbnailStarted(this, imageIndex, thumbnailIndex);
            }
        }
    }

    protected void processThumbnailProgress(float percentageDone) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.thumbnailProgress(this, percentageDone);
            }
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.thumbnailComplete(this);
            }
        }
    }

    protected void processReadAborted() {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.readAborted(this);
            }
        }
    }

    protected void processPassStarted(BufferedImage theImage, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.passStarted(this, theImage, pass, minPass, maxPass, minX, minY, periodX, periodY, bands);
            }
        }
    }

    protected void processImageUpdate(BufferedImage theImage, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.imageUpdate(this, theImage, minX, minY, width, height, periodX, periodY, bands);
            }
        }
    }

    protected void processPassComplete(BufferedImage theImage) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.passComplete(this, theImage);
            }
        }
    }

    protected void processThumbnailPassStarted(BufferedImage theThumbnail, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.thumbnailPassStarted(this, theThumbnail, pass, minPass, maxPass, minX, minY, periodX, periodY, bands);
            }
        }
    }

    protected void processThumbnailUpdate(BufferedImage theThumbnail, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.thumbnailUpdate(this, theThumbnail, minX, minY, width, height, periodX, periodY, bands);
            }
        }
    }

    protected void processThumbnailPassComplete(BufferedImage theThumbnail) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.thumbnailPassComplete(this, theThumbnail);
            }
        }
    }

    protected void processWarningOccurred(String warning) {
        if (this.warningListeners != null) {
            ImageReader.iaeIfNull("warning", warning);
            for (IIOReadWarningListener listener : this.warningListeners) {
                listener.warningOccurred(this, warning);
            }
        }
    }

    protected void processWarningOccurred(String baseName, String keyword) {
        if (this.warningListeners != null) {
            int i = 0;
            ImageReader.iaeIfNull("keyword", keyword);
            ImageReader.iaeIfNull("baseName", baseName);
            for (IIOReadWarningListener listener : this.warningListeners) {
                try {
                    Locale locale = this.warningLocales.get(i);
                    ResourceBundle bundle = locale != null ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName);
                    listener.warningOccurred(this, bundle.getString(keyword));
                }
                catch (RuntimeException ex) {
                    throw new IllegalArgumentException(ex.getMessage());
                }
                ++i;
            }
        }
    }

    public void reset() {
        this.setInput(null, false);
        this.setLocale(null);
        this.removeAllIIOReadUpdateListeners();
        this.removeAllIIOReadWarningListeners();
        this.removeAllIIOReadProgressListeners();
        this.clearAbortRequest();
    }

    public void dispose() {
    }

    protected static Rectangle getSourceRegion(ImageReadParam param, int srcWidth, int srcHeight) {
        Rectangle r = new Rectangle(0, 0, srcWidth, srcHeight);
        if (param != null) {
            Rectangle sr = param.getSourceRegion();
            if (sr != null) {
                r.setBounds(r.intersection(sr));
            }
            int x = param.getSubsamplingXOffset();
            int y = param.getSubsamplingYOffset();
            r.x += x;
            r.y += y;
            r.width -= x;
            r.height -= y;
        }
        return r;
    }

    protected static void computeRegions(ImageReadParam param, int srcWidth, int srcHeight, BufferedImage image, Rectangle srcRegion, Rectangle destRegion) {
        int shift;
        int xCols = 1;
        int yCols = 1;
        ImageReader.iaeIfNull("srcRegion", srcRegion);
        ImageReader.iaeIfNull("destRegion", destRegion);
        ImageReader.iaeIfEmpty("srcRegion", srcRegion.isEmpty());
        ImageReader.iaeIfEmpty("destRegion", destRegion.isEmpty());
        srcRegion.setBounds(ImageReader.getSourceRegion(param, srcWidth, srcHeight));
        if (param != null) {
            destRegion.setLocation(param.getDestinationOffset());
            xCols = param.getSourceXSubsampling();
            yCols = param.getSourceYSubsampling();
        }
        if (destRegion.x < 0) {
            shift = -destRegion.x * xCols;
            srcRegion.x += shift;
            srcRegion.width -= shift;
            destRegion.x = 0;
        }
        if (destRegion.y < 0) {
            shift = -destRegion.y * yCols;
            srcRegion.y += shift;
            srcRegion.height -= shift;
            destRegion.y = 0;
        }
        destRegion.width = srcRegion.width / xCols;
        destRegion.height = srcRegion.height / yCols;
        if (image != null) {
            destRegion.setBounds(destRegion.intersection(new Rectangle(0, 0, image.getWidth(), image.getHeight())));
        }
    }

    protected static void checkReadParamBandSettings(ImageReadParam param, int numSrcBands, int numDstBands) {
        int i;
        int dstLen;
        int[] src = param != null ? param.getSourceBands() : null;
        int[] dst = param != null ? param.getDestinationBands() : null;
        int srcLen = src != null ? src.length : numSrcBands;
        int n = dstLen = dst != null ? dst.length : numDstBands;
        if (srcLen != dstLen) {
            throw new IllegalArgumentException("srcLen != dstLen");
        }
        if (src != null) {
            for (i = 0; i < srcLen; ++i) {
                if (src[i] < numSrcBands) continue;
                throw new IllegalArgumentException("src[" + i + "] >= numSrcBands");
            }
        }
        if (dst != null) {
            for (i = 0; i < dstLen; ++i) {
                if (dst[i] < numDstBands) continue;
                throw new IllegalArgumentException("dst[" + i + "] >= numDstBands");
            }
        }
    }

    protected static BufferedImage getDestination(ImageReadParam param, Iterator<ImageTypeSpecifier> imageTypes, int width, int height) throws IIOException {
        ImageTypeSpecifier its;
        block7: {
            ImageReader.iaeIfNull("imageTypes", imageTypes);
            ImageReader.iaeIfEmpty("imageTypes", !imageTypes.hasNext());
            if ((long)(width * height) > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("width * height > Integer.MAX_VALUE!");
            }
            its = null;
            if (param != null) {
                BufferedImage img = param.getDestination();
                if (img != null) {
                    return img;
                }
                its = param.getDestinationType();
            }
            try {
                if (its != null) {
                    while (imageTypes.hasNext()) {
                        if (!its.equals(imageTypes.next())) continue;
                        break block7;
                    }
                    throw new IIOException(Messages.getString("imageio.3", its));
                }
                its = imageTypes.next();
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        Rectangle dst = new Rectangle(0, 0, 0, 0);
        ImageReader.computeRegions(param, width, height, null, new Rectangle(0, 0, 0, 0), dst);
        return its.createBufferedImage(dst.width, dst.height);
    }

    private static <T> List<T> addToList(List<T> list, T value) {
        if (list == null) {
            list = new LinkedList<T>();
        }
        list.add(value);
        return list;
    }

    private static void iaeIfNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.2", name));
        }
    }

    private static void iaeIfEmpty(String name, boolean isEmpty) {
        if (isEmpty) {
            throw new IllegalArgumentException(Messages.getString("imageio.6", name));
        }
    }

    private static <T> boolean arrayContains(T[] array, Object value) {
        for (T t : array) {
            if (t != value && (t == null || !t.equals(value))) continue;
            return true;
        }
        return false;
    }

    private static boolean isSupportedFormat(String formatName, IIOMetadata data) {
        String[] names;
        return data != null && (names = data.getMetadataFormatNames()) != null ? ImageReader.arrayContains(names, formatName) : false;
    }
}

