/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import org.apache.harmony.awt.internal.nls.Messages;

public class WritableRaster
extends Raster {
    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle aRegion, Point sampleModelTranslate, WritableRaster parent) {
        super(sampleModel, dataBuffer, aRegion, sampleModelTranslate, parent);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point origin) {
        this(sampleModel, dataBuffer, new Rectangle(origin.x, origin.y, sampleModel.width, sampleModel.height), origin, null);
    }

    protected WritableRaster(SampleModel sampleModel, Point origin) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(origin.x, origin.y, sampleModel.width, sampleModel.height), origin, null);
    }

    public void setDataElements(int x, int y, Object inData) {
        this.sampleModel.setDataElements(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, inData, this.dataBuffer);
    }

    public void setDataElements(int x, int y, int w, int h, Object inData) {
        this.sampleModel.setDataElements(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, inData, this.dataBuffer);
    }

    public WritableRaster createWritableChild(int parentX, int parentY, int w, int h, int childMinX, int childMinY, int[] bandList) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.244"));
        }
        if (parentX < this.minX || parentX + w > this.minX + this.width) {
            throw new RasterFormatException(Messages.getString("awt.245"));
        }
        if (parentY < this.minY || parentY + h > this.minY + this.height) {
            throw new RasterFormatException(Messages.getString("awt.246"));
        }
        if ((long)parentX + (long)w > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.247"));
        }
        if ((long)parentY + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.248"));
        }
        if ((long)childMinX + (long)w > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.249"));
        }
        if ((long)childMinY + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.24A"));
        }
        SampleModel childModel = bandList == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(bandList);
        int childTranslateX = childMinX - parentX;
        int childTranslateY = childMinY - parentY;
        return new WritableRaster(childModel, this.dataBuffer, new Rectangle(childMinX, childMinY, w, h), new Point(childTranslateX + this.sampleModelTranslateX, childTranslateY + this.sampleModelTranslateY), this);
    }

    public WritableRaster createWritableTranslatedChild(int childMinX, int childMinY) {
        return this.createWritableChild(this.minX, this.minY, this.width, this.height, childMinX, childMinY, null);
    }

    public WritableRaster getWritableParent() {
        return (WritableRaster)this.parent;
    }

    public void setRect(Raster srcRaster) {
        this.setRect(0, 0, srcRaster);
    }

    public void setRect(int dx, int dy, Raster srcRaster) {
        int w = srcRaster.getWidth();
        int h = srcRaster.getHeight();
        int srcX = srcRaster.getMinX();
        int srcY = srcRaster.getMinY();
        int dstX = srcX + dx;
        int dstY = srcY + dy;
        if (dstX < this.minX) {
            int minOffX = this.minX - dstX;
            w -= minOffX;
            dstX = this.minX;
            srcX += minOffX;
        }
        if (dstY < this.minY) {
            int minOffY = this.minY - dstY;
            h -= minOffY;
            dstY = this.minY;
            srcY += minOffY;
        }
        if (dstX + w > this.minX + this.width) {
            int maxOffX = dstX + w - (this.minX + this.width);
            w -= maxOffX;
        }
        if (dstY + h > this.minY + this.height) {
            int maxOffY = dstY + h - (this.minY + this.height);
            h -= maxOffY;
        }
        if (w <= 0 || h <= 0) {
            return;
        }
        switch (this.sampleModel.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] iPixelsLine = null;
                for (int i = 0; i < h; ++i) {
                    iPixelsLine = srcRaster.getPixels(srcX, srcY + i, w, 1, iPixelsLine);
                    this.setPixels(dstX, dstY + i, w, 1, iPixelsLine);
                }
                break;
            }
            case 4: {
                float[] fPixelsLine = null;
                for (int i = 0; i < h; ++i) {
                    fPixelsLine = srcRaster.getPixels(srcX, srcY + i, w, 1, fPixelsLine);
                    this.setPixels(dstX, dstY + i, w, 1, fPixelsLine);
                }
                break;
            }
            case 5: {
                double[] dPixelsLine = null;
                for (int i = 0; i < h; ++i) {
                    dPixelsLine = srcRaster.getPixels(srcX, srcY + i, w, 1, dPixelsLine);
                    this.setPixels(dstX, dstY + i, w, 1, dPixelsLine);
                }
                break;
            }
        }
    }

    public void setDataElements(int x, int y, Raster inRaster) {
        int dstX = x + inRaster.getMinX();
        int dstY = y + inRaster.getMinY();
        int w = inRaster.getWidth();
        int h = inRaster.getHeight();
        if (dstX < this.minX || dstX + w > this.minX + this.width || dstY < this.minY || dstY + h > this.minY + this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int srcX = inRaster.getMinX();
        int srcY = inRaster.getMinY();
        Object line = null;
        for (int i = 0; i < h; ++i) {
            line = inRaster.getDataElements(srcX, srcY + i, w, 1, line);
            this.setDataElements(dstX, dstY + i, w, 1, line);
        }
    }

    public void setPixel(int x, int y, int[] iArray) {
        this.sampleModel.setPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, iArray, this.dataBuffer);
    }

    public void setPixel(int x, int y, float[] fArray) {
        this.sampleModel.setPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public void setPixel(int x, int y, double[] dArray) {
        this.sampleModel.setPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public void setPixels(int x, int y, int w, int h, int[] iArray) {
        this.sampleModel.setPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, iArray, this.dataBuffer);
    }

    public void setPixels(int x, int y, int w, int h, float[] fArray) {
        this.sampleModel.setPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, fArray, this.dataBuffer);
    }

    public void setPixels(int x, int y, int w, int h, double[] dArray) {
        this.sampleModel.setPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, dArray, this.dataBuffer);
    }

    public void setSamples(int x, int y, int w, int h, int b, int[] iArray) {
        this.sampleModel.setSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, iArray, this.dataBuffer);
    }

    public void setSamples(int x, int y, int w, int h, int b, float[] fArray) {
        this.sampleModel.setSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, fArray, this.dataBuffer);
    }

    public void setSamples(int x, int y, int w, int h, int b, double[] dArray) {
        this.sampleModel.setSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, dArray, this.dataBuffer);
    }

    public void setSample(int x, int y, int b, int s) {
        this.sampleModel.setSample(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, s, this.dataBuffer);
    }

    public void setSample(int x, int y, int b, float s) {
        this.sampleModel.setSample(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, s, this.dataBuffer);
    }

    public void setSample(int x, int y, int b, double s) {
        this.sampleModel.setSample(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, s, this.dataBuffer);
    }
}

