/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.internal.nls.Messages;

public class RescaleOp
implements BufferedImageOp,
RasterOp {
    private float[] scaleFactors;
    private float[] offsets;
    private RenderingHints hints;

    public RescaleOp(float[] scaleFactors, float[] offsets, RenderingHints hints) {
        int numFactors = Math.min(scaleFactors.length, offsets.length);
        this.scaleFactors = new float[numFactors];
        this.offsets = new float[numFactors];
        System.arraycopy(scaleFactors, 0, this.scaleFactors, 0, numFactors);
        System.arraycopy(offsets, 0, this.offsets, 0, numFactors);
        this.hints = hints;
    }

    public RescaleOp(float scaleFactor, float offset, RenderingHints hints) {
        this.scaleFactors = new float[1];
        this.offsets = new float[1];
        this.scaleFactors[0] = scaleFactor;
        this.offsets[0] = offset;
        this.hints = hints;
    }

    public final int getNumFactors() {
        return this.scaleFactors.length;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final float[] getScaleFactors(float[] scaleFactors) {
        if (scaleFactors == null) {
            scaleFactors = new float[this.scaleFactors.length];
        }
        int minLength = Math.min(scaleFactors.length, this.scaleFactors.length);
        System.arraycopy(this.scaleFactors, 0, scaleFactors, 0, minLength);
        return scaleFactors;
    }

    public final float[] getOffsets(float[] offsets) {
        if (offsets == null) {
            offsets = new float[this.offsets.length];
        }
        int minLength = Math.min(offsets.length, this.offsets.length);
        System.arraycopy(this.offsets, 0, offsets, 0, minLength);
        return offsets;
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Float();
        }
        dstPt.setLocation(srcPt);
        return dstPt;
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM == null) {
            dstCM = src.getColorModel();
        }
        if (dstCM instanceof IndexColorModel) {
            dstCM = ColorModel.getRGBdefault();
        }
        WritableRaster r = dstCM.isCompatibleSampleModel(src.getSampleModel()) ? src.getRaster().createCompatibleWritableRaster(src.getWidth(), src.getHeight()) : dstCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        return new BufferedImage(dstCM, r, dstCM.isAlphaPremultiplied(), null);
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dst) {
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException(Messages.getString("awt.21D", src.getNumBands(), dst.getNumBands()));
        }
        if (this.scaleFactors.length != 1 && this.scaleFactors.length != src.getNumBands()) {
            throw new IllegalArgumentException(Messages.getString("awt.21E"));
        }
        if (this.slowFilter(src, dst, false) != 0) {
            throw new ImagingOpException(Messages.getString("awt.21F"));
        }
        return dst;
    }

    private final int slowFilter(Raster src, WritableRaster dst, boolean skipAlpha) {
        SampleModel sm = src.getSampleModel();
        int numBands = src.getNumBands();
        int srcHeight = src.getHeight();
        int srcWidth = src.getWidth();
        int srcMinX = src.getMinX();
        int srcMinY = src.getMinY();
        int dstMinX = dst.getMinX();
        int dstMinY = dst.getMinY();
        int[] maxValues = new int[numBands];
        int[] masks = new int[numBands];
        int[] sampleSizes = sm.getSampleSize();
        for (int i = 0; i < numBands; ++i) {
            maxValues[i] = (1 << sampleSizes[i]) - 1;
            masks[i] = ~maxValues[i];
        }
        float[] pixels = null;
        pixels = src.getPixels(srcMinX, srcMinY, srcWidth, srcHeight, pixels);
        if (skipAlpha) {
            if (this.scaleFactors.length > 1) {
                for (int i = 0; i < pixels.length; ++i) {
                    int bandIdx = 0;
                    while (bandIdx < numBands - 1) {
                        pixels[i] = pixels[i] * this.scaleFactors[bandIdx] + this.offsets[bandIdx];
                        if (((int)pixels[i] & masks[bandIdx]) != 0) {
                            pixels[i] = pixels[i] < 0.0f ? 0.0f : (float)maxValues[bandIdx];
                        }
                        ++bandIdx;
                        ++i;
                    }
                }
            } else {
                for (int i = 0; i < pixels.length; ++i) {
                    int bandIdx = 0;
                    while (bandIdx < numBands - 1) {
                        pixels[i] = pixels[i] * this.scaleFactors[0] + this.offsets[0];
                        if (((int)pixels[i] & masks[bandIdx]) != 0) {
                            pixels[i] = pixels[i] < 0.0f ? 0.0f : (float)maxValues[bandIdx];
                        }
                        ++bandIdx;
                        ++i;
                    }
                }
            }
        } else if (this.scaleFactors.length > 1) {
            int i = 0;
            while (i < pixels.length) {
                int bandIdx = 0;
                while (bandIdx < numBands) {
                    pixels[i] = pixels[i] * this.scaleFactors[bandIdx] + this.offsets[bandIdx];
                    if (((int)pixels[i] & masks[bandIdx]) != 0) {
                        pixels[i] = pixels[i] < 0.0f ? 0.0f : (float)maxValues[bandIdx];
                    }
                    ++bandIdx;
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < pixels.length) {
                int bandIdx = 0;
                while (bandIdx < numBands) {
                    pixels[i] = pixels[i] * this.scaleFactors[0] + this.offsets[0];
                    if (((int)pixels[i] & masks[bandIdx]) != 0) {
                        pixels[i] = pixels[i] < 0.0f ? 0.0f : (float)maxValues[bandIdx];
                    }
                    ++bandIdx;
                    ++i;
                }
            }
        }
        dst.setPixels(dstMinX, dstMinY, srcWidth, srcHeight, pixels);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        boolean skipAlpha;
        ColorModel srcCM = src.getColorModel();
        if (srcCM instanceof IndexColorModel) {
            throw new IllegalArgumentException(Messages.getString("awt.220"));
        }
        int nComponents = srcCM.getNumComponents();
        if (srcCM.hasAlpha()) {
            if (this.scaleFactors.length == 1 || this.scaleFactors.length == nComponents - 1) {
                skipAlpha = true;
            } else {
                if (this.scaleFactors.length != nComponents) throw new IllegalArgumentException(Messages.getString("awt.21E"));
                skipAlpha = false;
            }
        } else {
            if (this.scaleFactors.length != 1) {
                if (this.scaleFactors.length != nComponents) throw new IllegalArgumentException(Messages.getString("awt.21E"));
            }
            skipAlpha = false;
        }
        BufferedImage finalDst = null;
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, srcCM);
        } else if (!srcCM.equals(dst.getColorModel()) && (src.getType() != 1 && src.getType() != 2 || dst.getType() != 1 && dst.getType() != 2)) {
            finalDst = dst;
            dst = this.createCompatibleDestImage(src, srcCM);
        }
        if (this.slowFilter(src.getRaster(), dst.getRaster(), skipAlpha) != 0) {
            throw new ImagingOpException(Messages.getString("awt.21F"));
        }
        if (finalDst == null) return dst;
        Graphics2D g = finalDst.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)dst, 0, 0, null);
        return finalDst;
    }
}

