/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.harmony.awt.internal.nls.Messages;

public class MemoryImageSource
implements ImageProducer {
    int width;
    int height;
    ColorModel cm;
    byte[] bData;
    int[] iData;
    int offset;
    int scanline;
    Hashtable<?, ?> properties;
    Vector<ImageConsumer> consumers;
    boolean animated;
    boolean fullbuffers;
    int dataType;
    static final int DATA_TYPE_BYTE = 0;
    static final int DATA_TYPE_INT = 1;

    public MemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan, Hashtable<?, ?> props) {
        this.init(w, h, cm, pix, off, scan, props);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan, Hashtable<?, ?> props) {
        this.init(w, h, cm, pix, off, scan, props);
    }

    public MemoryImageSource(int w, int h, int[] pix, int off, int scan, Hashtable<?, ?> props) {
        this.init(w, h, ColorModel.getRGBdefault(), pix, off, scan, props);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan) {
        this.init(w, h, cm, pix, off, scan, null);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan) {
        this.init(w, h, cm, pix, off, scan, (Hashtable<?, ?>)null);
    }

    public MemoryImageSource(int w, int h, int[] pix, int off, int scan) {
        this.init(w, h, ColorModel.getRGBdefault(), pix, off, scan, null);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        block7: {
            if (!this.isConsumer(ic) && ic != null) {
                this.consumers.addElement(ic);
            }
            try {
                this.setHeader(ic);
                this.setPixels(ic, 0, 0, this.width, this.height);
                if (this.animated) {
                    ic.imageComplete(2);
                } else {
                    ic.imageComplete(3);
                    if (this.isConsumer(ic)) {
                        this.removeConsumer(ic);
                    }
                }
            }
            catch (Exception e) {
                if (this.isConsumer(ic)) {
                    ic.imageComplete(1);
                }
                if (!this.isConsumer(ic)) break block7;
                this.removeConsumer(ic);
            }
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        this.consumers.removeElement(ic);
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        if (ic == null || this.consumers.contains(ic)) {
            return;
        }
        this.consumers.addElement(ic);
    }

    public synchronized void newPixels(int[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.dataType = 1;
        this.iData = newpix;
        this.cm = newmodel;
        this.offset = offset;
        this.scanline = scansize;
        this.newPixels();
    }

    public synchronized void newPixels(byte[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.dataType = 0;
        this.bData = newpix;
        this.cm = newmodel;
        this.offset = offset;
        this.scanline = scansize;
        this.newPixels();
    }

    public synchronized void setFullBufferUpdates(boolean fullbuffers) {
        if (this.fullbuffers == fullbuffers) {
            return;
        }
        this.fullbuffers = fullbuffers;
        if (this.animated) {
            Object[] consAr;
            for (Object element : consAr = this.consumers.toArray()) {
                ImageConsumer con = (ImageConsumer)element;
                try {
                    if (fullbuffers) {
                        con.setHints(6);
                        continue;
                    }
                    con.setHints(1);
                }
                catch (Exception e) {
                    if (this.isConsumer(con)) {
                        con.imageComplete(1);
                    }
                    if (!this.isConsumer(con)) continue;
                    this.removeConsumer(con);
                }
            }
        }
    }

    public synchronized void setAnimated(boolean animated) {
        Object[] consAr;
        if (this.animated == animated) {
            return;
        }
        for (Object element : consAr = this.consumers.toArray()) {
            ImageConsumer con;
            block4: {
                con = (ImageConsumer)element;
                try {
                    con.imageComplete(3);
                }
                catch (Exception e) {
                    if (!this.isConsumer(con)) break block4;
                    con.imageComplete(1);
                }
            }
            if (!this.isConsumer(con)) continue;
            this.removeConsumer(con);
        }
        this.animated = animated;
    }

    public synchronized void newPixels(int x, int y, int w, int h, boolean framenotify) {
        if (this.animated) {
            Object[] consAr;
            if (this.fullbuffers) {
                x = 0;
                y = 0;
                w = this.width;
                h = this.height;
            } else {
                if (x < 0) {
                    w += x;
                    x = 0;
                }
                if (w > this.width) {
                    w = this.width - x;
                }
                if (y < 0) {
                    h += y;
                    y = 0;
                }
            }
            if (h > this.height) {
                h = this.height - y;
            }
            for (Object element : consAr = this.consumers.toArray()) {
                ImageConsumer con = (ImageConsumer)element;
                try {
                    if (w > 0 && h > 0) {
                        this.setPixels(con, x, y, w, h);
                    }
                    if (!framenotify) continue;
                    con.imageComplete(2);
                }
                catch (Exception ex) {
                    if (this.isConsumer(con)) {
                        con.imageComplete(1);
                    }
                    if (!this.isConsumer(con)) continue;
                    this.removeConsumer(con);
                }
            }
        }
    }

    public synchronized void newPixels(int x, int y, int w, int h) {
        this.newPixels(x, y, w, h, true);
    }

    public void newPixels() {
        this.newPixels(0, 0, this.width, this.height, true);
    }

    private void init(int width, int height, ColorModel model, byte[] pixels, int off, int scan, Hashtable<?, ?> prop) {
        this.width = width;
        this.height = height;
        this.cm = model;
        this.bData = pixels;
        this.offset = off;
        this.scanline = scan;
        this.properties = prop;
        this.dataType = 0;
        this.consumers = new Vector();
    }

    private void init(int width, int height, ColorModel model, int[] pixels, int off, int scan, Hashtable<?, ?> prop) {
        this.width = width;
        this.height = height;
        this.cm = model;
        this.iData = pixels;
        this.offset = off;
        this.scanline = scan;
        this.properties = prop;
        this.dataType = 1;
        this.consumers = new Vector();
    }

    private void setPixels(ImageConsumer con, int x, int y, int w, int h) {
        int pixelOff = this.scanline * y + this.offset + x;
        switch (this.dataType) {
            case 0: {
                con.setPixels(x, y, w, h, this.cm, this.bData, pixelOff, this.scanline);
                break;
            }
            case 1: {
                con.setPixels(x, y, w, h, this.cm, this.iData, pixelOff, this.scanline);
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.22A"));
            }
        }
    }

    private synchronized void setHeader(ImageConsumer con) {
        con.setDimensions(this.width, this.height);
        con.setProperties(this.properties);
        con.setColorModel(this.cm);
        con.setHints(this.animated ? (this.fullbuffers ? 6 : 1) : 30);
    }
}

