/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.math.BigInteger;
import org.apache.harmony.awt.internal.nls.Messages;

public class IndexColorModel
extends ColorModel {
    private int[] colorMap;
    private int mapSize;
    private int transparentIndex;
    private boolean grayPalette;
    private BigInteger validBits;
    private static final int CACHESIZE = 20;
    private final int[] cachetable = new int[40];
    private int nextInsertIdx = 0;
    private int totalInserted = 0;

    public IndexColorModel(int bits, int size, int[] cmap, int start, int transferType, BigInteger validBits) {
        super(bits, IndexColorModel.createBits(true), ColorSpace.getInstance(1000), true, false, 1, IndexColorModel.validateTransferType(transferType));
        int i;
        if (size < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.264"));
        }
        this.mapSize = size;
        this.colorMap = new int[this.mapSize];
        this.transparentIndex = -1;
        if (validBits != null && (i = 0) < this.mapSize && !validBits.testBit(i)) {
            this.validBits = validBits;
        }
        this.transparency = 1;
        int alphaMask = -16777216;
        int alpha = 0;
        int i2 = 0;
        while (i2 < this.mapSize) {
            this.colorMap[i2] = cmap[start];
            alpha = cmap[start] & alphaMask;
            if (alpha != alphaMask) {
                if (alpha == 0) {
                    if (this.transparentIndex < 0) {
                        this.transparentIndex = i2;
                    }
                    if (this.transparency == 1) {
                        this.transparency = 2;
                    }
                } else if (alpha != alphaMask && this.transparency != 3) {
                    this.transparency = 3;
                }
            }
            ++i2;
            ++start;
        }
        this.checkPalette();
    }

    public IndexColorModel(int bits, int size, int[] cmap, int start, boolean hasalpha, int trans, int transferType) {
        super(bits, IndexColorModel.createBits(hasalpha || trans >= 0), ColorSpace.getInstance(1000), hasalpha || trans >= 0, false, 1, IndexColorModel.validateTransferType(transferType));
        if (size < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.264"));
        }
        this.mapSize = size;
        this.colorMap = new int[this.mapSize];
        if (trans >= 0 && trans < this.mapSize) {
            this.transparentIndex = trans;
            this.transparency = 2;
        } else {
            this.transparentIndex = -1;
            this.transparency = 1;
        }
        int alphaMask = -16777216;
        int alpha = 0;
        int i = 0;
        while (i < this.mapSize) {
            if (this.transparentIndex == i) {
                this.colorMap[i] = cmap[start] & 0xFFFFFF;
            } else if (hasalpha) {
                alpha = cmap[start] & alphaMask;
                this.colorMap[i] = cmap[start];
                if (alpha != alphaMask) {
                    if (alpha == 0) {
                        if (trans < 0) {
                            trans = i;
                        }
                        if (this.transparency == 1) {
                            this.transparency = 2;
                        }
                    } else if (alpha != 0 && this.transparency != 3) {
                        this.transparency = 3;
                    }
                }
            } else {
                this.colorMap[i] = alphaMask | cmap[start];
            }
            ++i;
            ++start;
        }
        this.checkPalette();
    }

    public IndexColorModel(int bits, int size, byte[] r, byte[] g, byte[] b, byte[] a) {
        super(bits, IndexColorModel.createBits(true), ColorSpace.getInstance(1000), true, false, 1, IndexColorModel.validateTransferType(ColorModel.getTransferType(bits)));
        this.createColorMap(size, r, g, b, a, -1);
        this.checkPalette();
    }

    public IndexColorModel(int bits, int size, byte[] r, byte[] g, byte[] b, int trans) {
        super(bits, IndexColorModel.createBits(trans >= 0), ColorSpace.getInstance(1000), trans >= 0, false, 1, IndexColorModel.validateTransferType(ColorModel.getTransferType(bits)));
        this.createColorMap(size, r, g, b, null, trans);
        this.checkPalette();
    }

    public IndexColorModel(int bits, int size, byte[] r, byte[] g, byte[] b) {
        super(bits, IndexColorModel.createBits(false), ColorSpace.getInstance(1000), false, false, 1, IndexColorModel.validateTransferType(ColorModel.getTransferType(bits)));
        this.createColorMap(size, r, g, b, null, -1);
        this.checkPalette();
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasalpha, int trans) {
        super(bits, IndexColorModel.createBits(hasalpha || trans >= 0), ColorSpace.getInstance(1000), hasalpha || trans >= 0, false, 1, IndexColorModel.validateTransferType(ColorModel.getTransferType(bits)));
        if (size < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.264"));
        }
        this.mapSize = size;
        this.colorMap = new int[this.mapSize];
        this.transparentIndex = -1;
        this.transparency = 1;
        int alpha = -16777216;
        for (int i = 0; i < this.mapSize; ++i) {
            this.colorMap[i] = (cmap[start++] & 0xFF) << 16 | (cmap[start++] & 0xFF) << 8 | cmap[start++] & 0xFF;
            if (trans == i) {
                if (this.transparency == 1) {
                    this.transparency = 2;
                }
                if (!hasalpha) continue;
                ++start;
                continue;
            }
            if (hasalpha) {
                if ((alpha = cmap[start++] & 0xFF) == 0) {
                    if (this.transparency == 1) {
                        this.transparency = 2;
                        if (trans < 0) {
                            trans = i;
                        }
                    }
                } else if (alpha != 255 && this.transparency != 3) {
                    this.transparency = 3;
                }
                alpha <<= 24;
            }
            int n = i;
            this.colorMap[n] = this.colorMap[n] | alpha;
        }
        if (trans >= 0 && trans < this.mapSize) {
            this.transparentIndex = trans;
        }
        this.checkPalette();
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasalpha) {
        this(bits, size, cmap, start, hasalpha, -1);
    }

    @Override
    public Object getDataElements(int[] components, int offset, Object pixel) {
        int rgb = components[offset] << 16 | components[offset + 1] << 8 | components[offset + 2];
        rgb = this.hasAlpha ? (rgb |= components[offset + 3] << 24) : (rgb |= 0xFF000000);
        return this.getDataElements(rgb, pixel);
    }

    @Override
    public synchronized Object getDataElements(int rgb, Object pixel) {
        int minError;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        int alpha = rgb >>> 24;
        int pixIdx = 0;
        for (int i = 0; i < this.totalInserted; ++i) {
            int idx = i * 2;
            if (rgb != this.cachetable[idx]) continue;
            return this.createDataObject(this.cachetable[idx + 1], pixel);
        }
        if (!this.hasAlpha && this.grayPalette) {
            int grey = red * 77 + green * 150 + blue * 29 + 128 >>> 8;
            minError = 255;
            int error = 0;
            for (int i = 0; i < this.mapSize; ++i) {
                error = Math.abs((this.colorMap[i] & 0xFF) - grey);
                if (error >= minError) continue;
                pixIdx = i;
                if (error != 0) {
                    minError = error;
                    continue;
                }
                break;
            }
        } else if (alpha == 0 && this.transparentIndex > -1) {
            pixIdx = this.transparentIndex;
        } else {
            int minAlphaError = 255;
            minError = 195075;
            int error = 0;
            for (int i = 0; i < this.mapSize; ++i) {
                int pix = this.colorMap[i];
                if (rgb == pix) {
                    pixIdx = i;
                    break;
                }
                int alphaError = Math.abs(alpha - (pix >>> 24));
                if (alphaError > minAlphaError) continue;
                minAlphaError = alphaError;
                int buf = (pix >> 16 & 0xFF) - red;
                error = buf * buf;
                if (error >= minError || (error += (buf = (pix >> 8 & 0xFF) - green) * buf) >= minError || (error += (buf = (pix & 0xFF) - blue) * buf) >= minError) continue;
                pixIdx = i;
                minError = error;
            }
        }
        this.cachetable[this.nextInsertIdx] = rgb;
        this.cachetable[this.nextInsertIdx + 1] = pixIdx;
        this.nextInsertIdx = (this.nextInsertIdx + 2) % 40;
        if (this.totalInserted < 20) {
            ++this.totalInserted;
        }
        return this.createDataObject(pixIdx, pixel);
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean forceARGB) {
        if (!this.isCompatibleRaster(raster)) {
            throw new IllegalArgumentException(Messages.getString("awt.265"));
        }
        ColorModel model = forceARGB || this.transparency == 3 ? ColorModel.getRGBdefault() : (this.transparency == 2 ? new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000) : new DirectColorModel(24, 0xFF0000, 65280, 255));
        int w = raster.getWidth();
        int h = raster.getHeight();
        WritableRaster distRaster = model.createCompatibleWritableRaster(w, h);
        int minX = raster.getMinX();
        int minY = raster.getMinY();
        Object obj = null;
        int[] pixels = null;
        int i = 0;
        while (i < h) {
            int j;
            if ((obj = raster.getDataElements(minX, minY, w, 1, obj)) instanceof byte[]) {
                byte[] ba = (byte[])obj;
                if (pixels == null) {
                    pixels = new int[ba.length];
                }
                for (j = 0; j < ba.length; ++j) {
                    pixels[j] = this.colorMap[ba[j] & 0xFF];
                }
            } else if (obj instanceof short[]) {
                short[] sa = (short[])obj;
                if (pixels == null) {
                    pixels = new int[sa.length];
                }
                for (j = 0; j < sa.length; ++j) {
                    pixels[j] = this.colorMap[sa[j] & 0xFFFF];
                }
            }
            if (obj instanceof int[]) {
                int[] ia = (int[])obj;
                if (pixels == null) {
                    pixels = new int[ia.length];
                }
                for (j = 0; j < ia.length; ++j) {
                    pixels[j] = this.colorMap[ia[j]];
                }
            }
            distRaster.setDataElements(0, i, w, 1, pixels);
            ++i;
            ++minY;
        }
        return new BufferedImage(model, distRaster, false, null);
    }

    public BigInteger getValidPixels() {
        return this.validBits;
    }

    @Override
    public String toString() {
        String str = "IndexColorModel: #pixel_bits = " + this.pixel_bits + " numComponents = " + this.numComponents + " color space = " + this.cs + " transparency = ";
        str = this.transparency == 1 ? str + "Transparency.OPAQUE" : (this.transparency == 2 ? str + "Transparency.BITMASK" : str + "Transparency.TRANSLUCENT");
        str = str + " transIndex = " + this.transparentIndex + " has alpha = " + this.hasAlpha + " isAlphaPre = " + this.isAlphaPremultiplied;
        return str;
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        int pixIdx = -1;
        if (pixel instanceof byte[]) {
            byte[] ba = (byte[])pixel;
            pixIdx = ba[0] & 0xFF;
        } else if (pixel instanceof short[]) {
            short[] sa = (short[])pixel;
            pixIdx = sa[0] & 0xFFFF;
        } else if (pixel instanceof int[]) {
            int[] ia = (int[])pixel;
            pixIdx = ia[0];
        } else {
            throw new UnsupportedOperationException(Messages.getString("awt.219"));
        }
        return this.getComponents(pixIdx, components, offset);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        WritableRaster raster;
        if (this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4) {
            raster = Raster.createPackedRaster(0, w, h, 1, this.pixel_bits, null);
        } else if (this.pixel_bits <= 8) {
            raster = Raster.createInterleavedRaster(0, w, h, 1, null);
        } else if (this.pixel_bits <= 16) {
            raster = Raster.createInterleavedRaster(1, w, h, 1, null);
        } else {
            throw new UnsupportedOperationException(Messages.getString("awt.266"));
        }
        return raster;
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        if (sm == null) {
            return false;
        }
        if (!(sm instanceof MultiPixelPackedSampleModel) && !(sm instanceof ComponentSampleModel)) {
            return false;
        }
        if (sm.getTransferType() != this.transferType) {
            return false;
        }
        return sm.getNumBands() == 1;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        if (this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4) {
            return new MultiPixelPackedSampleModel(0, w, h, this.pixel_bits);
        }
        int[] bandOffsets = new int[]{0};
        return new ComponentSampleModel(this.transferType, w, h, 1, w, bandOffsets);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        int sampleSize = raster.getSampleModel().getSampleSize(0);
        return raster.getTransferType() == this.transferType && raster.getNumBands() == 1 && 1 << sampleSize >= this.mapSize;
    }

    @Override
    public int getDataElement(int[] components, int offset) {
        int pixel;
        int rgb = components[offset] << 16 | components[offset + 1] << 8 | components[offset + 2];
        rgb = this.hasAlpha ? (rgb |= components[offset + 3] << 24) : (rgb |= 0xFF000000);
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])this.getDataElements(rgb, null);
                pixel = ba[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sa = (short[])this.getDataElements(rgb, null);
                pixel = sa[0] & 0xFFFF;
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.getString("awt.267"));
            }
        }
        return pixel;
    }

    public final void getRGBs(int[] rgb) {
        System.arraycopy(this.colorMap, 0, rgb, 0, this.mapSize);
    }

    public final void getReds(byte[] r) {
        for (int i = 0; i < this.mapSize; ++i) {
            r[i] = (byte)(this.colorMap[i] >> 16);
        }
    }

    public final void getGreens(byte[] g) {
        for (int i = 0; i < this.mapSize; ++i) {
            g[i] = (byte)(this.colorMap[i] >> 8);
        }
    }

    public final void getBlues(byte[] b) {
        for (int i = 0; i < this.mapSize; ++i) {
            b[i] = (byte)this.colorMap[i];
        }
    }

    public final void getAlphas(byte[] a) {
        for (int i = 0; i < this.mapSize; ++i) {
            a[i] = (byte)(this.colorMap[i] >> 24);
        }
    }

    @Override
    public int[] getComponents(int pixel, int[] components, int offset) {
        if (components == null) {
            components = new int[offset + this.numComponents];
        }
        components[offset + 0] = this.getRed(pixel);
        components[offset + 1] = this.getGreen(pixel);
        components[offset + 2] = this.getBlue(pixel);
        if (this.hasAlpha && components.length - offset > 3) {
            components[offset + 3] = this.getAlpha(pixel);
        }
        return components;
    }

    public boolean isValid(int pixel) {
        if (this.validBits == null) {
            return pixel >= 0 && pixel < this.mapSize;
        }
        return pixel < this.mapSize && this.validBits.testBit(pixel);
    }

    @Override
    public final int getRed(int pixel) {
        return this.colorMap[pixel] >> 16 & 0xFF;
    }

    @Override
    public final int getRGB(int pixel) {
        return this.colorMap[pixel];
    }

    @Override
    public final int getGreen(int pixel) {
        return this.colorMap[pixel] >> 8 & 0xFF;
    }

    @Override
    public final int getBlue(int pixel) {
        return this.colorMap[pixel] & 0xFF;
    }

    @Override
    public final int getAlpha(int pixel) {
        return this.colorMap[pixel] >> 24 & 0xFF;
    }

    @Override
    public int[] getComponentSize() {
        return (int[])this.bits.clone();
    }

    public boolean isValid() {
        return this.validBits == null;
    }

    @Override
    public void finalize() {
    }

    public final int getTransparentPixel() {
        return this.transparentIndex;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }

    public final int getMapSize() {
        return this.mapSize;
    }

    private void createColorMap(int size, byte[] r, byte[] g, byte[] b, byte[] a, int trans) {
        if (size < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.264"));
        }
        this.mapSize = size;
        this.colorMap = new int[this.mapSize];
        if (trans >= 0 && trans < this.mapSize) {
            this.transparency = 2;
            this.transparentIndex = trans;
        } else {
            this.transparency = 1;
            this.transparentIndex = -1;
        }
        int alpha = 0;
        for (int i = 0; i < this.mapSize; ++i) {
            this.colorMap[i] = (r[i] & 0xFF) << 16 | (g[i] & 0xFF) << 8 | b[i] & 0xFF;
            if (trans == i) continue;
            if (a == null) {
                int n = i;
                this.colorMap[n] = this.colorMap[n] | 0xFF000000;
                continue;
            }
            alpha = a[i] & 0xFF;
            if (alpha == 255) {
                int n = i;
                this.colorMap[n] = this.colorMap[n] | 0xFF000000;
                continue;
            }
            if (alpha == 0) {
                if (this.transparency == 1) {
                    this.transparency = 2;
                }
                if (this.transparentIndex >= 0) continue;
                this.transparentIndex = i;
                continue;
            }
            int n = i;
            this.colorMap[n] = this.colorMap[n] | (a[i] & 0xFF) << 24;
            if (this.transparency == 3) continue;
            this.transparency = 3;
        }
    }

    private void checkPalette() {
        this.grayPalette = false;
        if (this.transparency > 1) {
            return;
        }
        int rgb = 0;
        for (int i = 0; i < this.mapSize; ++i) {
            rgb = this.colorMap[i];
            if ((rgb >> 16 & 0xFF) == (rgb >> 8 & 0xFF) && (rgb >> 8 & 0xFF) == (rgb & 0xFF)) continue;
            return;
        }
        this.grayPalette = true;
    }

    private Object createDataObject(int colorMapIdx, Object pixel) {
        block11: {
            block10: {
                if (pixel != null) break block10;
                switch (this.transferType) {
                    case 0: {
                        byte[] ba = new byte[]{(byte)colorMapIdx};
                        pixel = ba;
                        break block11;
                    }
                    case 1: {
                        short[] sa = new short[]{(short)colorMapIdx};
                        pixel = sa;
                        break block11;
                    }
                    default: {
                        throw new UnsupportedOperationException(Messages.getString("awt.267"));
                    }
                }
            }
            if (pixel instanceof byte[] && this.transferType == 0) {
                byte[] ba = (byte[])pixel;
                ba[0] = (byte)colorMapIdx;
                pixel = ba;
            } else if (pixel instanceof short[] && this.transferType == 1) {
                short[] sa = (short[])pixel;
                sa[0] = (short)colorMapIdx;
                pixel = sa;
            } else if (pixel instanceof int[]) {
                int[] ia = (int[])pixel;
                ia[0] = colorMapIdx;
                pixel = ia;
            } else {
                throw new ClassCastException(Messages.getString("awt.268"));
            }
        }
        return pixel;
    }

    private static int[] createBits(boolean hasAlpha) {
        int numChannels = hasAlpha ? 4 : 3;
        int[] bits = new int[numChannels];
        for (int i = 0; i < numChannels; ++i) {
            bits[i] = 8;
        }
        return bits;
    }

    private static int validateTransferType(int transferType) {
        if (transferType != 0 && transferType != 1) {
            throw new IllegalArgumentException(Messages.getString("awt.269"));
        }
        return transferType;
    }

    boolean isGrayPallete() {
        return this.grayPalette;
    }
}

