/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferDouble
extends DataBuffer {
    double[][] data;

    public DataBufferDouble(double[][] dataArrays, int size, int[] offsets) {
        super(5, size, dataArrays.length, offsets);
        this.data = (double[][])dataArrays.clone();
    }

    public DataBufferDouble(double[][] dataArrays, int size) {
        super(5, size, dataArrays.length);
        this.data = (double[][])dataArrays.clone();
    }

    public DataBufferDouble(double[] dataArray, int size, int offset) {
        super(5, size, 1, offset);
        this.data = new double[1][];
        this.data[0] = dataArray;
    }

    public DataBufferDouble(double[] dataArray, int size) {
        super(5, size);
        this.data = new double[1][];
        this.data[0] = dataArray;
    }

    public DataBufferDouble(int size, int numBanks) {
        super(5, size, numBanks);
        this.data = new double[numBanks][];
        int i = 0;
        while (i < numBanks) {
            this.data[i++] = new double[size];
        }
    }

    public DataBufferDouble(int size) {
        super(5, size);
        this.data = new double[1][];
        this.data[0] = new double[size];
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.data[bank][this.offsets[bank] + i] = val;
        this.notifyChanged();
    }

    @Override
    public void setElemFloat(int bank, int i, float val) {
        this.data[bank][this.offsets[bank] + i] = val;
        this.notifyChanged();
    }

    @Override
    public void setElemDouble(int bank, int i, double val) {
        this.data[bank][this.offsets[bank] + i] = val;
        this.notifyChanged();
    }

    @Override
    public void setElem(int i, int val) {
        this.data[0][this.offset + i] = val;
        this.notifyChanged();
    }

    @Override
    public int getElem(int bank, int i) {
        return (int)this.data[bank][this.offsets[bank] + i];
    }

    @Override
    public float getElemFloat(int bank, int i) {
        return (float)this.data[bank][this.offsets[bank] + i];
    }

    @Override
    public double getElemDouble(int bank, int i) {
        return this.data[bank][this.offsets[bank] + i];
    }

    @Override
    public void setElemFloat(int i, float val) {
        this.data[0][this.offset + i] = val;
        this.notifyChanged();
    }

    @Override
    public void setElemDouble(int i, double val) {
        this.data[0][this.offset + i] = val;
        this.notifyChanged();
    }

    public double[] getData(int bank) {
        this.notifyTaken();
        return this.data[bank];
    }

    @Override
    public int getElem(int i) {
        return (int)this.data[0][this.offset + i];
    }

    @Override
    public float getElemFloat(int i) {
        return (float)this.data[0][this.offset + i];
    }

    @Override
    public double getElemDouble(int i) {
        return this.data[0][this.offset + i];
    }

    public double[][] getBankData() {
        this.notifyTaken();
        return (double[][])this.data.clone();
    }

    public double[] getData() {
        this.notifyTaken();
        return this.data[0];
    }
}

