/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.AwtImageBackdoorAccessorImpl;
import org.apache.harmony.awt.gl.image.DataBufferListener;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class DataBuffer {
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_USHORT = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DOUBLE = 5;
    public static final int TYPE_UNDEFINED = 32;
    protected int dataType;
    protected int banks;
    protected int offset;
    protected int size;
    protected int[] offsets;
    boolean dataChanged = true;
    boolean dataTaken = false;
    DataBufferListener listener;

    protected DataBuffer(int dataType, int size, int numBanks, int[] offsets) {
        this.dataType = dataType;
        this.size = size;
        this.banks = numBanks;
        this.offsets = (int[])offsets.clone();
        this.offset = offsets[0];
    }

    protected DataBuffer(int dataType, int size, int numBanks, int offset) {
        this.dataType = dataType;
        this.size = size;
        this.banks = numBanks;
        this.offset = offset;
        this.offsets = new int[numBanks];
        int i = 0;
        while (i < numBanks) {
            this.offsets[i++] = offset;
        }
    }

    protected DataBuffer(int dataType, int size, int numBanks) {
        this.dataType = dataType;
        this.size = size;
        this.banks = numBanks;
        this.offset = 0;
        this.offsets = new int[numBanks];
    }

    protected DataBuffer(int dataType, int size) {
        this.dataType = dataType;
        this.size = size;
        this.banks = 1;
        this.offset = 0;
        this.offsets = new int[1];
    }

    public abstract void setElem(int var1, int var2, int var3);

    public void setElemFloat(int bank, int i, float val) {
        this.setElem(bank, i, (int)val);
    }

    public void setElemDouble(int bank, int i, double val) {
        this.setElem(bank, i, (int)val);
    }

    public void setElem(int i, int val) {
        this.setElem(0, i, val);
    }

    public abstract int getElem(int var1, int var2);

    public float getElemFloat(int bank, int i) {
        return this.getElem(bank, i);
    }

    public double getElemDouble(int bank, int i) {
        return this.getElem(bank, i);
    }

    public void setElemFloat(int i, float val) {
        this.setElemFloat(0, i, val);
    }

    public void setElemDouble(int i, double val) {
        this.setElemDouble(0, i, val);
    }

    public int getElem(int i) {
        return this.getElem(0, i);
    }

    public float getElemFloat(int i) {
        return this.getElem(0, i);
    }

    public double getElemDouble(int i) {
        return this.getElem(i);
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getNumBanks() {
        return this.banks;
    }

    public int getDataType() {
        return this.dataType;
    }

    public static int getDataTypeSize(int type) {
        switch (type) {
            case 0: {
                return 8;
            }
            case 1: 
            case 2: {
                return 16;
            }
            case 3: 
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        throw new IllegalArgumentException(Messages.getString("awt.22C", type));
    }

    void notifyChanged() {
        if (this.listener != null && !this.dataChanged) {
            this.dataChanged = true;
            this.listener.dataChanged();
        }
    }

    void notifyTaken() {
        if (this.listener != null && !this.dataTaken) {
            this.dataTaken = true;
            this.listener.dataTaken();
        }
    }

    void releaseData() {
        if (this.listener != null && this.dataTaken) {
            this.dataTaken = false;
            this.listener.dataReleased();
        }
    }

    void addDataBufferListener(DataBufferListener listener) {
        this.listener = listener;
    }

    void removeDataBufferListener() {
        this.listener = null;
    }

    void validate() {
        this.dataChanged = false;
    }

    static {
        AwtImageBackdoorAccessorImpl.init();
    }
}

