/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.harmony.awt.gl.ImageSurface;
import org.apache.harmony.awt.gl.Surface;
import org.apache.harmony.awt.gl.image.BufferedImageSource;
import org.apache.harmony.awt.internal.nls.Messages;

public class BufferedImage
extends Image
implements WritableRenderedImage,
Transparency {
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_INT_RGB = 1;
    public static final int TYPE_INT_ARGB = 2;
    public static final int TYPE_INT_ARGB_PRE = 3;
    public static final int TYPE_INT_BGR = 4;
    public static final int TYPE_3BYTE_BGR = 5;
    public static final int TYPE_4BYTE_ABGR = 6;
    public static final int TYPE_4BYTE_ABGR_PRE = 7;
    public static final int TYPE_USHORT_565_RGB = 8;
    public static final int TYPE_USHORT_555_RGB = 9;
    public static final int TYPE_BYTE_GRAY = 10;
    public static final int TYPE_USHORT_GRAY = 11;
    public static final int TYPE_BYTE_BINARY = 12;
    public static final int TYPE_BYTE_INDEXED = 13;
    private static final int ALPHA_MASK = -16777216;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_BGR_MASK = 255;
    private static final int GREEN_BGR_MASK = 65280;
    private static final int BLUE_BGR_MASK = 0xFF0000;
    private static final int RED_565_MASK = 63488;
    private static final int GREEN_565_MASK = 2016;
    private static final int BLUE_565_MASK = 31;
    private static final int RED_555_MASK = 31744;
    private static final int GREEN_555_MASK = 992;
    private static final int BLUE_555_MASK = 31;
    private ColorModel cm;
    private final WritableRaster raster;
    private final int imageType;
    private Hashtable<?, ?> properties;
    private final ImageSurface imageSurf;

    public BufferedImage(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties) {
        if (!cm.isCompatibleRaster(raster)) {
            throw new IllegalArgumentException(Messages.getString("awt.4D"));
        }
        if (raster.getMinX() != 0 || raster.getMinY() != 0) {
            throw new IllegalArgumentException(Messages.getString("awt.228"));
        }
        this.cm = cm;
        this.raster = raster;
        this.properties = properties;
        this.coerceData(isRasterPremultiplied);
        this.imageType = Surface.getType(cm, raster);
        this.imageSurf = this.createImageSurface(this.imageType);
    }

    public BufferedImage(int width, int height, int imageType, IndexColorModel cm) {
        switch (imageType) {
            case 12: {
                if (cm.hasAlpha()) {
                    throw new IllegalArgumentException(Messages.getString("awt.227"));
                }
                int pixel_bits = 0;
                int mapSize = cm.getMapSize();
                if (mapSize <= 2) {
                    pixel_bits = 1;
                } else if (mapSize <= 4) {
                    pixel_bits = 2;
                } else if (mapSize <= 16) {
                    pixel_bits = 4;
                } else {
                    throw new IllegalArgumentException(Messages.getString("awt.221"));
                }
                this.raster = Raster.createPackedRaster(0, width, height, 1, pixel_bits, null);
                break;
            }
            case 13: {
                this.raster = Raster.createInterleavedRaster(0, width, height, 1, null);
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.222"));
            }
        }
        if (!cm.isCompatibleRaster(this.raster)) {
            throw new IllegalArgumentException(Messages.getString("awt.223"));
        }
        this.cm = cm;
        this.imageType = imageType;
        this.imageSurf = this.createImageSurface(imageType);
    }

    public BufferedImage(int width, int height, int imageType) {
        switch (imageType) {
            case 1: {
                this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
                this.raster = this.cm.createCompatibleWritableRaster(width, height);
                break;
            }
            case 2: {
                this.cm = ColorModel.getRGBdefault();
                this.raster = this.cm.createCompatibleWritableRaster(width, height);
                break;
            }
            case 3: {
                this.cm = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
                this.raster = this.cm.createCompatibleWritableRaster(width, height);
                break;
            }
            case 4: {
                this.cm = new DirectColorModel(24, 255, 65280, 0xFF0000);
                this.raster = this.cm.createCompatibleWritableRaster(width, height);
                break;
            }
            case 5: {
                int[] bits = new int[]{8, 8, 8};
                int[] bandOffsets = new int[]{2, 1, 0};
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1000), bits, false, false, 1, 0);
                this.raster = Raster.createInterleavedRaster(0, width, height, width * 3, 3, bandOffsets, null);
                break;
            }
            case 6: {
                int[] bits = new int[]{8, 8, 8, 8};
                int[] bandOffsets = new int[]{3, 2, 1, 0};
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1000), bits, true, false, 3, 0);
                this.raster = Raster.createInterleavedRaster(0, width, height, width * 4, 4, bandOffsets, null);
                break;
            }
            case 7: {
                int[] bits = new int[]{8, 8, 8, 8};
                int[] bandOffsets = new int[]{3, 2, 1, 0};
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1000), bits, true, true, 3, 0);
                this.raster = Raster.createInterleavedRaster(0, width, height, width * 4, 4, bandOffsets, null);
                break;
            }
            case 8: {
                this.cm = new DirectColorModel(ColorSpace.getInstance(1000), 16, 63488, 2016, 31, 0, false, 1);
                this.raster = this.cm.createCompatibleWritableRaster(width, height);
                break;
            }
            case 9: {
                this.cm = new DirectColorModel(ColorSpace.getInstance(1000), 15, 31744, 992, 31, 0, false, 1);
                this.raster = this.cm.createCompatibleWritableRaster(width, height);
                break;
            }
            case 10: {
                int[] bits = new int[]{8};
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1003), bits, false, false, 1, 0);
                this.raster = this.cm.createCompatibleWritableRaster(width, height);
                break;
            }
            case 11: {
                int[] bits = new int[]{16};
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1003), bits, false, false, 1, 1);
                this.raster = this.cm.createCompatibleWritableRaster(width, height);
                break;
            }
            case 12: {
                int[] colorMap = new int[]{0, 0xFFFFFF};
                this.cm = new IndexColorModel(1, 2, colorMap, 0, false, -1, 0);
                this.raster = Raster.createPackedRaster(0, width, height, 1, 1, null);
                break;
            }
            case 13: {
                int[] colorMap = new int[256];
                int i = 0;
                for (int r = 0; r < 256; r += 51) {
                    for (int g = 0; g < 256; g += 51) {
                        for (int b = 0; b < 256; b += 51) {
                            colorMap[i] = r << 16 | g << 8 | b;
                            ++i;
                        }
                    }
                }
                int gray = 18;
                while (i < 256) {
                    colorMap[i] = gray << 16 | gray << 8 | gray;
                    ++i;
                    gray += 6;
                }
                this.cm = new IndexColorModel(8, 256, colorMap, 0, false, -1, 0);
                this.raster = Raster.createInterleavedRaster(0, width, height, 1, null);
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.224"));
            }
        }
        this.imageType = imageType;
        this.imageSurf = this.createImageSurface(imageType);
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        return this.getProperty(name);
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new NullPointerException(Messages.getString("awt.225"));
        }
        if (this.properties == null) {
            return Image.UndefinedProperty;
        }
        Object property = this.properties.get(name);
        if (property == null) {
            property = Image.UndefinedProperty;
        }
        return property;
    }

    @Override
    public WritableRaster copyData(WritableRaster outRaster) {
        if (outRaster == null) {
            outRaster = Raster.createWritableRaster(this.raster.getSampleModel(), new Point(this.raster.getSampleModelTranslateX(), this.raster.getSampleModelTranslateY()));
        }
        int w = outRaster.getWidth();
        int h = outRaster.getHeight();
        int minX = outRaster.getMinX();
        int minY = outRaster.getMinY();
        Object data = null;
        data = this.raster.getDataElements(minX, minY, w, h, data);
        outRaster.setDataElements(minX, minY, w, h, data);
        return outRaster;
    }

    @Override
    public Raster getData(Rectangle rect) {
        int minX = rect.x;
        int minY = rect.y;
        int w = rect.width;
        int h = rect.height;
        SampleModel sm = this.raster.getSampleModel();
        SampleModel nsm = sm.createCompatibleSampleModel(w, h);
        WritableRaster outr = Raster.createWritableRaster(nsm, rect.getLocation());
        Object data = null;
        data = this.raster.getDataElements(minX, minY, w, h, data);
        outr.setDataElements(minX, minY, w, h, data);
        return outr;
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        if (this.properties == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        Enumeration<?> e = this.properties.keys();
        while (e.hasMoreElements()) {
            try {
                v.add((String)e.nextElement());
            }
            catch (ClassCastException classCastException) {}
        }
        int size = v.size();
        if (size > 0) {
            String[] names = new String[size];
            for (int i = 0; i < size; ++i) {
                names[i] = (String)v.elementAt(i);
            }
            return names;
        }
        return null;
    }

    public String toString() {
        return "BufferedImage@" + Integer.toHexString(this.hashCode()) + ": type = " + this.imageType + " " + this.cm + " " + this.raster;
    }

    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        return this.raster;
    }

    public WritableRaster getRaster() {
        return this.raster;
    }

    public WritableRaster getAlphaRaster() {
        return this.cm.getAlphaRaster(this.raster);
    }

    @Override
    public void removeTileObserver(TileObserver to) {
    }

    @Override
    public void addTileObserver(TileObserver to) {
    }

    @Override
    public SampleModel getSampleModel() {
        return this.raster.getSampleModel();
    }

    @Override
    public void setData(Raster r) {
        Rectangle from = r.getBounds();
        Rectangle to = this.raster.getBounds();
        Rectangle intersection = to.intersection(from);
        int minX = intersection.x;
        int minY = intersection.y;
        int w = intersection.width;
        int h = intersection.height;
        Object data = null;
        data = r.getDataElements(minX, minY, w, h, data);
        this.raster.setDataElements(minX, minY, w, h, data);
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        if (tileX == 0 && tileY == 0) {
            return this.raster;
        }
        throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.226"));
    }

    @Override
    public Raster getData() {
        int w = this.raster.getWidth();
        int h = this.raster.getHeight();
        int minX = this.raster.getMinX();
        int minY = this.raster.getMinY();
        WritableRaster outr = Raster.createWritableRaster(this.raster.getSampleModel(), new Point(this.raster.getSampleModelTranslateX(), this.raster.getSampleModelTranslateY()));
        Object data = null;
        data = this.raster.getDataElements(minX, minY, w, h, data);
        outr.setDataElements(minX, minY, w, h, data);
        return outr;
    }

    @Override
    public ImageProducer getSource() {
        return new BufferedImageSource(this, this.properties);
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.raster.getWidth();
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.raster.getHeight();
    }

    @Override
    public ColorModel getColorModel() {
        return this.cm;
    }

    public BufferedImage getSubimage(int x, int y, int w, int h) {
        WritableRaster wr = this.raster.createWritableChild(x, y, w, h, 0, 0, null);
        return new BufferedImage(this.cm, wr, this.cm.isAlphaPremultiplied(), this.properties);
    }

    @Override
    public Point[] getWritableTileIndices() {
        Point[] points = new Point[]{new Point(0, 0)};
        return points;
    }

    public Graphics2D createGraphics() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.createGraphics(this);
    }

    @Override
    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public void coerceData(boolean isAlphaPremultiplied) {
        if (this.cm.hasAlpha() && this.cm.isAlphaPremultiplied() != isAlphaPremultiplied) {
            this.cm = this.cm.coerceData(this.raster, isAlphaPremultiplied);
        }
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        if (rgbArray == null) {
            rgbArray = new int[offset + h * scansize];
        }
        int off = offset;
        int y = startY;
        while (y < startY + h) {
            int i = off;
            int x = startX;
            while (x < startX + w) {
                rgbArray[i] = this.cm.getRGB(this.raster.getDataElements(x, y, null));
                ++x;
                ++i;
            }
            ++y;
            off += scansize;
        }
        return rgbArray;
    }

    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        int off = offset;
        int y = startY;
        while (y < startY + h) {
            int i = off;
            int x = startX;
            while (x < startX + w) {
                this.raster.setDataElements(x, y, this.cm.getDataElements(rgbArray[i], null));
                ++x;
                ++i;
            }
            ++y;
            off += scansize;
        }
    }

    public synchronized void setRGB(int x, int y, int rgb) {
        this.raster.setDataElements(x, y, this.cm.getDataElements(rgb, null));
    }

    @Override
    public boolean isTileWritable(int tileX, int tileY) {
        if (tileX == 0 && tileY == 0) {
            return true;
        }
        throw new IllegalArgumentException(Messages.getString("awt.226"));
    }

    @Override
    public void releaseWritableTile(int tileX, int tileY) {
    }

    public int getRGB(int x, int y) {
        return this.cm.getRGB(this.raster.getDataElements(x, y, null));
    }

    public boolean isAlphaPremultiplied() {
        return this.cm.isAlphaPremultiplied();
    }

    @Override
    public boolean hasTileWriters() {
        return true;
    }

    @Override
    public void flush() {
        this.imageSurf.dispose();
    }

    @Override
    public int getWidth() {
        return this.raster.getWidth();
    }

    public int getType() {
        return this.imageType;
    }

    @Override
    public int getTileWidth() {
        return this.raster.getWidth();
    }

    @Override
    public int getTileHeight() {
        return this.raster.getHeight();
    }

    @Override
    public int getTileGridYOffset() {
        return this.raster.getSampleModelTranslateY();
    }

    @Override
    public int getTileGridXOffset() {
        return this.raster.getSampleModelTranslateX();
    }

    @Override
    public int getNumYTiles() {
        return 1;
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getMinY() {
        return this.raster.getMinY();
    }

    @Override
    public int getMinX() {
        return this.raster.getMinX();
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getHeight() {
        return this.raster.getHeight();
    }

    private ImageSurface createImageSurface(int type) {
        return new ImageSurface(this.getColorModel(), this.getRaster(), type);
    }

    ImageSurface getImageSurface() {
        return this.imageSurf;
    }

    @Override
    public int getTransparency() {
        return this.cm.getTransparency();
    }
}

