/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.AwtImageBackdoorAccessor;

class TexturePaintContext
implements PaintContext {
    ColorModel cm;
    BufferedImage img;
    Rectangle2D anchor;
    AffineTransform t;
    AwtImageBackdoorAccessor access;
    DataBuffer srcBuf;
    DataBuffer dstBuf;
    WritableRaster srcRaster;
    WritableRaster dstRaster;
    int srcWidth;
    int srcHeight;
    int sx;
    int sy;
    int hx;
    int hy;
    int vx;
    int vy;
    int m00;
    int m01;
    int m10;
    int m11;
    int imgW;
    int imgH;
    int px;
    int py;
    int[] weight = new int[4];
    int[] value = new int[4];

    public TexturePaintContext(BufferedImage img, Rectangle2D anchor, AffineTransform t) {
        this.cm = img.getColorModel();
        this.img = img;
        this.anchor = anchor;
        this.t = t;
        this.srcWidth = img.getWidth();
        this.srcHeight = img.getHeight();
        this.imgW = this.srcWidth << 8;
        this.imgH = this.srcHeight << 8;
        double det = t.getDeterminant();
        double multW = (double)this.imgW / (anchor.getWidth() * det);
        double multH = (double)(-this.imgH) / (anchor.getHeight() * det);
        this.m11 = (int)(t.getScaleY() * multW);
        this.m01 = (int)(t.getShearX() * multW);
        this.m00 = (int)(t.getScaleX() * multH);
        this.m10 = (int)(t.getShearY() * multH);
        Point2D p = t.transform(new Point2D.Double(anchor.getX(), anchor.getY()), null);
        this.px = (int)p.getX();
        this.py = (int)p.getY();
        this.hx = this.check2(this.m11, this.imgW);
        this.hy = this.check2(this.m10, this.imgH);
        this.srcRaster = img.getRaster();
        this.srcBuf = this.srcRaster.getDataBuffer();
        this.access = AwtImageBackdoorAccessor.getInstance();
    }

    void prepare(int dstX, int dstY, int dstWidth, int dstHeight) {
        this.vx = this.check2(-this.m01 - this.m11 * dstWidth, this.imgW);
        this.vy = this.check2(-this.m00 - this.m10 * dstWidth, this.imgH);
        int dx = dstX - this.px;
        int dy = dstY - this.py;
        this.sx = this.check2(dx * this.m11 - dy * this.m01, this.imgW);
        this.sy = this.check2(dx * this.m10 - dy * this.m00, this.imgH);
        this.dstRaster = this.cm.createCompatibleWritableRaster(dstWidth, dstHeight);
        this.dstBuf = this.dstRaster.getDataBuffer();
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return this.cm;
    }

    int check(int value, int max) {
        if (value >= max) {
            return value - max;
        }
        return value;
    }

    int check2(int value, int max) {
        return (value %= max) < 0 ? max + value : value;
    }

    @Override
    public Raster getRaster(int dstX, int dstY, int dstWidth, int dstHeight) {
        return this.dstRaster;
    }

    static class CommonBilinear
    extends TexturePaintContext {
        public CommonBilinear(BufferedImage img, Rectangle2D anchor, AffineTransform t) {
            super(img, anchor, t);
        }

        @Override
        public Raster getRaster(int dstX, int dstY, int dstWidth, int dstHeight) {
            this.prepare(dstX, dstY, dstWidth, dstHeight);
            for (int j = 0; j < dstHeight; ++j) {
                for (int i = 0; i < dstWidth; ++i) {
                    int wx1 = this.sx & 0xFF;
                    int wy1 = this.sy & 0xFF;
                    int wx0 = 255 - wx1;
                    int wy0 = 255 - wy1;
                    this.weight[0] = wx0 * wy0;
                    this.weight[1] = wx1 * wy0;
                    this.weight[2] = wx0 * wy1;
                    this.weight[3] = wx1 * wy1;
                    int x0 = this.sx >> 8;
                    int y0 = this.sy >> 8;
                    int x1 = this.check(x0 + 1, this.srcWidth);
                    int y1 = this.check(y0 + 1, this.srcHeight);
                    this.value[0] = this.cm.getRGB(this.srcRaster.getDataElements(x0, y0, null));
                    this.value[1] = this.cm.getRGB(this.srcRaster.getDataElements(x1, y0, null));
                    this.value[2] = this.cm.getRGB(this.srcRaster.getDataElements(x0, y1, null));
                    this.value[3] = this.cm.getRGB(this.srcRaster.getDataElements(x1, y1, null));
                    int color = 0;
                    for (int n = 0; n < 32; n += 8) {
                        int comp = 0;
                        for (int m = 0; m < 4; ++m) {
                            comp += (this.value[m] >> n & 0xFF) * this.weight[m];
                        }
                        color |= comp >> 16 << n;
                    }
                    this.dstRaster.setDataElements(dstX + i, dstY + j, this.cm.getDataElements(color, null));
                    this.sx = this.check(this.sx + this.hx, this.imgW);
                    this.sy = this.check(this.sy + this.hy, this.imgH);
                }
                this.sx = this.check(this.sx + this.vx, this.imgW);
                this.sy = this.check(this.sy + this.vy, this.imgH);
            }
            return this.dstRaster;
        }
    }

    static class ShortBilinear
    extends TexturePaintContext {
        public ShortBilinear(BufferedImage img, Rectangle2D anchor, AffineTransform t) {
            super(img, anchor, t);
        }

        @Override
        public Raster getRaster(int dstX, int dstY, int dstWidth, int dstHeight) {
            this.prepare(dstX, dstY, dstWidth, dstHeight);
            short[] src = this.access.getDataUShort(this.srcBuf);
            short[] dst = this.access.getDataUShort(this.dstBuf);
            int k = 0;
            for (int j = 0; j < dstHeight; ++j) {
                for (int i = 0; i < dstWidth; ++i) {
                    int wx1 = this.sx & 0xFF;
                    int wy1 = this.sy & 0xFF;
                    int wx0 = 255 - wx1;
                    int wy0 = 255 - wy1;
                    this.weight[0] = wx0 * wy0;
                    this.weight[1] = wx1 * wy0;
                    this.weight[2] = wx0 * wy1;
                    this.weight[3] = wx1 * wy1;
                    int x0 = this.sx >> 8;
                    int y0 = this.sy >> 8;
                    int x1 = this.check(x0 + 1, this.srcWidth);
                    int y1 = this.check(y0 + 1, this.srcHeight);
                    this.value[0] = src[x0 + (y0 *= dstWidth)];
                    this.value[1] = src[x1 + y0];
                    this.value[2] = src[x0 + (y1 *= dstWidth)];
                    this.value[3] = src[x1 + y1];
                    short color = 0;
                    for (int n = 0; n < 16; n += 8) {
                        int comp = 0;
                        for (int m = 0; m < 4; ++m) {
                            comp += (this.value[m] >> n & 0xFF) * this.weight[m];
                        }
                        color = (short)(color | comp >> 16 << n);
                    }
                    dst[k++] = color;
                    this.sx = this.check(this.sx + this.hx, this.imgW);
                    this.sy = this.check(this.sy + this.hy, this.imgH);
                }
                this.sx = this.check(this.sx + this.vx, this.imgW);
                this.sy = this.check(this.sy + this.vy, this.imgH);
            }
            return this.dstRaster;
        }
    }

    static class ByteBilinear
    extends TexturePaintContext {
        public ByteBilinear(BufferedImage img, Rectangle2D anchor, AffineTransform t) {
            super(img, anchor, t);
        }

        @Override
        public Raster getRaster(int dstX, int dstY, int dstWidth, int dstHeight) {
            this.prepare(dstX, dstY, dstWidth, dstHeight);
            byte[] src = this.access.getDataByte(this.srcBuf);
            byte[] dst = this.access.getDataByte(this.dstBuf);
            int k = 0;
            for (int j = 0; j < dstHeight; ++j) {
                for (int i = 0; i < dstWidth; ++i) {
                    int wx1 = this.sx & 0xFF;
                    int wy1 = this.sy & 0xFF;
                    int wx0 = 255 - wx1;
                    int wy0 = 255 - wy1;
                    this.weight[0] = wx0 * wy0;
                    this.weight[1] = wx1 * wy0;
                    this.weight[2] = wx0 * wy1;
                    this.weight[3] = wx1 * wy1;
                    int x0 = this.sx >> 8;
                    int y0 = this.sy >> 8;
                    int x1 = this.check(x0 + 1, this.srcWidth);
                    int y1 = this.check(y0 + 1, this.srcHeight);
                    this.value[0] = src[x0 + (y0 *= dstWidth)];
                    this.value[1] = src[x1 + y0];
                    this.value[2] = src[x0 + (y1 *= dstWidth)];
                    this.value[3] = src[x1 + y1];
                    int comp = 0;
                    for (int m = 0; m < 4; ++m) {
                        comp += this.value[m] * this.weight[m];
                    }
                    dst[k++] = (byte)(comp >> 16);
                    this.sx = this.check(this.sx + this.hx, this.imgW);
                    this.sy = this.check(this.sy + this.hy, this.imgH);
                }
                this.sx = this.check(this.sx + this.vx, this.imgW);
                this.sy = this.check(this.sy + this.vy, this.imgH);
            }
            return this.dstRaster;
        }
    }

    static class IntBilinear
    extends TexturePaintContext {
        public IntBilinear(BufferedImage img, Rectangle2D anchor, AffineTransform t) {
            super(img, anchor, t);
        }

        @Override
        public Raster getRaster(int dstX, int dstY, int dstWidth, int dstHeight) {
            this.prepare(dstX, dstY, dstWidth, dstHeight);
            int[] src = this.access.getDataInt(this.srcBuf);
            int[] dst = this.access.getDataInt(this.dstBuf);
            int k = 0;
            for (int j = 0; j < dstHeight; ++j) {
                for (int i = 0; i < dstWidth; ++i) {
                    int wx1 = this.sx & 0xFF;
                    int wy1 = this.sy & 0xFF;
                    int wx0 = 255 - wx1;
                    int wy0 = 255 - wy1;
                    this.weight[0] = wx0 * wy0;
                    this.weight[1] = wx1 * wy0;
                    this.weight[2] = wx0 * wy1;
                    this.weight[3] = wx1 * wy1;
                    int x0 = this.sx >> 8;
                    int y0 = this.sy >> 8;
                    int x1 = this.check(x0 + 1, this.srcWidth);
                    int y1 = this.check(y0 + 1, this.srcHeight);
                    this.value[0] = src[x0 + (y0 *= this.srcWidth)];
                    this.value[1] = src[x1 + y0];
                    this.value[2] = src[x0 + (y1 *= this.srcWidth)];
                    this.value[3] = src[x1 + y1];
                    int color = 0;
                    for (int n = 0; n < 32; n += 8) {
                        int comp = 0;
                        for (int m = 0; m < 4; ++m) {
                            comp += (this.value[m] >> n & 0xFF) * this.weight[m];
                        }
                        color |= comp >> 16 << n;
                    }
                    dst[k++] = color;
                    this.sx = this.check(this.sx + this.hx, this.imgW);
                    this.sy = this.check(this.sy + this.hy, this.imgH);
                }
                this.sx = this.check(this.sx + this.vx, this.imgW);
                this.sy = this.check(this.sy + this.vy, this.imgH);
            }
            return this.dstRaster;
        }
    }

    static class CommonSimple
    extends TexturePaintContext {
        public CommonSimple(BufferedImage img, Rectangle2D anchor, AffineTransform t) {
            super(img, anchor, t);
        }

        @Override
        public Raster getRaster(int dstX, int dstY, int dstWidth, int dstHeight) {
            this.prepare(dstX, dstY, dstWidth, dstHeight);
            for (int j = 0; j < dstHeight; ++j) {
                for (int i = 0; i < dstWidth; ++i) {
                    this.dstRaster.setDataElements(dstX + i, dstY + j, this.srcRaster.getDataElements(this.sx >> 8, this.sy >> 8, null));
                    this.sx = this.check(this.sx + this.hx, this.imgW);
                    this.sy = this.check(this.sy + this.hy, this.imgH);
                }
                this.sx = this.check(this.sx + this.vx, this.imgW);
                this.sy = this.check(this.sy + this.vy, this.imgH);
            }
            return this.dstRaster;
        }
    }

    static class ShortSimple
    extends TexturePaintContext {
        public ShortSimple(BufferedImage img, Rectangle2D anchor, AffineTransform t) {
            super(img, anchor, t);
        }

        @Override
        public Raster getRaster(int dstX, int dstY, int dstWidth, int dstHeight) {
            this.prepare(dstX, dstY, dstWidth, dstHeight);
            short[] src = this.access.getDataUShort(this.srcBuf);
            short[] dst = this.access.getDataUShort(this.dstBuf);
            int k = 0;
            for (int j = 0; j < dstHeight; ++j) {
                for (int i = 0; i < dstWidth; ++i) {
                    dst[k++] = src[(this.sx >> 8) + (this.sy >> 8) * this.srcWidth];
                    this.sx = this.check(this.sx + this.hx, this.imgW);
                    this.sy = this.check(this.sy + this.hy, this.imgH);
                }
                this.sx = this.check(this.sx + this.vx, this.imgW);
                this.sy = this.check(this.sy + this.vy, this.imgH);
            }
            return this.dstRaster;
        }
    }

    static class ByteSimple
    extends TexturePaintContext {
        public ByteSimple(BufferedImage img, Rectangle2D anchor, AffineTransform t) {
            super(img, anchor, t);
        }

        @Override
        public Raster getRaster(int dstX, int dstY, int dstWidth, int dstHeight) {
            this.prepare(dstX, dstY, dstWidth, dstHeight);
            byte[] src = this.access.getDataByte(this.srcBuf);
            byte[] dst = this.access.getDataByte(this.dstBuf);
            int k = 0;
            for (int j = 0; j < dstHeight; ++j) {
                for (int i = 0; i < dstWidth; ++i) {
                    dst[k++] = src[(this.sx >> 8) + (this.sy >> 8) * this.srcWidth];
                    this.sx = this.check(this.sx + this.hx, this.imgW);
                    this.sy = this.check(this.sy + this.hy, this.imgH);
                }
                this.sx = this.check(this.sx + this.vx, this.imgW);
                this.sy = this.check(this.sy + this.vy, this.imgH);
            }
            return this.dstRaster;
        }
    }

    static class IntSimple
    extends TexturePaintContext {
        public IntSimple(BufferedImage img, Rectangle2D anchor, AffineTransform t) {
            super(img, anchor, t);
        }

        @Override
        public Raster getRaster(int dstX, int dstY, int dstWidth, int dstHeight) {
            this.prepare(dstX, dstY, dstWidth, dstHeight);
            int[] src = this.access.getDataInt(this.srcBuf);
            int[] dst = this.access.getDataInt(this.dstBuf);
            int k = 0;
            for (int j = 0; j < dstHeight; ++j) {
                for (int i = 0; i < dstWidth; ++i) {
                    dst[k++] = src[(this.sx >> 8) + (this.sy >> 8) * this.srcWidth];
                    this.sx = this.check(this.sx + this.hx, this.imgW);
                    this.sy = this.check(this.sy + this.hy, this.imgH);
                }
                this.sx = this.check(this.sx + this.vx, this.imgW);
                this.sy = this.check(this.sy + this.vy, this.imgH);
            }
            return this.dstRaster;
        }
    }
}

