/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Rectangle
extends Rectangle2D
implements Shape,
Serializable {
    private static final long serialVersionUID = -4345857070255674764L;
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
        this.setBounds(0, 0, 0, 0);
    }

    public Rectangle(Point p) {
        this.setBounds(p.x, p.y, 0, 0);
    }

    public Rectangle(Point p, Dimension d) {
        this.setBounds(p.x, p.y, d.width, d.height);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public Rectangle(int width, int height) {
        this.setBounds(0, 0, width, height);
    }

    public Rectangle(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public Rectangle(Dimension d) {
        this.setBounds(0, 0, d.width, d.height);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    @Deprecated
    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    @Override
    public void setRect(double x, double y, double width, double height) {
        int x1 = (int)Math.floor(x);
        int y1 = (int)Math.floor(y);
        int x2 = (int)Math.ceil(x + width);
        int y2 = (int)Math.ceil(y + height);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    @Deprecated
    public void resize(int width, int height) {
        this.setBounds(this.x, this.y, width, height);
    }

    @Deprecated
    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void grow(int dx, int dy) {
        this.x -= dx;
        this.y -= dy;
        this.width += dx + dx;
        this.height += dy + dy;
    }

    public void translate(int mx, int my) {
        this.x += mx;
        this.y += my;
    }

    public void add(int px, int py) {
        int x1 = Math.min(this.x, px);
        int x2 = Math.max(this.x + this.width, px);
        int y1 = Math.min(this.y, py);
        int y2 = Math.max(this.y + this.height, py);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(Point p) {
        this.add(p.x, p.y);
    }

    public void add(Rectangle r) {
        int x1 = Math.min(this.x, r.x);
        int x2 = Math.max(this.x + this.width, r.x + r.width);
        int y1 = Math.min(this.y, r.y);
        int y2 = Math.max(this.y + this.height, r.y + r.height);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean contains(int px, int py) {
        if (this.isEmpty()) {
            return false;
        }
        if (px < this.x || py < this.y) {
            return false;
        }
        return (px -= this.x) < this.width && (py -= this.y) < this.height;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int rx, int ry, int rw, int rh) {
        return this.contains(rx, ry) && this.contains(rx + rw - 1, ry + rh - 1);
    }

    public boolean contains(Rectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    @Deprecated
    public boolean inside(int px, int py) {
        return this.contains(px, py);
    }

    @Override
    public Rectangle2D createIntersection(Rectangle2D r) {
        if (r instanceof Rectangle) {
            return this.intersection((Rectangle)r);
        }
        Rectangle2D.Double dst = new Rectangle2D.Double();
        Rectangle2D.intersect(this, r, dst);
        return dst;
    }

    public Rectangle intersection(Rectangle r) {
        int x1 = Math.max(this.x, r.x);
        int y1 = Math.max(this.y, r.y);
        int x2 = Math.min(this.x + this.width, r.x + r.width);
        int y2 = Math.min(this.y + this.height, r.y + r.height);
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean intersects(Rectangle r) {
        return !this.intersection(r).isEmpty();
    }

    @Override
    public int outcode(double px, double py) {
        int code = 0;
        if (this.width <= 0) {
            code |= 5;
        } else if (px < (double)this.x) {
            code |= 1;
        } else if (px > (double)(this.x + this.width)) {
            code |= 4;
        }
        if (this.height <= 0) {
            code |= 0xA;
        } else if (py < (double)this.y) {
            code |= 2;
        } else if (py > (double)(this.y + this.height)) {
            code |= 8;
        }
        return code;
    }

    @Override
    public Rectangle2D createUnion(Rectangle2D r) {
        if (r instanceof Rectangle) {
            return this.union((Rectangle)r);
        }
        Rectangle2D.Double dst = new Rectangle2D.Double();
        Rectangle2D.union(this, r, dst);
        return dst;
    }

    public Rectangle union(Rectangle r) {
        Rectangle dst = new Rectangle(this);
        dst.add(r);
        return dst;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle) {
            Rectangle r = (Rectangle)obj;
            return r.x == this.x && r.y == this.y && r.width == this.width && r.height == this.height;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }
}

