/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.ReplicateScaleFilter;
import org.apache.harmony.awt.gl.image.OffscreenImage;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class Image {
    public static final Object UndefinedProperty = new Object();
    public static final int SCALE_DEFAULT = 1;
    public static final int SCALE_FAST = 2;
    public static final int SCALE_SMOOTH = 4;
    public static final int SCALE_REPLICATE = 8;
    public static final int SCALE_AREA_AVERAGING = 16;
    protected float accelerationPriority = 0.5f;
    private static final ImageCapabilities capabilities = new ImageCapabilities(false);

    public abstract Object getProperty(String var1, ImageObserver var2);

    public abstract ImageProducer getSource();

    public abstract int getWidth(ImageObserver var1);

    public abstract int getHeight(ImageObserver var1);

    public Image getScaledInstance(int width, int height, int hints) {
        ReplicateScaleFilter filter = (hints & 0x14) != 0 ? new AreaAveragingScaleFilter(width, height) : new ReplicateScaleFilter(width, height);
        FilteredImageSource producer = new FilteredImageSource(this.getSource(), filter);
        return new OffscreenImage(producer);
    }

    public static Image createImage(ImageProducer producer) {
        return new OffscreenImage(producer);
    }

    public abstract Graphics getGraphics();

    public abstract void flush();

    public float getAccelerationPriority() {
        return this.accelerationPriority;
    }

    public void setAccelerationPriority(float priority) {
        if (priority < 0.0f || priority > 1.0f) {
            throw new IllegalArgumentException(Messages.getString("awt.10A"));
        }
        this.accelerationPriority = priority;
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration gc) {
        return capabilities;
    }
}

