/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import org.apache.harmony.awt.gl.font.CommonGlyphVector;

public class Graphics2DUtil {
    public static void drawGlyphVector(Graphics2D g2d, GlyphVector g, float x, float y) {
        if (Graphics2DUtil.isIdentity(g) && g instanceof CommonGlyphVector) {
            g2d.drawString(Graphics2DUtil.string((CommonGlyphVector)g), x, y);
        } else {
            Shape s = g.getOutline(x, y);
            g2d.fill(s);
        }
    }

    private static String string(CommonGlyphVector gv) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i != gv.getNumGlyphs(); ++i) {
            int charIndex = gv.getGlyphCharIndex(i);
            char ch = gv.getGlyphChar(charIndex);
            text.append(ch);
        }
        return text.toString();
    }

    private static boolean isIdentity(GlyphVector gv) {
        for (int i = 0; i != gv.getNumGlyphs(); ++i) {
            AffineTransform tr = gv.getGlyphTransform(i);
            if (tr == null || tr.isIdentity()) continue;
            return false;
        }
        return true;
    }
}

