/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.GradientPaintContext;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.harmony.awt.internal.nls.Messages;

public class GradientPaint
implements Paint {
    Color color1;
    Color color2;
    Point2D point1;
    Point2D point2;
    boolean cyclic;

    public GradientPaint(Point2D point1, Color color1, Point2D point2, Color color2, boolean cyclic) {
        if (point1 == null || point2 == null) {
            throw new NullPointerException(Messages.getString("awt.6D"));
        }
        if (color1 == null || color2 == null) {
            throw new NullPointerException(Messages.getString("awt.6E"));
        }
        this.point1 = point1;
        this.point2 = point2;
        this.color1 = color1;
        this.color2 = color2;
        this.cyclic = cyclic;
    }

    public GradientPaint(float x1, float y1, Color color1, float x2, float y2, Color color2, boolean cyclic) {
        this(new Point2D.Float(x1, y1), color1, new Point2D.Float(x2, y2), color2, cyclic);
    }

    public GradientPaint(float x1, float y1, Color color1, float x2, float y2, Color color2) {
        this(x1, y1, color1, x2, y2, color2, false);
    }

    public GradientPaint(Point2D point1, Color color1, Point2D point2, Color color2) {
        this(point1, color1, point2, color2, false);
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform t, RenderingHints hints) {
        return new GradientPaintContext(cm, t, this.point1, this.color1, this.point2, this.color2, this.cyclic);
    }

    public Color getColor1() {
        return this.color1;
    }

    public Color getColor2() {
        return this.color2;
    }

    public Point2D getPoint1() {
        return this.point1;
    }

    public Point2D getPoint2() {
        return this.point2;
    }

    @Override
    public int getTransparency() {
        int a1 = this.color1.getAlpha();
        int a2 = this.color2.getAlpha();
        return a1 == 255 && a2 == 255 ? 1 : 3;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }
}

