/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.ImageCapabilities;

public class BufferCapabilities
implements Cloneable {
    private final ImageCapabilities frontBufferCapabilities;
    private final ImageCapabilities backBufferCapabilities;
    private final FlipContents flipContents;

    public BufferCapabilities(ImageCapabilities frontBufferCapabilities, ImageCapabilities backBufferCapabilities, FlipContents flipContents) {
        if (frontBufferCapabilities == null || backBufferCapabilities == null) {
            throw new IllegalArgumentException();
        }
        this.frontBufferCapabilities = frontBufferCapabilities;
        this.backBufferCapabilities = backBufferCapabilities;
        this.flipContents = flipContents;
    }

    public Object clone() {
        return new BufferCapabilities(this.frontBufferCapabilities, this.backBufferCapabilities, this.flipContents);
    }

    public ImageCapabilities getFrontBufferCapabilities() {
        return this.frontBufferCapabilities;
    }

    public ImageCapabilities getBackBufferCapabilities() {
        return this.backBufferCapabilities;
    }

    public FlipContents getFlipContents() {
        return this.flipContents;
    }

    public boolean isPageFlipping() {
        return this.flipContents != null;
    }

    public boolean isFullScreenRequired() {
        return false;
    }

    public boolean isMultiBufferAvailable() {
        return false;
    }

    public static final class FlipContents {
        public static final FlipContents BACKGROUND = new FlipContents();
        public static final FlipContents COPIED = new FlipContents();
        public static final FlipContents PRIOR = new FlipContents();
        public static final FlipContents UNDEFINED = new FlipContents();

        private FlipContents() {
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return super.toString();
        }
    }
}

