/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package javax.imageio.plugins.jpeg;


import javax.imageio.ImageReadParam;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class JPEGImageReadParam extends ImageReadParam {
    private JPEGQTable qTables[];
    private JPEGHuffmanTable dcHuffmanTables[];
    private JPEGHuffmanTable acHuffmanTables[];

    public JPEGImageReadParam() {
    }

    public boolean areTablesSet() {
        return qTables != null;
    }

    public void setDecodeTables(
            JPEGQTable[] qTables,
            JPEGHuffmanTable[] DCHuffmanTables,
            JPEGHuffmanTable[] ACHuffmanTables
    ) {
        if (qTables == null || DCHuffmanTables == null || ACHuffmanTables == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.43"));
        }
        if(DCHuffmanTables.length != ACHuffmanTables.length) {
            throw new IllegalArgumentException(Messages.getString("imageio.43"));
        }
        if (qTables.length > 4 || DCHuffmanTables.length > 4) {
            throw new IllegalArgumentException(Messages.getString("imageio.43"));
        }

        // Do the shallow copy, it should be enough
        this.qTables = qTables.clone();
        dcHuffmanTables = DCHuffmanTables.clone();
        acHuffmanTables = ACHuffmanTables.clone();
    }

    public void unsetDecodeTables() {
        qTables = null;
        dcHuffmanTables = null;
        acHuffmanTables = null;
    }

    public JPEGQTable[] getQTables() {
        return qTables == null ? null : qTables.clone();
    }

    public JPEGHuffmanTable[] getDCHuffmanTables() {
        return dcHuffmanTables == null ? null : dcHuffmanTables.clone();
    }

    public JPEGHuffmanTable[] getACHuffmanTables() {
        return acHuffmanTables == null ? null : acHuffmanTables.clone();
    }    
}
