/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.indicators;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.indicators.Indicator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/NormalSmallIndicator;", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "bottomY", "", "indicatorPath", "Landroid/graphics/Path;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "degree", "getBottom", "getTop", "setWithEffects", "withEffects", "", "updateIndicator", "speedviewlib_release"})
public final class NormalSmallIndicator
extends Indicator<NormalSmallIndicator> {
    @NotNull
    private final Path indicatorPath;
    private float bottomY;

    public NormalSmallIndicator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.indicatorPath = new Path();
        this.setWidth(this.dpTOpx(12.0f));
    }

    @Override
    public float getTop() {
        float f = this.getViewSize() / 5.0f;
        Speedometer speedometer = this.getSpeedometer();
        Intrinsics.checkNotNull((Object)speedometer);
        return f + (float)speedometer.getPadding();
    }

    @Override
    public float getBottom() {
        return this.bottomY;
    }

    @Override
    public void draw(@NotNull Canvas canvas, float degree) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        canvas.drawPath(this.indicatorPath, this.getIndicatorPaint());
        canvas.restore();
    }

    @Override
    public void updateIndicator() {
        this.indicatorPath.reset();
        float f = this.getCenterX();
        float f2 = this.getViewSize() / 5.0f;
        Speedometer speedometer = this.getSpeedometer();
        Intrinsics.checkNotNull((Object)speedometer);
        this.indicatorPath.moveTo(f, f2 + (float)speedometer.getPadding());
        float f3 = this.getViewSize() * 3.0f / 5.0f;
        Speedometer speedometer2 = this.getSpeedometer();
        Intrinsics.checkNotNull((Object)speedometer2);
        this.bottomY = f3 + (float)speedometer2.getPadding();
        this.indicatorPath.lineTo(this.getCenterX() - this.getWidth(), this.bottomY);
        this.indicatorPath.lineTo(this.getCenterX() + this.getWidth(), this.bottomY);
        RectF rectF = new RectF(this.getCenterX() - this.getWidth(), this.bottomY - this.getWidth(), this.getCenterX() + this.getWidth(), this.bottomY + this.getWidth());
        this.indicatorPath.addArc(rectF, 0.0f, 180.0f);
        this.getIndicatorPaint().setColor(this.getColor());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setWithEffects(boolean withEffects) {
        if (withEffects) {
            Speedometer speedometer = this.getSpeedometer();
            Intrinsics.checkNotNull((Object)speedometer);
            if (!speedometer.isInEditMode()) {
                this.getIndicatorPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(15.0f, BlurMaskFilter.Blur.SOLID));
                return;
            }
        }
        this.getIndicatorPaint().setMaskFilter(null);
    }
}

