/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import com.github.anastr.speedviewlib.Gauge;
import com.github.anastr.speedviewlib.LinearGauge;
import com.github.anastr.speedviewlib.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u001a\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0014J\b\u0010\u001d\u001a\u00020\u0017H\u0014J\b\u0010\u001e\u001a\u00020\u0017H\u0004J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0017H\u0004R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/github/anastr/speedviewlib/ProgressiveGauge;", "Lcom/github/anastr/speedviewlib/LinearGauge;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backPaint", "Landroid/graphics/Paint;", "frontPaint", "path", "Landroid/graphics/Path;", "speedometerBackColor", "getSpeedometerBackColor", "()I", "setSpeedometerBackColor", "(I)V", "speedometerColor", "getSpeedometerColor", "setSpeedometerColor", "defaultGaugeValues", "", "init", "initAttributeSet", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "updateFrontAndBackBitmaps", "updateHorizontalPath", "updateOrientation", "updateVerticalPath", "speedviewlib_release"})
public class ProgressiveGauge
extends LinearGauge {
    @NotNull
    private final Path path;
    @NotNull
    private final Paint frontPaint;
    @NotNull
    private final Paint backPaint;

    @JvmOverloads
    public ProgressiveGauge(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.path = new Path();
        this.frontPaint = new Paint(1);
        this.backPaint = new Paint(1);
        this.init();
        this.initAttributeSet(context, attrs);
    }

    public /* synthetic */ ProgressiveGauge(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getSpeedometerColor() {
        return this.frontPaint.getColor();
    }

    public final void setSpeedometerColor(int speedometerColor) {
        this.frontPaint.setColor(speedometerColor);
        this.invalidateGauge();
    }

    public final int getSpeedometerBackColor() {
        return this.backPaint.getColor();
    }

    public final void setSpeedometerBackColor(int speedometerBackColor) {
        this.backPaint.setColor(speedometerBackColor);
        this.invalidateGauge();
    }

    @Override
    protected void defaultGaugeValues() {
        super.setSpeedTextPosition(Gauge.Position.CENTER);
        super.setUnitUnderSpeedText(true);
    }

    private final void init() {
        this.frontPaint.setColor(-16711681);
        this.backPaint.setColor(-2697257);
    }

    private final void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LinearGauge, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.LinearGauge, 0, 0)");
        TypedArray a = typedArray;
        this.frontPaint.setColor(a.getColor(R.styleable.LinearGauge_sv_speedometerColor, this.frontPaint.getColor()));
        this.backPaint.setColor(a.getColor(R.styleable.LinearGauge_sv_speedometerBackColor, this.backPaint.getColor()));
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int w = this.getMeasuredWidth();
        int h = this.getMeasuredHeight();
        if (this.getOrientation() == LinearGauge.Orientation.HORIZONTAL) {
            if (h > w / 2) {
                this.setMeasuredDimension(w, w / 2);
            } else {
                this.setMeasuredDimension(h * 2, h);
            }
        } else if (w > h / 2) {
            this.setMeasuredDimension(h / 2, h);
        } else {
            this.setMeasuredDimension(w, w * 2);
        }
    }

    @Override
    protected void updateFrontAndBackBitmaps() {
        this.updateOrientation();
        Canvas canvasBack = this.createBackgroundBitmapCanvas();
        Canvas canvasFront = this.createForegroundBitmapCanvas();
        canvasBack.translate((float)this.getPadding(), (float)this.getPadding());
        canvasBack.drawPath(this.path, this.backPaint);
        canvasFront.drawPath(this.path, this.frontPaint);
    }

    private final void updateOrientation() {
        if (this.getOrientation() == LinearGauge.Orientation.HORIZONTAL) {
            this.updateHorizontalPath();
        } else {
            this.updateVerticalPath();
        }
    }

    protected final void updateHorizontalPath() {
        this.path.reset();
        this.path.moveTo(0.0f, (float)this.getHeightPa());
        this.path.lineTo(0.0f, (float)this.getHeightPa() - (float)this.getHeightPa() * 0.1f);
        this.path.quadTo((float)this.getWidthPa() * 0.75f, (float)this.getHeightPa() * 0.75f, (float)this.getWidthPa(), 0.0f);
        this.path.lineTo((float)this.getWidthPa(), (float)this.getHeightPa());
        this.path.lineTo(0.0f, (float)this.getHeightPa());
    }

    protected final void updateVerticalPath() {
        this.path.reset();
        this.path.moveTo(0.0f, (float)this.getHeightPa());
        this.path.lineTo((float)this.getWidthPa() * 0.1f, (float)this.getHeightPa());
        this.path.quadTo((float)this.getWidthPa() * 0.25f, (float)this.getHeightPa() * 0.25f, (float)this.getWidthPa(), 0.0f);
        this.path.lineTo(0.0f, 0.0f);
        this.path.lineTo(0.0f, (float)this.getHeightPa());
    }

    @JvmOverloads
    public ProgressiveGauge(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ProgressiveGauge(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

