/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.note;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.anastr.speedviewlib.components.note.Note$WhenMappings;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b%\b&\u0018\u0000 E*\u0010\b\u0000\u0010\u0001 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u0003DEFB\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u000bH&J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0013J\u001e\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0013J \u0010.\u001a\u00020 2\u0006\u0010+\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0013H$J\u0006\u00101\u001a\u00020\u0007J\u0006\u00102\u001a\u00020\u0013J\u0006\u00103\u001a\u00020\u001dJ\u0018\u00104\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0004J\u0013\u00105\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u00106J\u0013\u00107\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u00108J\u0013\u00109\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010:J+\u0010;\u001a\u00028\u00002\u0006\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\u00132\u0006\u0010>\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u0013\u00a2\u0006\u0002\u0010@J\u0013\u0010A\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020 H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/github/anastr/speedviewlib/components/note/Note;", "N", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "align", "Lcom/github/anastr/speedviewlib/components/note/Note$Align;", "backgroundBitmap", "Landroid/graphics/Bitmap;", "backgroundColor", "", "getBackgroundColor", "()I", "backgroundPaint", "Landroid/graphics/Paint;", "containsH", "containsW", "cornersRound", "", "density", "noteH", "noteW", "paddingBottom", "paddingLeft", "paddingRight", "paddingTop", "paint", "position", "Lcom/github/anastr/speedviewlib/components/note/Note$Position;", "triangleHeight", "bitmapBottom", "", "c", "Landroid/graphics/Canvas;", "bitmapLeft", "bitmapRight", "bitmapTop", "build", "viewWidth", "dpTOpx", "dp", "draw", "canvas", "posX", "posY", "drawContains", "leftX", "topY", "getAlign", "getCornersRound", "getPosition", "noticeContainsSizeChange", "setAlign", "(Lcom/github/anastr/speedviewlib/components/note/Note$Align;)Lcom/github/anastr/speedviewlib/components/note/Note;", "setBackgroundColor", "(I)Lcom/github/anastr/speedviewlib/components/note/Note;", "setCornersRound", "(F)Lcom/github/anastr/speedviewlib/components/note/Note;", "setPadding", "left", "top", "right", "bottom", "(FFFF)Lcom/github/anastr/speedviewlib/components/note/Note;", "setPosition", "(Lcom/github/anastr/speedviewlib/components/note/Note$Position;)Lcom/github/anastr/speedviewlib/components/note/Note;", "updateBackgroundBitmap", "Align", "Companion", "Position", "speedviewlib_release"})
public abstract class Note<N extends Note<? extends N>> {
    private final float density;
    private final Paint paint;
    private final Paint backgroundPaint;
    private float paddingLeft;
    private float paddingTop;
    private float paddingRight;
    private float paddingBottom;
    private Bitmap backgroundBitmap;
    private Position position;
    private Align align;
    private int noteW;
    private int noteH;
    private int containsW;
    private int containsH;
    private float cornersRound;
    private float triangleHeight;
    public static final int INFINITE = -1;
    public static final Companion Companion = new Companion(null);

    public final int getBackgroundColor() {
        return this.backgroundPaint.getColor();
    }

    public final float dpTOpx(float dp) {
        return dp * this.density;
    }

    protected abstract void drawContains(@NotNull Canvas var1, float var2, float var3);

    public abstract void build(int var1);

    protected final void noticeContainsSizeChange(int containsW, int containsH) {
        this.containsW = containsW;
        this.containsH = containsH;
        if (this.align == Align.Top || this.align == Align.Bottom) {
            this.noteW = (int)((float)containsW + this.paddingLeft + this.paddingRight);
            this.noteH = (int)((float)containsH + this.paddingTop + this.paddingBottom + this.triangleHeight);
        } else {
            this.noteW = (int)((float)containsW + this.paddingLeft + this.paddingRight + this.triangleHeight);
            this.noteH = (int)((float)containsH + this.paddingTop + this.paddingBottom);
        }
        this.updateBackgroundBitmap();
    }

    private final void updateBackgroundBitmap() {
        if (this.noteW > 0 && this.noteH > 0) {
            Bitmap bitmap = Bitmap.createBitmap((int)this.noteW, (int)this.noteH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(note\u2026 Bitmap.Config.ARGB_8888)");
            this.backgroundBitmap = bitmap;
            Canvas c = new Canvas(this.backgroundBitmap);
            switch (Note$WhenMappings.$EnumSwitchMapping$0[this.align.ordinal()]) {
                case 1: {
                    this.bitmapLeft(c);
                    break;
                }
                case 2: {
                    this.bitmapTop(c);
                    break;
                }
                case 3: {
                    this.bitmapRight(c);
                    break;
                }
                case 4: {
                    this.bitmapBottom(c);
                    break;
                }
            }
        }
    }

    private final void bitmapLeft(Canvas c) {
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.noteW - this.triangleHeight, (float)this.noteH);
        Path p = new Path();
        p.moveTo((float)this.noteW, (float)this.noteH / 2.0f);
        p.lineTo(rectF.right - 1.0f, (float)this.noteH / 2.0f - this.dpTOpx(9.0f));
        p.lineTo(rectF.right - 1.0f, (float)this.noteH / 2.0f + this.dpTOpx(9.0f));
        c.drawPath(p, this.backgroundPaint);
        c.drawRoundRect(rectF, this.cornersRound, this.cornersRound, this.backgroundPaint);
    }

    private final void bitmapTop(Canvas c) {
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.noteW, (float)this.noteH - this.triangleHeight);
        Path p = new Path();
        p.moveTo((float)this.noteW / 2.0f, (float)this.noteH);
        p.lineTo((float)this.noteW / 2.0f - this.dpTOpx(9.0f), rectF.bottom - 1.0f);
        p.lineTo((float)this.noteW / 2.0f + this.dpTOpx(9.0f), rectF.bottom - 1.0f);
        c.drawPath(p, this.backgroundPaint);
        c.drawRoundRect(rectF, this.cornersRound, this.cornersRound, this.backgroundPaint);
    }

    private final void bitmapRight(Canvas c) {
        RectF rectF = new RectF(0.0f + this.triangleHeight, 0.0f, (float)this.noteW, (float)this.noteH);
        Path p = new Path();
        p.moveTo(0.0f, (float)this.noteH / 2.0f);
        p.lineTo(rectF.left + 1.0f, (float)this.noteH / 2.0f - this.dpTOpx(9.0f));
        p.lineTo(rectF.left + 1.0f, (float)this.noteH / 2.0f + this.dpTOpx(9.0f));
        c.drawPath(p, this.backgroundPaint);
        c.drawRoundRect(rectF, this.cornersRound, this.cornersRound, this.backgroundPaint);
    }

    private final void bitmapBottom(Canvas c) {
        RectF rectF = new RectF(0.0f, 0.0f + this.triangleHeight, (float)this.noteW, (float)this.noteH);
        Path p = new Path();
        p.moveTo((float)this.noteW / 2.0f, 0.0f);
        p.lineTo((float)this.noteW / 2.0f - this.dpTOpx(9.0f), rectF.top + 1.0f);
        p.lineTo((float)this.noteW / 2.0f + this.dpTOpx(9.0f), rectF.top + 1.0f);
        c.drawPath(p, this.backgroundPaint);
        c.drawRoundRect(rectF, this.cornersRound, this.cornersRound, this.backgroundPaint);
    }

    public final void draw(@NotNull Canvas canvas, float posX, float posY) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        switch (Note$WhenMappings.$EnumSwitchMapping$1[this.align.ordinal()]) {
            case 1: {
                canvas.drawBitmap(this.backgroundBitmap, posX - (float)this.noteW, posY - (float)this.noteH / 2.0f, this.paint);
                this.drawContains(canvas, posX - (float)this.noteW + this.paddingLeft, posY - (float)this.noteH / 2.0f + this.paddingTop);
                break;
            }
            case 2: {
                canvas.drawBitmap(this.backgroundBitmap, posX - (float)this.noteW / 2.0f, posY - (float)this.noteH, this.paint);
                this.drawContains(canvas, posX - (float)this.containsW / 2.0f, posY - (float)this.noteH + this.paddingTop);
                break;
            }
            case 3: {
                canvas.drawBitmap(this.backgroundBitmap, posX, posY - (float)this.noteH / 2.0f, this.paint);
                this.drawContains(canvas, posX + this.triangleHeight + this.paddingLeft, posY - (float)this.noteH / 2.0f + this.paddingTop);
                break;
            }
            case 4: {
                canvas.drawBitmap(this.backgroundBitmap, posX - (float)this.noteW / 2.0f, posY, this.paint);
                this.drawContains(canvas, posX - (float)this.containsW / 2.0f, posY + this.triangleHeight + this.paddingTop);
                break;
            }
        }
    }

    @NotNull
    public final N setBackgroundColor(int backgroundColor) {
        this.backgroundPaint.setColor(backgroundColor);
        Note note = this;
        if (note == null) {
            throw new TypeCastException("null cannot be cast to non-null type N");
        }
        return (N)note;
    }

    public final float getCornersRound() {
        return this.cornersRound;
    }

    @NotNull
    public final N setCornersRound(float cornersRound) {
        boolean bl = cornersRound >= 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "cornersRound cannot be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.cornersRound = cornersRound;
        Note note = this;
        if (note == null) {
            throw new TypeCastException("null cannot be cast to non-null type N");
        }
        return (N)note;
    }

    @NotNull
    public final Align getAlign() {
        return this.align;
    }

    @NotNull
    public final N setAlign(@NotNull Align align) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)align), (String)"align");
        this.align = align;
        Note note = this;
        if (note == null) {
            throw new TypeCastException("null cannot be cast to non-null type N");
        }
        return (N)note;
    }

    @NotNull
    public final Position getPosition() {
        return this.position;
    }

    @NotNull
    public final N setPosition(@NotNull Position position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)position), (String)"position");
        this.position = position;
        Note note = this;
        if (note == null) {
            throw new TypeCastException("null cannot be cast to non-null type N");
        }
        return (N)note;
    }

    @NotNull
    public final N setPadding(float left, float top, float right, float bottom) {
        this.paddingLeft = left;
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
        this.noticeContainsSizeChange(this.containsW, this.containsH);
        Note note = this;
        if (note == null) {
            throw new TypeCastException("null cannot be cast to non-null type N");
        }
        return (N)note;
    }

    protected Note(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.density = resources.getDisplayMetrics().density;
        this.paint = new Paint(1);
        this.backgroundPaint = new Paint(1);
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
        this.backgroundBitmap = bitmap;
        this.position = Position.CenterIndicator;
        this.align = Align.Top;
        this.cornersRound = 5.0f;
        this.triangleHeight = this.dpTOpx(12.0f);
        this.backgroundPaint.setColor((int)4292270039L);
        this.setPadding(this.dpTOpx(7.0f), this.dpTOpx(7.0f), this.dpTOpx(7.0f), this.dpTOpx(7.0f));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/github/anastr/speedviewlib/components/note/Note$Position;", "", "(Ljava/lang/String;I)V", "TopIndicator", "CenterIndicator", "BottomIndicator", "TopSpeedometer", "CenterSpeedometer", "QuarterSpeedometer", "speedviewlib_release"})
    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position TopIndicator;
        public static final /* enum */ Position CenterIndicator;
        public static final /* enum */ Position BottomIndicator;
        public static final /* enum */ Position TopSpeedometer;
        public static final /* enum */ Position CenterSpeedometer;
        public static final /* enum */ Position QuarterSpeedometer;
        private static final /* synthetic */ Position[] $VALUES;

        static {
            Position[] positionArray = new Position[6];
            Position[] positionArray2 = positionArray;
            positionArray[0] = TopIndicator = new Position();
            positionArray[1] = CenterIndicator = new Position();
            positionArray[2] = BottomIndicator = new Position();
            positionArray[3] = TopSpeedometer = new Position();
            positionArray[4] = CenterSpeedometer = new Position();
            positionArray[5] = QuarterSpeedometer = new Position();
            $VALUES = positionArray;
        }

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String string) {
            return Enum.valueOf(Position.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/anastr/speedviewlib/components/note/Note$Align;", "", "(Ljava/lang/String;I)V", "Left", "Top", "Right", "Bottom", "speedviewlib_release"})
    public static final class Align
    extends Enum<Align> {
        public static final /* enum */ Align Left;
        public static final /* enum */ Align Top;
        public static final /* enum */ Align Right;
        public static final /* enum */ Align Bottom;
        private static final /* synthetic */ Align[] $VALUES;

        static {
            Align[] alignArray = new Align[4];
            Align[] alignArray2 = alignArray;
            alignArray[0] = Left = new Align();
            alignArray[1] = Top = new Align();
            alignArray[2] = Right = new Align();
            alignArray[3] = Bottom = new Align();
            $VALUES = alignArray;
        }

        public static Align[] values() {
            return (Align[])$VALUES.clone();
        }

        public static Align valueOf(String string) {
            return Enum.valueOf(Align.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/anastr/speedviewlib/components/note/Note$Companion;", "", "()V", "INFINITE", "", "speedviewlib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

