/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImageRGBFilter
extends GPUImageFilter {
    public static final String RGB_FRAGMENT_SHADER = "  varying highp vec2 textureCoordinate;\n  \n  uniform sampler2D inputImageTexture;\n  uniform highp float red;\n  uniform highp float green;\n  uniform highp float blue;\n  \n  void main()\n  {\n      highp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n      \n      gl_FragColor = vec4(textureColor.r * red, textureColor.g * green, textureColor.b * blue, 1.0);\n  }\n";
    private int redLocation;
    private float red;
    private int greenLocation;
    private float green;
    private int blueLocation;
    private float blue;

    public GPUImageRGBFilter() {
        this(1.0f, 1.0f, 1.0f);
    }

    public GPUImageRGBFilter(float red, float green, float blue) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", RGB_FRAGMENT_SHADER);
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.redLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"red");
        this.greenLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"green");
        this.blueLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"blue");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setRed(this.red);
        this.setGreen(this.green);
        this.setBlue(this.blue);
    }

    public void setRed(float red) {
        this.red = red;
        this.setFloat(this.redLocation, this.red);
    }

    public void setGreen(float green) {
        this.green = green;
        this.setFloat(this.greenLocation, this.green);
    }

    public void setBlue(float blue) {
        this.blue = blue;
        this.setFloat(this.blueLocation, this.blue);
    }
}

