/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.webapi.parser.spec.async.emitters;

import amf.core.emitter.EntryEmitter;
import amf.core.emitter.SpecOrdering;
import amf.plugins.document.webapi.contexts.SpecEmitterContext;
import amf.plugins.document.webapi.parser.spec.async.emitters.ApiKeySettingsEmitters;
import amf.plugins.document.webapi.parser.spec.async.emitters.HttpApiKeySettingsEmitters;
import amf.plugins.document.webapi.parser.spec.async.emitters.HttpSettingsEmitters;
import amf.plugins.document.webapi.parser.spec.async.emitters.OpenIdConnectSettingsEmitters;
import amf.plugins.document.webapi.parser.spec.declaration.AnnotationsEmitter;
import amf.plugins.document.webapi.parser.spec.oas.emitters.Oas3OAuth2SettingsEmitters;
import amf.plugins.domain.webapi.models.security.ApiKeySettings;
import amf.plugins.domain.webapi.models.security.HttpApiKeySettings;
import amf.plugins.domain.webapi.models.security.HttpSettings;
import amf.plugins.domain.webapi.models.security.OAuth2Settings;
import amf.plugins.domain.webapi.models.security.OpenIdConnectSettings;
import amf.plugins.domain.webapi.models.security.Settings;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3Aa\u0002\u0005\u00013!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011!i\u0001A!A!\u0002\u0017)\u0004\"B\u001e\u0001\t\u0003a\u0004\"B\u0005\u0001\t\u0003\u0019\u0005\"B*\u0001\t\u0013!&\u0001H!ts:\u001c7+Z2ve&$\u0018pU3ui&twm]#nSR$XM\u001d\u0006\u0003\u0013)\t\u0001\"Z7jiR,'o\u001d\u0006\u0003\u00171\tQ!Y:z]\u000eT!!\u0004\b\u0002\tM\u0004Xm\u0019\u0006\u0003\u001fA\ta\u0001]1sg\u0016\u0014(BA\t\u0013\u0003\u00199XMY1qS*\u00111\u0003F\u0001\tI>\u001cW/\\3oi*\u0011QCF\u0001\ba2,x-\u001b8t\u0015\u00059\u0012aA1nM\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u0006A1/\u001a;uS:<7\u000f\u0005\u0002#U5\t1E\u0003\u0002%K\u0005A1/Z2ve&$\u0018P\u0003\u0002'O\u00051Qn\u001c3fYNT!!\u0005\u0015\u000b\u0005%\"\u0012A\u00023p[\u0006Lg.\u0003\u0002,G\tA1+\u001a;uS:<7/\u0001\u0005pe\u0012,'/\u001b8h!\tq3'D\u00010\u0015\t\u0001\u0014'A\u0004f[&$H/\u001a:\u000b\u0005I2\u0012\u0001B2pe\u0016L!\u0001N\u0018\u0003\u0019M\u0003XmY(sI\u0016\u0014\u0018N\\4\u0011\u0005YJT\"A\u001c\u000b\u0005a\u0002\u0012\u0001C2p]R,\u0007\u0010^:\n\u0005i:$AE*qK\u000e,U.\u001b;uKJ\u001cuN\u001c;fqR\fa\u0001P5oSRtDcA\u001fB\u0005R\u0011a\b\u0011\t\u0003\u007f\u0001i\u0011\u0001\u0003\u0005\u0006\u001b\u0011\u0001\u001d!\u000e\u0005\u0006A\u0011\u0001\r!\t\u0005\u0006Y\u0011\u0001\r!L\u000b\u0002\tB\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%\u0019\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002M9\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005\r\u0019V-\u001d\u0006\u0003\u0019r\u0001\"AL)\n\u0005I{#\u0001D#oiJLX)\\5ui\u0016\u0014\u0018aC3nSR$XM]:G_J$\"\u0001R+\t\u000b\u00012\u0001\u0019A\u0011")
public class AsyncSecuritySettingsEmitter {
    private final Settings settings;
    private final SpecOrdering ordering;
    private final SpecEmitterContext spec;

    public Seq<EntryEmitter> emitters() {
        return this.emittersFor(this.settings);
    }

    private Seq<EntryEmitter> emittersFor(Settings settings) {
        Seq<EntryEmitter> seq;
        Settings settings2 = settings;
        if (settings2 instanceof HttpSettings) {
            HttpSettings httpSettings = (HttpSettings)settings2;
            seq = new HttpSettingsEmitters(httpSettings, this.ordering, this.spec).emitters();
        } else if (settings2 instanceof ApiKeySettings) {
            ApiKeySettings apiKeySettings = (ApiKeySettings)settings2;
            seq = new ApiKeySettingsEmitters(apiKeySettings, this.ordering, this.spec).emitters();
        } else if (settings2 instanceof HttpApiKeySettings) {
            HttpApiKeySettings httpApiKeySettings = (HttpApiKeySettings)settings2;
            seq = new HttpApiKeySettingsEmitters(httpApiKeySettings, this.ordering, this.spec).emitters();
        } else if (settings2 instanceof OpenIdConnectSettings) {
            OpenIdConnectSettings openIdConnectSettings = (OpenIdConnectSettings)settings2;
            seq = new OpenIdConnectSettingsEmitters(openIdConnectSettings, this.ordering, this.spec).emitters();
        } else if (settings2 instanceof OAuth2Settings) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)settings2;
            seq = new Oas3OAuth2SettingsEmitters(oAuth2Settings, this.ordering, this.spec).emitters();
        } else {
            seq = (Seq<EntryEmitter>)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        Seq<EntryEmitter> particularEmitters = seq;
        Seq result = (Seq)particularEmitters.$plus$plus(new AnnotationsEmitter(settings, this.ordering, this.spec).emitters(), Seq$.MODULE$.canBuildFrom());
        return this.ordering.sorted(result);
    }

    public AsyncSecuritySettingsEmitter(Settings settings, SpecOrdering ordering, SpecEmitterContext spec) {
        this.settings = settings;
        this.ordering = ordering;
        this.spec = spec;
    }
}

