/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.features.validation.custom;

import amf.AmfProfile$;
import amf.MessageStyle;
import amf.Oas20Profile$;
import amf.Oas30Profile$;
import amf.OasProfile$;
import amf.ProfileName;
import amf.Raml08Profile$;
import amf.Raml10Profile$;
import amf.RamlProfile$;
import amf.client.execution.BaseExecutionEnvironment;
import amf.client.parse.DefaultParserErrorHandler$;
import amf.client.plugins.AMFDocumentPlugin;
import amf.client.plugins.AMFFeaturePlugin;
import amf.client.plugins.AMFPlugin;
import amf.client.plugins.AMFValidationPlugin;
import amf.client.remote.Content;
import amf.core.annotations.SourceVendor;
import amf.core.benchmark.ExecutionLog$;
import amf.core.client.ParsingOptions;
import amf.core.errorhandling.AmfStaticReportBuilder;
import amf.core.errorhandling.ErrorHandler;
import amf.core.metamodel.Field;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.Document;
import amf.core.model.document.Fragment;
import amf.core.model.document.Module;
import amf.core.model.domain.DomainElement;
import amf.core.parser.Annotations;
import amf.core.parser.ParsedDocument;
import amf.core.parser.ReferenceKind;
import amf.core.parser.errorhandler.AmfParserErrorHandler;
import amf.core.rdf.RdfModel;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Cache;
import amf.core.remote.Cache$;
import amf.core.remote.Context;
import amf.core.remote.Context$;
import amf.core.remote.Oas30$;
import amf.core.remote.Platform;
import amf.core.remote.Raml08$;
import amf.core.remote.Vendor;
import amf.core.services.RuntimeCompiler$;
import amf.core.services.RuntimeValidator;
import amf.core.services.RuntimeValidator$;
import amf.core.services.ValidationOptions;
import amf.core.unsafe.PlatformSecrets;
import amf.core.validation.AMFValidationReport;
import amf.core.validation.AMFValidationResult;
import amf.core.validation.EffectiveValidations;
import amf.core.validation.EffectiveValidations$;
import amf.core.validation.ValidationResultProcessor;
import amf.core.validation.core.ValidationProfile;
import amf.core.validation.core.ValidationReport;
import amf.core.validation.core.ValidationResult;
import amf.core.validation.core.ValidationSpecification;
import amf.internal.environment.Environment;
import amf.internal.environment.Environment$;
import amf.plugins.document.graph.AMFGraphPlugin$;
import amf.plugins.document.vocabularies.AMLPlugin$;
import amf.plugins.document.vocabularies.model.document.DialectInstance;
import amf.plugins.document.vocabularies.model.domain.DialectDomainElement;
import amf.plugins.features.validation.PlatformValidator$;
import amf.plugins.features.validation.custom.CustomShaclValidator;
import amf.plugins.features.validation.custom.model.ParsedValidationProfile$;
import amf.plugins.features.validation.custom.model.ValidationDialectText$;
import amf.plugins.features.validation.emitters.JSLibraryEmitter;
import amf.plugins.features.validation.emitters.ValidationJSONLDEmitter;
import amf.plugins.features.validation.emitters.ValidationJSONLDEmitter$;
import amf.plugins.syntax.SYamlSyntaxPlugin$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AMFValidatorPlugin$
implements AMFFeaturePlugin,
RuntimeValidator,
ValidationResultProcessor {
    public static AMFValidatorPlugin$ MODULE$;
    private final String ID;
    private final String url;
    private Map<String, Function0<ValidationProfile>> customValidationProfiles;
    private Map<String, AMFDocumentPlugin> customValidationProfilesPlugins;
    private final Platform platform;

    static {
        new AMFValidatorPlugin$();
    }

    public AMFValidationResult processAggregatedResult(AMFValidationResult result, MessageStyle messageStyle, EffectiveValidations validations) {
        return ValidationResultProcessor.processAggregatedResult$((ValidationResultProcessor)this, (AMFValidationResult)result, (MessageStyle)messageStyle, (EffectiveValidations)validations);
    }

    public Option<AMFValidationResult> buildValidationResult(BaseUnit model, ValidationResult result, MessageStyle messageStyle, EffectiveValidations validations) {
        return ValidationResultProcessor.buildValidationResult$((ValidationResultProcessor)this, (BaseUnit)model, (ValidationResult)result, (MessageStyle)messageStyle, (EffectiveValidations)validations);
    }

    public String findLevel(String id, EffectiveValidations validations, String string) {
        return ValidationResultProcessor.findLevel$((ValidationResultProcessor)this, (String)id, (EffectiveValidations)validations, (String)string);
    }

    public String findLevel$default$3() {
        return ValidationResultProcessor.findLevel$default$3$((ValidationResultProcessor)this);
    }

    public Future<ProfileName> loadValidationProfile(String validationProfilePath, ErrorHandler errorHandler, BaseExecutionEnvironment exec) {
        return RuntimeValidator.loadValidationProfile$((RuntimeValidator)this, (String)validationProfilePath, (ErrorHandler)errorHandler, (BaseExecutionEnvironment)exec);
    }

    public MessageStyle shaclModel$default$3() {
        return RuntimeValidator.shaclModel$default$3$((RuntimeValidator)this);
    }

    public void onBeginParsingInvocation(String url, Option<String> mediaType) {
        AMFFeaturePlugin.onBeginParsingInvocation$((AMFFeaturePlugin)this, (String)url, mediaType);
    }

    public Content onBeginDocumentParsing(String url, Content content, ReferenceKind referenceKind) {
        return AMFFeaturePlugin.onBeginDocumentParsing$((AMFFeaturePlugin)this, (String)url, (Content)content, (ReferenceKind)referenceKind);
    }

    public ParsedDocument onSyntaxParsed(String url, ParsedDocument ast) {
        return AMFFeaturePlugin.onSyntaxParsed$((AMFFeaturePlugin)this, (String)url, (ParsedDocument)ast);
    }

    public BaseUnit onModelParsed(String url, BaseUnit unit) {
        return AMFFeaturePlugin.onModelParsed$((AMFFeaturePlugin)this, (String)url, (BaseUnit)unit);
    }

    public BaseUnit onFinishedParsingInvocation(String url, BaseUnit unit) {
        return AMFFeaturePlugin.onFinishedParsingInvocation$((AMFFeaturePlugin)this, (String)url, (BaseUnit)unit);
    }

    public Platform platform() {
        return this.platform;
    }

    public void amf$core$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    public String ID() {
        return this.ID;
    }

    public Future<AMFPlugin> init(ExecutionContext executionContext) {
        RuntimeValidator$.MODULE$.register((RuntimeValidator)this);
        ExecutionLog$.MODULE$.log("Register RDF framework");
        this.platform().rdfFramework_$eq((Option)new Some((Object)PlatformValidator$.MODULE$.instance()));
        ExecutionLog$.MODULE$.log("AMFValidatorPlugin#init: registering validation dialect");
        return AMLPlugin$.MODULE$.apply().registry().registerDialect(this.url(), ValidationDialectText$.MODULE$.text(), executionContext).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            ExecutionLog$.MODULE$.log("AMFValidatorPlugin#init: validation dialect registered");
            return MODULE$;
        }, executionContext);
    }

    public Seq<PlatformSecrets> dependencies() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlatformSecrets[]{SYamlSyntaxPlugin$.MODULE$, AMLPlugin$.MODULE$, AMFGraphPlugin$.MODULE$}));
    }

    public String url() {
        return this.url;
    }

    public Map<String, Function0<ValidationProfile>> profiles() {
        return ((MapLike)AMFPluginsRegistry$.MODULE$.documentPlugins().foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map acc = (Map)tuple2._1();
                AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)tuple2._2();
                if (domainPlugin instanceof AMFValidationPlugin) {
                    AMFDocumentPlugin aMFDocumentPlugin = domainPlugin;
                    return acc.$plus$plus((GenTraversableOnce)((AMFValidationPlugin)aMFDocumentPlugin).domainValidationProfiles(MODULE$.platform()));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Map acc = (Map)tuple2._1();
            return acc;
        })).$plus$plus(this.customValidationProfiles());
    }

    public Map<String, AMFDocumentPlugin> profilesPlugins() {
        return ((MapLike)AMFPluginsRegistry$.MODULE$.documentPlugins().foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map acc = (Map)tuple2._1();
                AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)tuple2._2();
                if (domainPlugin instanceof AMFValidationPlugin) {
                    AMFDocumentPlugin aMFDocumentPlugin = domainPlugin;
                    Map toPut = (Map)((AMFValidationPlugin)aMFDocumentPlugin).domainValidationProfiles(MODULE$.platform()).keys().foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                        Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Map accProfiles = (Map)tuple2._1();
                        String profileName = (String)tuple2._2();
                        Map map = accProfiles.updated((Object)profileName, (Object)aMFDocumentPlugin);
                        return map;
                    });
                    return acc.$plus$plus((GenTraversableOnce)toPut);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Map acc = (Map)tuple2._1();
            return acc;
        })).$plus$plus(this.customValidationProfilesPlugins());
    }

    public Map<String, Function0<ValidationProfile>> customValidationProfiles() {
        return this.customValidationProfiles;
    }

    public void customValidationProfiles_$eq(Map<String, Function0<ValidationProfile>> x$1) {
        this.customValidationProfiles = x$1;
    }

    public Map<String, AMFDocumentPlugin> customValidationProfilesPlugins() {
        return this.customValidationProfilesPlugins;
    }

    public void customValidationProfilesPlugins_$eq(Map<String, AMFDocumentPlugin> x$1) {
        this.customValidationProfilesPlugins = x$1;
    }

    private AmfParserErrorHandler errorHandlerToParser(ErrorHandler eh) {
        return DefaultParserErrorHandler$.MODULE$.fromErrorHandler(eh);
    }

    public Future<ProfileName> loadValidationProfile(String validationProfilePath, Environment env, ErrorHandler errorHandler, BaseExecutionEnvironment exec) {
        ExecutionContext executionContext = exec.executionContext();
        String x$1 = validationProfilePath;
        Some x$2 = new Some((Object)"application/yaml");
        Some x$3 = new Some((Object)AMLPlugin$.MODULE$.ID());
        Context x$4 = Context$.MODULE$.apply(this.platform());
        Cache x$5 = Cache$.MODULE$.apply();
        Environment x$6 = env;
        AmfParserErrorHandler x$7 = this.errorHandlerToParser(errorHandler);
        ReferenceKind x$8 = RuntimeCompiler$.MODULE$.apply$default$6();
        Option x$9 = RuntimeCompiler$.MODULE$.apply$default$7();
        ParsingOptions x$10 = RuntimeCompiler$.MODULE$.apply$default$9();
        return RuntimeCompiler$.MODULE$.apply(x$1, (Option)x$2, (Option)x$3, x$4, x$5, x$8, x$9, x$6, x$10, x$7, executionContext).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DialectInstance dialectInstance;
            BaseUnit baseUnit = x0$1;
            if (!(baseUnit instanceof DialectInstance) || !(dialectInstance = (DialectInstance)baseUnit).definedBy().is((Object)MODULE$.url())) {
                throw new Exception("Trying to load as a validation profile that does not match the Validation Profile dialect");
            }
            DomainElement domainElement = dialectInstance.encodes();
            return domainElement;
        }, executionContext).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AMFDocumentPlugin aMFDocumentPlugin;
            DomainElement domainElement = x0$2;
            if (!(domainElement instanceof DialectDomainElement)) throw new Exception("Trying to load as a validation profile that does not match the Validation Profile dialect");
            DialectDomainElement dialectDomainElement = (DialectDomainElement)domainElement;
            if (!dialectDomainElement.definedBy().name().is((Object)"profileNode")) throw new Exception("Trying to load as a validation profile that does not match the Validation Profile dialect");
            ValidationProfile profile = ParsedValidationProfile$.MODULE$.apply(dialectDomainElement);
            Option option = MODULE$.profilesPlugins().get((Object)profile.name().profile());
            if (option instanceof Some) {
                AMFDocumentPlugin plugin;
                Some some = (Some)option;
                aMFDocumentPlugin = plugin = (AMFDocumentPlugin)some.value();
            } else {
                AMFDocumentPlugin aMFDocumentPlugin2;
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                Option option2 = MODULE$.profilesPlugins().get((Object)((ProfileName)profile.baseProfile().getOrElse((Function0 & Serializable & scala.Serializable)() -> AmfProfile$.MODULE$)).profile());
                if (option2 instanceof Some) {
                    AMFDocumentPlugin plugin;
                    Some some = (Some)option2;
                    aMFDocumentPlugin2 = plugin = (AMFDocumentPlugin)some.value();
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                    aMFDocumentPlugin2 = (AMFDocumentPlugin)AMLPlugin$.MODULE$.apply();
                }
                aMFDocumentPlugin = aMFDocumentPlugin2;
            }
            AMFDocumentPlugin domainPlugin = aMFDocumentPlugin;
            MODULE$.customValidationProfiles_$eq((Map<String, Function0<ValidationProfile>>)MODULE$.customValidationProfiles().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)profile.name().profile()), (Function0 & Serializable & scala.Serializable)() -> profile)));
            MODULE$.customValidationProfilesPlugins_$eq((Map<String, AMFDocumentPlugin>)MODULE$.customValidationProfilesPlugins().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)profile.name().profile()), (Object)domainPlugin)));
            return profile.name();
        }, executionContext);
    }

    public Environment loadValidationProfile$default$2() {
        return Environment$.MODULE$.apply();
    }

    public BaseExecutionEnvironment loadValidationProfile$default$4() {
        return this.platform().defaultExecutionEnvironment();
    }

    public EffectiveValidations computeValidations(ProfileName profileName, EffectiveValidations computed) {
        EffectiveValidations effectiveValidations;
        None$ maybeProfile;
        None$ none$;
        Option option = this.profiles().get((Object)profileName.profile());
        if (option instanceof Some) {
            Some some = (Some)option;
            Function0 profileGenerator = (Function0)some.value();
            none$ = new Some(profileGenerator.apply());
        } else {
            none$ = None$.MODULE$;
        }
        None$ none$2 = maybeProfile = none$;
        if (none$2 instanceof Some) {
            Some some = (Some)none$2;
            ValidationProfile foundProfile = (ValidationProfile)some.value();
            effectiveValidations = foundProfile.baseProfile().isDefined() ? this.computeValidations((ProfileName)foundProfile.baseProfile().get(), computed).someEffective(foundProfile) : computed.someEffective(foundProfile);
        } else if (None$.MODULE$.equals(none$2)) {
            effectiveValidations = computed;
        } else {
            throw new MatchError((Object)none$2);
        }
        return effectiveValidations;
    }

    public EffectiveValidations computeValidations$default$2() {
        return new EffectiveValidations(EffectiveValidations$.MODULE$.$lessinit$greater$default$1(), EffectiveValidations$.MODULE$.$lessinit$greater$default$2());
    }

    public Future<ValidationReport> shaclValidation(BaseUnit model, EffectiveValidations validations, Map<String, Function2<DomainElement, Function1<Option<Tuple2<Annotations, Field>>, BoxedUnit>, BoxedUnit>> customFunctions, ValidationOptions options, ExecutionContext executionContext) {
        return options.isPartialValidation() ? this.partialShaclValidation(model, validations, customFunctions, options, executionContext) : this.fullShaclValidation(model, validations, options, executionContext);
    }

    public Future<ValidationReport> partialShaclValidation(BaseUnit model, EffectiveValidations validations, Map<String, Function2<DomainElement, Function1<Option<Tuple2<Annotations, Field>>, BoxedUnit>, BoxedUnit>> customFunctions, ValidationOptions options, ExecutionContext executionContext) {
        return new CustomShaclValidator(model, validations, customFunctions, options, executionContext).run();
    }

    public Future<ValidationReport> fullShaclValidation(BaseUnit model, EffectiveValidations validations, ValidationOptions options, ExecutionContext executionContext) {
        ExecutionLog$.MODULE$.log(new StringBuilder(69).append("AMFValidatorPlugin#shaclValidation: shacl validation for ").append(validations.effective().values().size()).append(" validations").toString());
        if (PlatformValidator$.MODULE$.instance().supportsJSFunctions()) {
            Option jsLibrary = new JSLibraryEmitter((Option)None$.MODULE$).emitJS(validations.effective().values().toSeq());
            Option option = jsLibrary;
            if (option instanceof Some) {
                Some some = (Some)option;
                String code = (String)some.value();
                PlatformValidator$.MODULE$.instance().registerLibrary(ValidationJSONLDEmitter$.MODULE$.validationLibraryUrl(), code);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        ExecutionLog$.MODULE$.log("AMFValidatorPlugin#shaclValidation: jsLibrary generated");
        BaseUnit data = model;
        Seq<ValidationSpecification> shapes = this.customValidations(validations);
        ExecutionLog$.MODULE$.log("AMFValidatorPlugin#shaclValidation: Invoking platform validation");
        return PlatformValidator$.MODULE$.instance().report(data, shapes, options, executionContext).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ValidationReport validationReport = x0$1;
            ExecutionLog$.MODULE$.log("AMFValidatorPlugin#shaclValidation: validation finished");
            ValidationReport validationReport2 = validationReport;
            return validationReport2;
        }, executionContext);
    }

    private ProfileName profileForUnit(BaseUnit unit, ProfileName given) {
        ProfileName profileName;
        ProfileName profileName2 = given;
        if (OasProfile$.MODULE$.equals(profileName2)) {
            Some some;
            Vendor vendor;
            Option<Vendor> option = this.getSource(unit);
            Object object = option instanceof Some && Oas30$.MODULE$.equals(vendor = (Vendor)(some = (Some)option).value()) ? Oas30Profile$.MODULE$ : Oas20Profile$.MODULE$;
            profileName = object;
        } else if (RamlProfile$.MODULE$.equals(profileName2)) {
            Some some;
            Vendor vendor;
            Option<Vendor> option = this.getSource(unit);
            Object object = option instanceof Some && Raml08$.MODULE$.equals(vendor = (Vendor)(some = (Some)option).value()) ? Raml08Profile$.MODULE$ : Raml10Profile$.MODULE$;
            profileName = object;
        } else {
            profileName = given;
        }
        return profileName;
    }

    private Option<Vendor> getSource(BaseUnit unit) {
        Option option;
        BaseUnit baseUnit = unit;
        if (baseUnit instanceof Document) {
            Document document = (Document)baseUnit;
            option = document.encodes().annotations().find(SourceVendor.class).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.vendor());
        } else if (baseUnit instanceof Module) {
            Module module = (Module)baseUnit;
            option = module.annotations().find(SourceVendor.class).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.vendor());
        } else if (baseUnit instanceof Fragment) {
            Fragment fragment = (Fragment)baseUnit;
            option = fragment.encodes().annotations().find(SourceVendor.class).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.vendor());
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public Future<AMFValidationReport> validate(BaseUnit model, ProfileName given, MessageStyle messageStyle, Environment env, boolean resolved, BaseExecutionEnvironment exec) {
        ProfileName profileName = this.profileForUnit(model, given);
        AMFValidationReport report = new AmfStaticReportBuilder(model, profileName).buildFromStatic();
        return !report.conforms() ? Future$.MODULE$.successful((Object)report) : this.modelValidation(model, profileName, messageStyle, env, resolved, exec);
    }

    public boolean validate$default$5() {
        return false;
    }

    public BaseExecutionEnvironment validate$default$6() {
        return this.platform().defaultExecutionEnvironment();
    }

    private Future<AMFValidationReport> modelValidation(BaseUnit model, ProfileName profileName, MessageStyle messageStyle, Environment env, boolean resolved, BaseExecutionEnvironment exec) {
        Future future;
        Some some;
        AMFDocumentPlugin domainPlugin;
        ExecutionContext executionContext = exec.executionContext();
        Option option = this.profilesPlugins().get((Object)profileName.profile());
        if (option instanceof Some && (domainPlugin = (AMFDocumentPlugin)(some = (Some)option).value()) instanceof AMFValidationPlugin) {
            AMFDocumentPlugin aMFDocumentPlugin = domainPlugin;
            EffectiveValidations validations = this.computeValidations(profileName, this.computeValidations$default$2());
            future = ((AMFValidationPlugin)aMFDocumentPlugin).validationRequest(model, profileName, validations, this.platform(), env, resolved, exec);
        } else {
            future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.profileNotFoundWarningReport(model, profileName), executionContext);
        }
        return future;
    }

    public AMFValidationReport profileNotFoundWarningReport(BaseUnit model, ProfileName profileName) {
        return new AMFValidationReport(true, (String)model.location().getOrElse((Function0 & Serializable & scala.Serializable)() -> model.id()), profileName, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public String shapesGraph(EffectiveValidations validations, ProfileName profileName) {
        return new ValidationJSONLDEmitter(profileName).emitJSON(this.customValidations(validations));
    }

    public ProfileName shapesGraph$default$2() {
        return RamlProfile$.MODULE$;
    }

    public Seq<ValidationSpecification> customValidations(EffectiveValidations validations) {
        return (Seq)validations.effective().values().toSeq().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AMFValidatorPlugin$.$anonfun$customValidations$1(s)));
    }

    public RdfModel shaclModel(Seq<ValidationSpecification> validations, String functionUrls, MessageStyle messageStyle) {
        return PlatformValidator$.MODULE$.instance().shapes(validations, functionUrls);
    }

    public String emitShapesGraph(ProfileName profileName) {
        EffectiveValidations effectiveValidations = this.computeValidations(profileName, this.computeValidations$default$2());
        return this.shapesGraph(effectiveValidations, profileName);
    }

    public static final /* synthetic */ boolean $anonfun$customValidations$1(ValidationSpecification s) {
        return !s.isParserSide();
    }

    private AMFValidatorPlugin$() {
        MODULE$ = this;
        AMFFeaturePlugin.$init$((AMFFeaturePlugin)this);
        PlatformSecrets.$init$((PlatformSecrets)this);
        RuntimeValidator.$init$((RuntimeValidator)this);
        ValidationResultProcessor.$init$((ValidationResultProcessor)this);
        this.ID = "AMF Validation";
        this.url = "http://a.ml/dialects/profile.raml";
        this.customValidationProfiles = Predef$.MODULE$.Map().empty();
        this.customValidationProfilesPlugins = Predef$.MODULE$.Map().empty();
    }
}

