/*
 * Decompiled with CFR 0.152.
 */
package amf.aml.internal.parse.common;

import amf.aml.client.scala.model.document.Vocabulary;
import amf.aml.internal.parse.DynamicExtensionParser;
import amf.aml.internal.parse.DynamicExtensionParser$;
import amf.aml.internal.parse.common.AnnotationsParser;
import amf.aml.internal.parse.instances.DialectInstanceContext;
import amf.aml.internal.parse.vocabularies.VocabularyDeclarations;
import amf.aml.internal.semantic.SemanticExtensionsFacade;
import amf.aml.internal.validate.DialectValidations$;
import amf.core.client.scala.model.domain.AmfElement;
import amf.core.client.scala.model.domain.AmfObject;
import amf.core.client.scala.model.domain.DataNode;
import amf.core.client.scala.model.domain.NamedAmfObject;
import amf.core.client.scala.model.domain.extensions.CustomDomainProperty;
import amf.core.client.scala.model.domain.extensions.CustomDomainProperty$;
import amf.core.client.scala.model.domain.extensions.DomainExtension;
import amf.core.client.scala.model.domain.extensions.DomainExtension$;
import amf.core.client.scala.parse.document.ParserContext;
import amf.core.internal.metamodel.domain.DomainElementModel$;
import amf.core.internal.metamodel.domain.extensions.DomainExtensionModel$;
import amf.core.internal.parser.domain.Annotations$;
import amf.core.internal.plugins.document.graph.parser.FlattenedUnitGraphParser$;
import java.io.Serializable;
import org.yaml.convert.YRead;
import org.yaml.model.IllegalTypeHandler;
import org.yaml.model.IllegalTypeHandler$;
import org.yaml.model.YMap;
import org.yaml.model.YMapEntry;
import org.yaml.model.YNode;
import org.yaml.model.YNode$;
import org.yaml.model.YPart;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeq$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public final class AnnotationsParser$ {
    public static AnnotationsParser$ MODULE$;

    static {
        new AnnotationsParser$();
    }

    public Object parseAnnotations(YMap ast, AmfObject node, VocabularyDeclarations declarations, ParserContext ctx) {
        return this.computeAnnotationInfo(ast).flatMap((Function1 & Serializable & scala.Serializable)ai -> Option$.MODULE$.option2Iterable(MODULE$.computeSemanticExtensionParser(ctx, ai.key()).flatMap((Function1 & Serializable & scala.Serializable)parser -> {
            String id = new StringBuilder(0).append(node.id()).append(MODULE$.annotationInfoId((AnnotationsParser.AnnotationInfo)ai)).toString();
            List types = (List)node.meta().type().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.iri(), List$.MODULE$.canBuildFrom());
            return parser.parse((Seq<String>)types, ai.entry(), ctx, id);
        }).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseRegularAnnotation(node, declarations, ctx, (AnnotationsParser.AnnotationInfo)ai)).map((Function1 & Serializable & scala.Serializable)extension2 -> node.add(DomainElementModel$.MODULE$.CustomDomainProperties(), (AmfElement)extension2))), Seq$.MODULE$.canBuildFrom());
    }

    private String annotationInfoId(AnnotationsParser.AnnotationInfo ai) {
        return new StringBuilder(0).append(ai.prefix().map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(1).append((String)x$2).append("/").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "/")).append(ai.suffix()).toString();
    }

    private Option<SemanticExtensionsFacade> computeSemanticExtensionParser(ParserContext ctx, String key) {
        None$ none$;
        ParserContext parserContext = ctx;
        if (parserContext instanceof DialectInstanceContext) {
            DialectInstanceContext dialectInstanceContext = (DialectInstanceContext)parserContext;
            none$ = new Some((Object)dialectInstanceContext.extensionsFacadeBuilder().extensionName(key));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<DomainExtension> parseRegularAnnotation(AmfObject node, VocabularyDeclarations declarations, ParserContext ctx, AnnotationsParser.AnnotationInfo ai) {
        None$ none$;
        YNode value = ai.entry().value();
        String key = ai.originalKey();
        Try<String> try_ = declarations.resolveExternalNamespace(ai.prefix(), ai.suffix());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String propertyId = (String)success.value();
            String id = new StringBuilder(0).append(node.id()).append(this.annotationInfoId(ai)).toString();
            DataNode parsedAnnotation = new DynamicExtensionParser(value, (Option<String>)new Some((Object)id), DynamicExtensionParser$.MODULE$.apply$default$3(), DynamicExtensionParser$.MODULE$.apply$default$4(), ctx).parse();
            CustomDomainProperty property = (CustomDomainProperty)((NamedAmfObject)CustomDomainProperty$.MODULE$.apply(Annotations$.MODULE$.apply((YPart)value)).withId(propertyId)).withName(key, Annotations$.MODULE$.apply());
            DomainExtension extension2 = (DomainExtension)((DomainExtension)DomainExtension$.MODULE$.apply().withId(id).set(DomainExtensionModel$.MODULE$.Extension(), (AmfElement)parsedAnnotation, Annotations$.MODULE$.inferred())).withDefinedBy(property).withName(key).add(Annotations$.MODULE$.apply((YPart)value));
            none$ = new Some((Object)extension2);
        } else if (try_ instanceof Failure) {
            None$ none$2;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            Option option = declarations.usedVocabs().get(ai.prefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            if (option instanceof Some) {
                Some some = (Some)option;
                Vocabulary vocabulary = (Vocabulary)some.value();
                String id = new StringBuilder(0).append(node.id()).append((Object)(node.id().endsWith("/") || node.id().endsWith("#") ? "" : "/")).append(this.annotationInfoId(ai)).toString();
                DataNode parsedAnnotation = new DynamicExtensionParser(value, (Option<String>)new Some((Object)id), DynamicExtensionParser$.MODULE$.apply$default$3(), DynamicExtensionParser$.MODULE$.apply$default$4(), ctx).parse();
                String base = vocabulary.base().value();
                String propertyId = base.endsWith("#") || base.endsWith("/") ? new StringBuilder(0).append(base).append(ai.suffix()).toString() : new StringBuilder(1).append(base).append("/").append(ai.suffix()).toString();
                CustomDomainProperty property = (CustomDomainProperty)((NamedAmfObject)CustomDomainProperty$.MODULE$.apply(Annotations$.MODULE$.apply((YPart)value)).withId(propertyId)).withName(ai.key());
                DomainExtension extension3 = (DomainExtension)((DomainExtension)DomainExtension$.MODULE$.apply().withId(id).set(DomainExtensionModel$.MODULE$.Extension(), (AmfElement)parsedAnnotation, Annotations$.MODULE$.inferred())).withDefinedBy(property).withName(ai.key()).add(Annotations$.MODULE$.apply((YPart)value));
                none$2 = new Some((Object)extension3);
            } else if (None$.MODULE$.equals(option)) {
                ctx.eh().violation(DialectValidations$.MODULE$.MissingVocabulary(), node.id(), ex.getMessage(), YNode$.MODULE$.toString(value, IllegalTypeHandler$.MODULE$.illegalValueHandler()));
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            none$ = none$2;
        } else {
            throw new MatchError(try_);
        }
        return none$;
    }

    private Seq<AnnotationsParser.AnnotationInfo> computeAnnotationInfo(YMap ast) {
        return (Seq)ast.entries().flatMap((Function1 & Serializable & scala.Serializable)entry -> {
            String key = (String)entry.key().as((YRead)YRead.StringYRead$.MODULE$, (IllegalTypeHandler)FlattenedUnitGraphParser$.MODULE$.ctx());
            Option<AnnotationsParser.BaseAndSeparator> maybeBS = MODULE$.getKeyName(key);
            return Option$.MODULE$.option2Iterable(maybeBS.map((Function1 & Serializable & scala.Serializable)bs -> {
                AnnotationsParser.PrefixAndSuffix ps = MODULE$.getPrefixAndSuffix((AnnotationsParser.BaseAndSeparator)bs);
                return new AnnotationsParser.AnnotationInfo(key, bs.base(), ps.prefix(), ps.suffix(), (YMapEntry)entry);
            }));
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Option<AnnotationsParser.BaseAndSeparator> getKeyName(String key) {
        None$ none$;
        Regex ramlLikeAnnotation = new StringOps(Predef$.MODULE$.augmentString("[(](.+)[)]")).r();
        Regex oasLikeAnnotation = new StringOps(Predef$.MODULE$.augmentString("x-(.+)")).r();
        String string = key;
        Option option = ramlLikeAnnotation.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String ramlValue = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = new Some((Object)new AnnotationsParser.BaseAndSeparator(ramlValue, "\\."));
        } else {
            Option option2 = oasLikeAnnotation.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String oasValue = (String)((LinearSeqOptimized)option2.get()).apply(0);
                none$ = new Some((Object)new AnnotationsParser.BaseAndSeparator(oasValue, "-"));
            } else {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private AnnotationsParser.PrefixAndSuffix getPrefixAndSuffix(AnnotationsParser.BaseAndSeparator baseAndSeparator) {
        AnnotationsParser.PrefixAndSuffix prefixAndSuffix;
        String[] stringArray = baseAndSeparator.base().split(baseAndSeparator.separator());
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            String prefix = (String)((SeqLike)option.get()).apply(0);
            String suffix = (String)((SeqLike)option.get()).apply(1);
            prefixAndSuffix = new AnnotationsParser.PrefixAndSuffix((Option<String>)new Some((Object)prefix), suffix);
        } else {
            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
                String suffix = (String)((SeqLike)option2.get()).apply(0);
                prefixAndSuffix = new AnnotationsParser.PrefixAndSuffix((Option<String>)None$.MODULE$, suffix);
            } else {
                throw new MatchError((Object)stringArray);
            }
        }
        return prefixAndSuffix;
    }

    private AnnotationsParser$() {
        MODULE$ = this;
    }
}

