/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.vocabularies;

import amf.MessageStyle;
import amf.ProfileName;
import amf.RamlProfile$;
import amf.client.plugins.AMFDocumentPlugin;
import amf.client.plugins.AMFPlugin;
import amf.client.plugins.AMFValidationPlugin;
import amf.core.Root;
import amf.core.client.ParsingOptions;
import amf.core.emitter.RenderOptions;
import amf.core.metamodel.Obj;
import amf.core.model.document.BaseUnit;
import amf.core.model.domain.AnnotationGraphLoader;
import amf.core.parser.DefaultParserSideErrorHandler$;
import amf.core.parser.ErrorHandler;
import amf.core.parser.ParserContext;
import amf.core.parser.ReferenceHandler;
import amf.core.parser.SyamlParsedDocument;
import amf.core.rdf.RdfModel;
import amf.core.registries.AMFDomainEntityResolver;
import amf.core.remote.Aml$;
import amf.core.remote.Platform;
import amf.core.resolution.pipelines.ResolutionPipeline$;
import amf.core.services.RuntimeValidator$;
import amf.core.services.ValidationOptions;
import amf.core.unsafe.PlatformSecrets;
import amf.core.validation.AMFValidationReport;
import amf.core.validation.AMFValidationResult;
import amf.core.validation.EffectiveValidations;
import amf.core.validation.SeverityLevels$;
import amf.core.validation.ValidationResultProcessor;
import amf.core.validation.core.ValidationProfile;
import amf.core.validation.core.ValidationResult;
import amf.internal.environment.Environment;
import amf.plugins.document.vocabularies.DialectHeader$;
import amf.plugins.document.vocabularies.DialectsRegistry;
import amf.plugins.document.vocabularies.JsonHeaderExtractor;
import amf.plugins.document.vocabularies.RamlHeaderExtractor;
import amf.plugins.document.vocabularies.annotations.AliasesLocation$;
import amf.plugins.document.vocabularies.annotations.CustomId$;
import amf.plugins.document.vocabularies.annotations.JsonPointerRef$;
import amf.plugins.document.vocabularies.annotations.RefInclude$;
import amf.plugins.document.vocabularies.emitters.dialects.DialectEmitter;
import amf.plugins.document.vocabularies.emitters.dialects.RamlDialectLibraryEmitter;
import amf.plugins.document.vocabularies.emitters.instances.DialectInstancesEmitter;
import amf.plugins.document.vocabularies.emitters.vocabularies.VocabularyEmitter;
import amf.plugins.document.vocabularies.metamodel.document.DialectFragmentModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectInstanceFragmentModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectInstanceLibraryModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectInstanceModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectInstancePatchModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectLibraryModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectModel$;
import amf.plugins.document.vocabularies.metamodel.document.VocabularyModel$;
import amf.plugins.document.vocabularies.metamodel.domain.ClassTermModel$;
import amf.plugins.document.vocabularies.metamodel.domain.DatatypePropertyTermModel$;
import amf.plugins.document.vocabularies.metamodel.domain.DocumentMappingModel$;
import amf.plugins.document.vocabularies.metamodel.domain.DocumentsModelModel$;
import amf.plugins.document.vocabularies.metamodel.domain.ExternalModel$;
import amf.plugins.document.vocabularies.metamodel.domain.NodeMappingModel$;
import amf.plugins.document.vocabularies.metamodel.domain.ObjectPropertyTermModel$;
import amf.plugins.document.vocabularies.metamodel.domain.PropertyMappingModel$;
import amf.plugins.document.vocabularies.metamodel.domain.PublicNodeMappingModel$;
import amf.plugins.document.vocabularies.metamodel.domain.UnionNodeMappingModel$;
import amf.plugins.document.vocabularies.metamodel.domain.VocabularyReferenceModel$;
import amf.plugins.document.vocabularies.model.document.Dialect;
import amf.plugins.document.vocabularies.model.document.DialectInstance;
import amf.plugins.document.vocabularies.model.document.DialectInstancePatch;
import amf.plugins.document.vocabularies.model.document.DialectLibrary;
import amf.plugins.document.vocabularies.model.document.Vocabulary;
import amf.plugins.document.vocabularies.parser.ExtensionHeader$;
import amf.plugins.document.vocabularies.parser.common.SyntaxExtensionsReferenceHandler;
import amf.plugins.document.vocabularies.parser.dialects.DialectContext;
import amf.plugins.document.vocabularies.parser.dialects.DialectContext$;
import amf.plugins.document.vocabularies.parser.dialects.DialectsParser;
import amf.plugins.document.vocabularies.parser.instances.DialectInstanceContext;
import amf.plugins.document.vocabularies.parser.instances.DialectInstanceContext$;
import amf.plugins.document.vocabularies.parser.instances.DialectInstanceParser;
import amf.plugins.document.vocabularies.parser.vocabularies.VocabulariesParser;
import amf.plugins.document.vocabularies.parser.vocabularies.VocabularyContext;
import amf.plugins.document.vocabularies.parser.vocabularies.VocabularyContext$;
import amf.plugins.document.vocabularies.resolution.pipelines.DialectInstancePatchResolutionPipeline;
import amf.plugins.document.vocabularies.resolution.pipelines.DialectInstanceResolutionPipeline;
import amf.plugins.document.vocabularies.resolution.pipelines.DialectResolutionPipeline;
import amf.plugins.document.vocabularies.validation.AMFDialectValidations;
import java.io.Serializable;
import org.yaml.model.YComment;
import org.yaml.model.YDocument;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;

public final class AMLPlugin$
extends AMFDocumentPlugin
implements RamlHeaderExtractor,
JsonHeaderExtractor,
AMFValidationPlugin,
ValidationResultProcessor,
PlatformSecrets {
    public static AMLPlugin$ MODULE$;
    private final DialectsRegistry registry;
    private final String ID;
    private final Seq<String> vendors;
    private final boolean allowRecursiveReferences;
    private final Platform platform;

    static {
        new AMLPlugin$();
    }

    public AMFValidationResult processAggregatedResult(AMFValidationResult result, MessageStyle messageStyle, EffectiveValidations validations) {
        return ValidationResultProcessor.processAggregatedResult$((ValidationResultProcessor)this, (AMFValidationResult)result, (MessageStyle)messageStyle, (EffectiveValidations)validations);
    }

    public Option<AMFValidationResult> buildValidationResult(BaseUnit model, ValidationResult result, MessageStyle messageStyle, EffectiveValidations validations) {
        return ValidationResultProcessor.buildValidationResult$((ValidationResultProcessor)this, (BaseUnit)model, (ValidationResult)result, (MessageStyle)messageStyle, (EffectiveValidations)validations);
    }

    public String findLevel(String id, EffectiveValidations validations) {
        return ValidationResultProcessor.findLevel$((ValidationResultProcessor)this, (String)id, (EffectiveValidations)validations);
    }

    public boolean validationRequest$default$6() {
        return AMFValidationPlugin.validationRequest$default$6$((AMFValidationPlugin)this);
    }

    @Override
    public Option<String> dialect(Root root) {
        return JsonHeaderExtractor.dialect$(this, root);
    }

    @Override
    public Option<YComment> comment(Root root) {
        return RamlHeaderExtractor.comment$((RamlHeaderExtractor)this, root);
    }

    @Override
    public Option<YComment> comment(YDocument document) {
        return RamlHeaderExtractor.comment$((RamlHeaderExtractor)this, document);
    }

    public Platform platform() {
        return this.platform;
    }

    public void amf$core$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    public DialectsRegistry registry() {
        return this.registry;
    }

    public String ID() {
        return this.ID;
    }

    public Seq<String> vendors() {
        return this.vendors;
    }

    public Future<AMFPlugin> init() {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Seq<Obj> modelEntities() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Obj[]{VocabularyModel$.MODULE$, ExternalModel$.MODULE$, VocabularyReferenceModel$.MODULE$, ClassTermModel$.MODULE$, ObjectPropertyTermModel$.MODULE$, DatatypePropertyTermModel$.MODULE$, DialectModel$.MODULE$, NodeMappingModel$.MODULE$, UnionNodeMappingModel$.MODULE$, PropertyMappingModel$.MODULE$, DocumentsModelModel$.MODULE$, PublicNodeMappingModel$.MODULE$, DocumentMappingModel$.MODULE$, DialectLibraryModel$.MODULE$, DialectFragmentModel$.MODULE$, DialectInstanceModel$.MODULE$, DialectInstanceLibraryModel$.MODULE$, DialectInstanceFragmentModel$.MODULE$, DialectInstancePatchModel$.MODULE$}));
    }

    public Map<String, AnnotationGraphLoader> serializableAnnotations() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aliases-location"), (Object)AliasesLocation$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom-id"), (Object)CustomId$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ref-include"), (Object)RefInclude$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"json-pointer-ref"), (Object)JsonPointerRef$.MODULE$)}));
    }

    public BaseUnit resolve(BaseUnit unit, ErrorHandler errorHandler, String pipelineId) {
        BaseUnit baseUnit;
        BaseUnit baseUnit2 = unit;
        if (baseUnit2 instanceof DialectInstancePatch) {
            DialectInstancePatch dialectInstancePatch = (DialectInstancePatch)baseUnit2;
            baseUnit = new DialectInstancePatchResolutionPipeline(errorHandler).resolve(dialectInstancePatch);
        } else if (baseUnit2 instanceof Dialect) {
            Dialect dialect2 = (Dialect)baseUnit2;
            baseUnit = new DialectResolutionPipeline(errorHandler).resolve(dialect2);
        } else if (baseUnit2 instanceof DialectInstance) {
            DialectInstance dialectInstance = (DialectInstance)baseUnit2;
            baseUnit = new DialectInstanceResolutionPipeline(errorHandler).resolve(dialectInstance);
        } else {
            baseUnit = unit;
        }
        return baseUnit;
    }

    public String resolve$default$3() {
        return ResolutionPipeline$.MODULE$.DEFAULT_PIPELINE();
    }

    public Seq<String> documentSyntaxes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"application/aml+json", "application/aml+yaml", "application/raml", "application/raml+json", "application/raml+yaml", "text/yaml", "text/x-yaml", "application/yaml", "application/x-yaml", "application/json"}));
    }

    public Option<BaseUnit> parse(Root document, ParserContext parentContext, Platform platform, ParsingOptions options) {
        None$ none$;
        Some maybeMetaText;
        Some some;
        Option<YComment> option = this.comment(document);
        if (option instanceof Some) {
            Some some2 = (Some)option;
            YComment comment = (YComment)some2.value();
            some = new Some((Object)comment.metaText());
        } else {
            None$ none$2;
            Option<String> option2 = this.dialect(document);
            if (option2 instanceof Some) {
                Some some3 = (Some)option2;
                String metaText = (String)some3.value();
                none$2 = new Some((Object)new StringBuilder(1).append("%").append(metaText).toString());
            } else if (None$.MODULE$.equals(option2)) {
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError(option2);
            }
            some = none$2;
        }
        Some some4 = maybeMetaText = some;
        if (None$.MODULE$.equals(some4)) {
            none$ = None$.MODULE$;
        } else if (some4 instanceof Some) {
            Object object;
            String metaText;
            Some some5 = some4;
            String string = metaText = (String)some5.value();
            String string2 = ExtensionHeader$.MODULE$.VocabularyHeader();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                object = new Some<BaseUnit>((Object)new VocabulariesParser(document, new VocabularyContext(parentContext, VocabularyContext$.MODULE$.$lessinit$greater$default$2())).parseDocument());
            } else {
                String string4 = ExtensionHeader$.MODULE$.DialectLibraryHeader();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    object = new Some((Object)new DialectsParser(document, new DialectContext(parentContext, DialectContext$.MODULE$.$lessinit$greater$default$2())).parseLibrary());
                } else {
                    String string6 = ExtensionHeader$.MODULE$.DialectFragmentHeader();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        object = new Some((Object)new DialectsParser(document, new DialectContext(parentContext, DialectContext$.MODULE$.$lessinit$greater$default$2())).parseFragment());
                    } else {
                        String string8 = ExtensionHeader$.MODULE$.DialectHeader();
                        String string9 = string;
                        object = !(string8 != null ? !string8.equals(string9) : string9 != null) ? this.parseAndRegisterDialect(document, parentContext) : this.parseDialectInstance(string, document, parentContext);
                    }
                }
            }
            none$ = object;
        } else {
            throw new MatchError((Object)some4);
        }
        return none$;
    }

    public Option<YDocument> unparseAsYDocument(BaseUnit unit, RenderOptions renderOptions) {
        Some some;
        BaseUnit baseUnit = unit;
        if (baseUnit instanceof Vocabulary) {
            Vocabulary vocabulary = (Vocabulary)baseUnit;
            some = new Some((Object)new VocabularyEmitter(vocabulary).emitVocabulary());
        } else if (baseUnit instanceof Dialect) {
            Dialect dialect2 = (Dialect)baseUnit;
            some = new Some((Object)new DialectEmitter(dialect2).emitDialect());
        } else if (baseUnit instanceof DialectLibrary) {
            DialectLibrary dialectLibrary = (DialectLibrary)baseUnit;
            some = new Some((Object)new RamlDialectLibraryEmitter(dialectLibrary).emitDialectLibrary());
        } else if (baseUnit instanceof DialectInstance) {
            DialectInstance dialectInstance = (DialectInstance)baseUnit;
            some = new Some((Object)new DialectInstancesEmitter(dialectInstance, (Dialect)this.registry().dialectFor(dialectInstance).get()).emitInstance());
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    public boolean canParse(Root document) {
        return document.parsed() instanceof SyamlParsedDocument && DialectHeader$.MODULE$.apply(document);
    }

    public boolean canUnparse(BaseUnit unit) {
        boolean bl;
        BaseUnit baseUnit = unit;
        if (baseUnit instanceof Vocabulary) {
            bl = true;
        } else if (baseUnit instanceof Dialect) {
            bl = true;
        } else if (baseUnit instanceof DialectLibrary) {
            bl = true;
        } else if (baseUnit instanceof DialectInstance) {
            DialectInstance dialectInstance = (DialectInstance)baseUnit;
            bl = this.registry().knowsDialectInstance(dialectInstance);
        } else {
            bl = false;
        }
        return bl;
    }

    public ReferenceHandler referenceHandler(ErrorHandler eh) {
        return new SyntaxExtensionsReferenceHandler(this.registry(), eh);
    }

    public Seq<AMFPlugin> dependencies() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Option<AMFDomainEntityResolver> modelEntitiesResolver() {
        return new Some((Object)this.registry());
    }

    private Some<BaseUnit> parseAndRegisterDialect(Root document, ParserContext parentContext) {
        Some some;
        BaseUnit baseUnit = new DialectsParser(document, new DialectContext(parentContext, DialectContext$.MODULE$.$lessinit$greater$default$2())).parseDocument();
        if (baseUnit instanceof Dialect) {
            Dialect dialect2 = (Dialect)baseUnit;
            this.registry().register(dialect2);
            some = new Some((Object)dialect2);
        } else {
            some = new Some((Object)baseUnit);
        }
        return some;
    }

    public Option<BaseUnit> parseDialectInstance(String header, Root document, ParserContext parentContext) {
        String headerKey = ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header.split("\\|"))).head()).replace(" ", "");
        return this.registry().withRegisteredDialect(header, (Function1<Dialect, Option<BaseUnit>>)(Function1 & Serializable & scala.Serializable)dialect2 -> {
            Object object;
            String string = headerKey;
            String string2 = dialect2.header();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = new DialectInstanceParser(document, new DialectInstanceContext((Dialect)dialect2, parentContext, DialectInstanceContext$.MODULE$.$lessinit$greater$default$3())).parseDocument();
            } else if (dialect2.isFragmentHeader(headerKey)) {
                object = new DialectInstanceParser(document, new DialectInstanceContext((Dialect)dialect2, parentContext, DialectInstanceContext$.MODULE$.$lessinit$greater$default$3())).parseFragment();
            } else if (dialect2.isLibraryHeader(headerKey)) {
                object = new DialectInstanceParser(document, new DialectInstanceContext((Dialect)dialect2, parentContext, DialectInstanceContext$.MODULE$.$lessinit$greater$default$3())).parseLibrary();
            } else if (dialect2.isPatchHeader(headerKey)) {
                object = new DialectInstanceParser(document, new DialectInstanceContext((Dialect)dialect2, parentContext, DialectInstanceContext$.MODULE$.$lessinit$greater$default$3()).forPatch()).parsePatch();
            } else {
                throw new Exception(new StringBuilder(31).append("Unknown type of dialect header ").append(header).toString());
            }
            return object;
        });
    }

    public Map<String, Function0<ValidationProfile>> domainValidationProfiles(Platform platform) {
        return (Map)this.registry().allDialects().foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map acc = (Map)tuple2._1();
                Dialect dialect2 = (Dialect)tuple2._2();
                if (!dialect2.nameAndVersion().contains("Validation Profile")) {
                    return acc.updated((Object)dialect2.nameAndVersion(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.computeValidationProfile(dialect2));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Map acc = (Map)tuple2._1();
            return acc;
        });
    }

    public ValidationProfile computeValidationProfile(Dialect dialect2) {
        ValidationProfile validationProfile;
        String profileName = dialect2.nameAndVersion();
        Option option = this.registry().validations().get((Object)profileName);
        if (option instanceof Some) {
            ValidationProfile profile;
            Some some = (Some)option;
            validationProfile = profile = (ValidationProfile)some.value();
        } else {
            Dialect resolvedDialect = (Dialect)new DialectResolutionPipeline((ErrorHandler)DefaultParserSideErrorHandler$.MODULE$.apply((BaseUnit)dialect2)).resolve(dialect2);
            ValidationProfile profile = new AMFDialectValidations(resolvedDialect).profile();
            this.registry().validations_$eq((Map<String, ValidationProfile>)this.registry().validations().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)profileName), (Object)profile)));
            validationProfile = profile;
        }
        return validationProfile;
    }

    public EffectiveValidations aggregateValidations(EffectiveValidations validations, Seq<ValidationProfile> dependenciesValidations) {
        return (EffectiveValidations)dependenciesValidations.foldLeft((Object)validations, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            EffectiveValidations effective = (EffectiveValidations)tuple2._1();
            ValidationProfile profile = (ValidationProfile)tuple2._2();
            EffectiveValidations effectiveValidations = effective.someEffective(profile);
            return effectiveValidations;
        });
    }

    public Future<AMFValidationReport> validationRequest(BaseUnit baseUnit, ProfileName profile, EffectiveValidations validations, Platform platform, Environment env, boolean resolved) {
        BaseUnit baseUnit2 = baseUnit;
        if (!(baseUnit2 instanceof DialectInstance)) {
            throw new Exception(new StringBuilder(33).append("Cannot resolve base unit of type ").append(baseUnit.getClass()).toString());
        }
        DialectInstance dialectInstance = (DialectInstance)baseUnit2;
        DialectInstance resolvedModel = (DialectInstance)new DialectInstanceResolutionPipeline((ErrorHandler)DefaultParserSideErrorHandler$.MODULE$.apply(baseUnit)).resolve(dialectInstance);
        Future dependenciesValidations = Future$.MODULE$.sequence((TraversableOnce)dialectInstance.graphDependencies().map((Function1 & Serializable & scala.Serializable)instance -> MODULE$.registry().registerDialect(instance.value(), MODULE$.registry().registerDialect$default$2()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)dialects -> (Seq)dialects.map((Function1 & Serializable & scala.Serializable)dialect2 -> MODULE$.computeValidationProfile((Dialect)dialect2), Seq$.MODULE$.canBuildFrom()), ExecutionContext.Implicits$.MODULE$.global());
        Future future = dependenciesValidations.flatMap((Function1 & Serializable & scala.Serializable)validationsFromDeps -> RuntimeValidator$.MODULE$.shaclValidation((BaseUnit)resolvedModel, MODULE$.aggregateValidations(validations, (Seq<ValidationProfile>)validationsFromDeps), new ValidationOptions().withFullValidation()).map((Function1 & Serializable & scala.Serializable)shaclReport -> {
            List results = (List)shaclReport.results().flatMap((Function1 & Serializable & scala.Serializable)r -> Option$.MODULE$.option2Iterable(MODULE$.buildValidationResult(baseUnit, (ValidationResult)r, RamlProfile$.MODULE$.messageStyle(), validations)), List$.MODULE$.canBuildFrom());
            return new AMFValidationReport(!results.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AMLPlugin$.$anonfun$validationRequest$7(x$2))), baseUnit.id(), profile, (Seq)results);
        }, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
        return future;
    }

    public boolean allowRecursiveReferences() {
        return this.allowRecursiveReferences;
    }

    public RdfModel shapesForDialect(Dialect dialect2, String validationFunctionsUrl) {
        ValidationProfile validationProfile = this.computeValidationProfile(dialect2);
        Seq validations = validationProfile.validations();
        return RuntimeValidator$.MODULE$.shaclModel(validations, validationFunctionsUrl, RuntimeValidator$.MODULE$.shaclModel$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$validationRequest$7(AMFValidationResult x$2) {
        String string = x$2.level();
        String string2 = SeverityLevels$.MODULE$.VIOLATION();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private AMLPlugin$() {
        MODULE$ = this;
        RamlHeaderExtractor.$init$(this);
        JsonHeaderExtractor.$init$(this);
        ValidationResultProcessor.$init$((ValidationResultProcessor)this);
        PlatformSecrets.$init$((PlatformSecrets)this);
        this.registry = new DialectsRegistry();
        this.ID = Aml$.MODULE$.name();
        this.vendors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Aml$.MODULE$.name()}));
        this.allowRecursiveReferences = false;
    }
}

