/*
 * Decompiled with CFR 0.152.
 */
package com.amitshekhar;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.content.Context;
import android.util.Log;
import android.util.Pair;
import com.amitshekhar.R;
import com.amitshekhar.server.ClientServer;
import com.amitshekhar.sqlite.DBFactory;
import com.amitshekhar.utils.NetworkUtils;
import java.io.File;
import java.util.HashMap;

public class DebugDB {
    private static final String TAG = DebugDB.class.getSimpleName();
    private static final int DEFAULT_PORT = 8080;
    private static ClientServer clientServer;
    private static String addressLog;

    private DebugDB() {
    }

    public static void initialize(Context context, DBFactory dbFactory) {
        int portNumber;
        try {
            portNumber = Integer.valueOf(context.getString(R.string.PORT_NUMBER));
        }
        catch (NumberFormatException ex) {
            Log.e((String)TAG, (String)"PORT_NUMBER should be integer", (Throwable)ex);
            portNumber = 8080;
            Log.i((String)TAG, (String)"Using Default port : 8080");
        }
        clientServer = new ClientServer(context, portNumber, dbFactory);
        clientServer.start();
        addressLog = NetworkUtils.getAddressLog(context, portNumber);
        Log.d((String)TAG, (String)addressLog);
    }

    public static String getAddressLog() {
        Log.d((String)TAG, (String)addressLog);
        return addressLog;
    }

    public static void shutDown() {
        if (clientServer != null) {
            clientServer.stop();
            clientServer = null;
        }
    }

    public static void setCustomDatabaseFiles(HashMap<String, Pair<File, String>> customDatabaseFiles) {
        if (clientServer != null) {
            clientServer.setCustomDatabaseFiles(customDatabaseFiles);
        }
    }

    public static void setInMemoryRoomDatabases(HashMap<String, SupportSQLiteDatabase> databases) {
        if (clientServer != null) {
            clientServer.setInMemoryRoomDatabases(databases);
        }
    }

    public static boolean isServerRunning() {
        return clientServer != null && clientServer.isRunning();
    }

    static {
        addressLog = "not available";
    }
}

