/*
 * Decompiled with CFR 0.152.
 */
package com.amitshekhar.utils;

import java.io.UnsupportedEncodingException;

public class ConverterUtils {
    private static final int MAX_BLOB_LENGTH = 512;
    private static final String UNKNOWN_BLOB_LABEL = "{blob}";

    private ConverterUtils() {
    }

    public static String blobToString(byte[] blob) {
        if (blob.length <= 512 && ConverterUtils.fastIsAscii(blob)) {
            try {
                return new String(blob, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return UNKNOWN_BLOB_LABEL;
    }

    public static boolean fastIsAscii(byte[] blob) {
        for (byte b : blob) {
            if ((b & 0xFFFFFF80) == 0) continue;
            return false;
        }
        return true;
    }
}

