/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ZeroBytesInputStream
extends InputStream {
    private long streamSize;
    private long position;

    public ZeroBytesInputStream(long size) throws IOException {
        this.streamSize = size;
        this.position = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.position < this.streamSize) {
            ++this.position;
            return 0;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        if (this.position >= this.streamSize) {
            return -1;
        }
        int count = (int)Math.min((long)length, this.streamSize - this.position);
        Arrays.fill(bytes, offset, offset + count, (byte)0);
        this.position += (long)count;
        return count;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.streamSize - this.position, Integer.MAX_VALUE);
    }
}

