/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.github.ambry.utils.ByteBufferInputStream;
import com.github.ambry.utils.Crc32;
import com.github.ambry.utils.CrcInputStream;
import com.github.ambry.utils.NettyByteBufDataInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final long Infinite_Time = -1L;
    public static final int MIN_PORT_NUM = 1;
    public static final int MAX_PORT_NUM = 65535;
    public static final String ACCOUNT_CONTAINER_SEPARATOR = "___";
    private static final String CLIENT_RESET_EXCEPTION_MSG = "Connection reset by peer";
    private static final String CLIENT_BROKEN_PIPE_EXCEPTION_MSG = "Broken pipe";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String readShortString(DataInputStream input) throws IOException {
        int read;
        int readBytes;
        Short size = input.readShort();
        if (size < 0) {
            throw new IllegalArgumentException("readShortString : the size cannot be negative");
        }
        byte[] bytes = new byte[size.shortValue()];
        for (read = 0; read < size && (readBytes = input.read(bytes, read, size - read)) != -1 && readBytes != 0; read += readBytes) {
        }
        if (read != size) {
            throw new IllegalArgumentException("readShortString : the size of the input does not match the actual data size");
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static int getIntStringLength(String value) {
        return value == null ? 4 : 4 + value.length();
    }

    public static String readIntString(DataInputStream input) throws IOException {
        return Utils.readIntString(input, StandardCharsets.UTF_8);
    }

    public static String readIntString(DataInputStream input, Charset charset) throws IOException {
        int read;
        int readBytes;
        int size = input.readInt();
        if (size < 0) {
            throw new IllegalArgumentException("readIntString : the size cannot be negative");
        }
        byte[] bytes = new byte[size];
        for (read = 0; read < size && (readBytes = input.read(bytes, read, size - read)) != -1 && readBytes != 0; read += readBytes) {
        }
        if (read != size) {
            throw new IllegalArgumentException("readIntString : the size of the input does not match the actual data size");
        }
        return new String(bytes, charset);
    }

    public static ByteBuffer readIntBuffer(DataInputStream input) throws IOException {
        int read;
        int readBytes;
        int size = input.readInt();
        if (size < 0) {
            throw new IllegalArgumentException("readIntBuffer : the size cannot be negative");
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (read = 0; read < size && (readBytes = input.read(buffer.array())) != -1 && readBytes != 0; read += readBytes) {
        }
        if (read != size) {
            throw new IllegalArgumentException("readIntBuffer : the size of the input does not match the actual data size");
        }
        return buffer;
    }

    public static ByteBuffer readShortBuffer(DataInputStream input) throws IOException {
        int read;
        int readBytes;
        int size = input.readShort();
        if (size < 0) {
            throw new IllegalArgumentException("readShortBuffer : the size cannot be negative");
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (read = 0; read < size && (readBytes = input.read(buffer.array())) != -1 && readBytes != 0; read += readBytes) {
        }
        if (read != size) {
            throw new IllegalArgumentException("readShortBuffer the size of the input does not match the actual data size");
        }
        return buffer;
    }

    public static ByteBufferInputStream getByteBufferInputStreamFromCrcInputStream(CrcInputStream crcStream, int dataSize) throws IOException {
        ByteBuffer buffer = Utils.readByteBufferFromCrcInputStream(crcStream, dataSize);
        return new ByteBufferInputStream(buffer);
    }

    public static ByteBuffer getByteBufferFromInputStream(InputStream stream, int dataSize) throws IOException {
        int sizeRead;
        ByteBuffer output = ByteBuffer.allocate(dataSize);
        ReadableByteChannel readableByteChannel = Channels.newChannel(stream);
        for (int read = 0; read < dataSize; read += sizeRead) {
            sizeRead = readableByteChannel.read(output);
            if (sizeRead != 0 && sizeRead != -1) continue;
            throw new IOException("Total size read " + read + " is less than the size to be read " + dataSize);
        }
        output.flip();
        return output;
    }

    public static ByteBuffer readByteBufferFromCrcInputStream(CrcInputStream crcStream, int dataSize) throws IOException {
        ByteBuffer output;
        InputStream inputStream = crcStream.getUnderlyingInputStream();
        if (inputStream instanceof NettyByteBufDataInputStream) {
            ByteBuf nettyByteBuf = ((NettyByteBufDataInputStream)inputStream).getBuffer();
            int startIndex = nettyByteBuf.readerIndex();
            output = nettyByteBuf.nioBuffer(startIndex, dataSize);
            crcStream.updateCrc(output.duplicate());
            nettyByteBuf.readerIndex(startIndex + dataSize);
        } else {
            output = Utils.getByteBufferFromInputStream(crcStream, dataSize);
        }
        return output;
    }

    public static ByteBuf readNettyByteBufFromCrcInputStream(CrcInputStream crcStream, int dataSize) throws IOException {
        ByteBuf output;
        InputStream inputStream = crcStream.getUnderlyingInputStream();
        if (inputStream instanceof NettyByteBufDataInputStream) {
            ByteBuf nettyByteBuf = ((NettyByteBufDataInputStream)inputStream).getBuffer();
            int startIndex = nettyByteBuf.readerIndex();
            output = nettyByteBuf.retainedSlice(startIndex, dataSize);
            crcStream.updateCrc(output.nioBuffer());
            nettyByteBuf.readerIndex(startIndex + dataSize);
        } else {
            ByteBuffer buffer = Utils.getByteBufferFromInputStream(crcStream, dataSize);
            output = Unpooled.wrappedBuffer((ByteBuffer)buffer);
        }
        return output;
    }

    public static Exception extractExecutionExceptionCause(Exception e) {
        Throwable cause = e.getCause();
        if (!(e instanceof ExecutionException) || cause == null) {
            return e;
        }
        return cause instanceof Exception ? (Exception)cause : new Exception(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> ByteBuf applyByteBufferFunctionToByteBuf(ByteBuf buf, ByteBufferFunction<T> fn) throws T {
        if (buf.nioBufferCount() == 1) {
            ByteBuffer buffer = buf.nioBuffer();
            buf.skipBytes(buffer.remaining());
            return Unpooled.wrappedBuffer((ByteBuffer)fn.apply(buffer));
        }
        ByteBuf temp = ByteBufAllocator.DEFAULT.heapBuffer(buf.readableBytes());
        try {
            temp.writeBytes(buf);
            ByteBuffer buffer = temp.nioBuffer();
            ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)fn.apply(buffer));
            return byteBuf;
        }
        finally {
            temp.release();
        }
    }

    public static Thread newThread(Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler((t, e) -> logger.error("Encountered throwable in {}", (Object)t, (Object)e));
        return thread;
    }

    public static Thread newThread(String name, Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler((t, e) -> logger.error("Encountered throwable in {}", (Object)t, (Object)e));
        return thread;
    }

    public static Thread daemonThread(Runnable runnable) {
        return Utils.newThread(runnable, true);
    }

    public static Thread daemonThread(String name, Runnable runnable) {
        return Utils.newThread(name, runnable, true);
    }

    public static ScheduledExecutorService newScheduler(int numThreads, String threadNamePrefix, boolean isDaemon) {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(numThreads, new SchedulerThreadFactory(threadNamePrefix, isDaemon));
        scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return scheduler;
    }

    public static ScheduledExecutorService newScheduler(int numThreads, boolean isDaemon) {
        return Utils.newScheduler(numThreads, "ambry-scheduler-", isDaemon);
    }

    public static FileChannel openChannel(File file, boolean mutable) throws FileNotFoundException {
        if (mutable) {
            return new RandomAccessFile(file, "rw").getChannel();
        }
        return new FileInputStream(file).getChannel();
    }

    public static int readFileToByteBuffer(FileChannel fileChannel, long offset, ByteBuffer buffer) throws IOException {
        int ioCount = 0;
        int read = 0;
        int expectedRead = buffer.remaining();
        while (buffer.hasRemaining()) {
            int sizeRead = fileChannel.read(buffer, offset);
            if (sizeRead == 0 || sizeRead == -1) {
                throw new IOException("Total size read " + read + " is less than the size to be read " + expectedRead + ". sizeRead is " + sizeRead);
            }
            read += sizeRead;
            offset += (long)sizeRead;
            ++ioCount;
        }
        return ioCount;
    }

    public static <T> T getObj(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (T)Class.forName(className).newInstance();
    }

    public static <T> T getObj(String className, Object arg) throws ReflectiveOperationException {
        for (Constructor<?> ctor : Class.forName(className).getDeclaredConstructors()) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != 1 || !Utils.checkAssignable(paramTypes[0], arg)) continue;
            return (T)ctor.newInstance(arg);
        }
        throw Utils.buildNoConstructorException(className, arg);
    }

    public static <T> T getObj(String className, Object arg1, Object arg2) throws ReflectiveOperationException {
        for (Constructor<?> ctor : Class.forName(className).getDeclaredConstructors()) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != 2 || !Utils.checkAssignable(paramTypes[0], arg1) || !Utils.checkAssignable(paramTypes[1], arg2)) continue;
            return (T)ctor.newInstance(arg1, arg2);
        }
        throw Utils.buildNoConstructorException(className, arg1, arg2);
    }

    public static <T> T getObj(String className, Object arg1, Object arg2, Object arg3) throws ReflectiveOperationException {
        for (Constructor<?> ctor : Class.forName(className).getDeclaredConstructors()) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != 3 || !Utils.checkAssignable(paramTypes[0], arg1) || !Utils.checkAssignable(paramTypes[1], arg2) || !Utils.checkAssignable(paramTypes[2], arg3)) continue;
            return (T)ctor.newInstance(arg1, arg2, arg3);
        }
        throw Utils.buildNoConstructorException(className, arg1, arg2, arg3);
    }

    public static <T> T getObj(String className, Object ... args) throws ReflectiveOperationException {
        for (Constructor<?> ctor : Class.forName(className).getDeclaredConstructors()) {
            int i;
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (i = 0; i < args.length && Utils.checkAssignable(paramTypes[i], args[i]); ++i) {
            }
            if (i != args.length) continue;
            return (T)ctor.newInstance(args);
        }
        throw Utils.buildNoConstructorException(className, args);
    }

    public static Stream<String> getStaticFieldValuesAsStrings(Class type) {
        return Arrays.stream(type.getFields()).filter(field -> Modifier.isStatic(field.getModifiers())).map(field -> {
            try {
                return field.get(null).toString();
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not get value of a static field, " + field + ", in " + type, e);
            }
        });
    }

    private static boolean checkAssignable(Class<?> parameterType, Object arg) {
        return arg == null || parameterType.isAssignableFrom(arg.getClass());
    }

    private static NoSuchMethodException buildNoConstructorException(String className, Object ... args) {
        String argTypes = Stream.of(args).map(arg -> arg == null ? "null" : arg.getClass().getName()).collect(Collectors.joining(", "));
        return new NoSuchMethodException("No constructor found for " + className + " that takes arguments of types: " + argTypes);
    }

    public static int hashcode(Object[] items) {
        if (items == null) {
            return 0;
        }
        int h = 1;
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) continue;
            h = 31 * h + items[i].hashCode();
            ++i;
        }
        return h;
    }

    public static long crc32(byte[] bytes) {
        return Utils.crc32(bytes, 0, bytes.length);
    }

    public static long crc32(byte[] bytes, int offset, int size) {
        Crc32 crc = new Crc32();
        crc.update(bytes, offset, size);
        return crc.getValue();
    }

    public static Properties loadProps(String filename) throws IOException {
        FileInputStream propStream = new FileInputStream(filename);
        Properties props = new Properties();
        props.load(propStream);
        return props;
    }

    public static void serializeNullableString(ByteBuffer outputBuffer, String value) {
        if (value == null) {
            outputBuffer.putInt(0);
        } else {
            Utils.serializeString(outputBuffer, value, Charset.defaultCharset());
        }
    }

    public static void serializeString(ByteBuffer outputBuffer, String value, Charset charset) {
        byte[] valueArray = value.getBytes(charset);
        outputBuffer.putInt(valueArray.length);
        outputBuffer.put(valueArray);
    }

    public static String deserializeString(ByteBuffer inputBuffer, Charset charset) {
        int size = inputBuffer.getInt();
        byte[] value = new byte[size];
        inputBuffer.get(value);
        return new String(value, charset);
    }

    public static int getNullableStringLength(String value) {
        return value == null ? 0 : value.length();
    }

    public static void writeStringToFile(String string, String path) throws IOException {
        Files.write(Paths.get(path, new String[0]), string.getBytes(), new OpenOption[0]);
    }

    public static void writeJsonObjectToFile(JSONObject jsonObject, String path) throws IOException, JSONException {
        Utils.writeStringToFile(jsonObject.toString(2), path);
    }

    public static void writeJsonArrayToFile(JSONArray jsonArray, String path) throws IOException, JSONException {
        Utils.writeStringToFile(jsonArray.toString(2), path);
    }

    public static String readStringFromFile(String path) throws IOException {
        return new String(Files.readAllBytes(Paths.get(path, new String[0])));
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static void preAllocateFileIfNeeded(File file, long capacityBytes) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        if (Utils.isLinux()) {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("fallocate --keep-size -l " + capacityBytes + " " + file.getAbsolutePath());
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (process.exitValue() != 0) {
                throw new IOException("error while trying to preallocate file " + file.getAbsolutePath() + " exitvalue " + process.exitValue() + " error string " + new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().collect(Collectors.joining("/n")));
            }
        }
    }

    public static long getRandomLong(Random random, long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("Cannot generate random long in range [0,n) for n<=0.");
        }
        int BITS_PER_LONG = 63;
        while ((bits = random.nextLong() & Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public static short getRandomShort(Random random) {
        return (short)random.nextInt(32768);
    }

    public static long addSecondsToEpochTime(long epochTimeInMs, long deltaTimeInSeconds) {
        if (deltaTimeInSeconds == -1L || epochTimeInMs == -1L) {
            return -1L;
        }
        return epochTimeInMs + TimeUnit.SECONDS.toMillis(deltaTimeInSeconds);
    }

    public static byte[] readBytesFromStream(InputStream stream, int size) throws IOException {
        return Utils.readBytesFromStream(stream, new byte[size], 0, size);
    }

    public static byte[] readBytesFromStream(InputStream stream, byte[] data, int offset, int size) throws IOException {
        int read = 0;
        while (read < size) {
            int sizeRead = stream.read(data, offset, size - read);
            if (sizeRead == 0 || sizeRead == -1) {
                throw new IOException("Total size read " + read + " is less than the size to be read " + size);
            }
            read += sizeRead;
            offset += sizeRead;
        }
        return data;
    }

    public static byte[] readBytesFromByteBuf(ByteBuf buffer, byte[] data, int offset, int size) throws IOException {
        buffer.readBytes(data, offset, size);
        return data;
    }

    public static ArrayList<String> splitString(String data, String delimiter) {
        return Utils.splitString(data, delimiter, ArrayList::new);
    }

    public static <C extends Collection<String>> C splitString(String data, String delimiter, Supplier<C> collectionFactory) {
        if (data == null) {
            throw new IllegalArgumentException("Passed in string is null ");
        }
        return (C)((Collection)Arrays.stream(data.split(delimiter)).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(collectionFactory)));
    }

    public static <T> List<List<T>> partitionList(List<T> inputList, int batchSize) {
        Objects.requireNonNull(inputList, "Input list cannot be null");
        if (batchSize < 1) {
            throw new IllegalArgumentException("Invalid batchSize: " + batchSize);
        }
        ArrayList<List<T>> partitionedLists = new ArrayList<List<T>>();
        for (int start = 0; start < inputList.size(); start += batchSize) {
            int end = Math.min(start + batchSize, inputList.size());
            partitionedLists.add(inputList.subList(start, end));
        }
        return partitionedLists;
    }

    public static ByteBuffer ensureCapacity(ByteBuffer existingBuffer, int newLength) {
        if (newLength > existingBuffer.capacity()) {
            ByteBuffer newBuffer = existingBuffer.isDirect() ? ByteBuffer.allocateDirect(newLength) : ByteBuffer.allocate(newLength);
            existingBuffer.flip();
            newBuffer.put(existingBuffer);
            return newBuffer;
        }
        return existingBuffer;
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable throwable;
        for (throwable = t; throwable != null && throwable.getCause() != null; throwable = throwable.getCause()) {
        }
        return throwable;
    }

    public static long getTimeInMsToTheNearestSec(long timeInMs) {
        long timeInSecs = timeInMs / 1000L;
        return timeInMs != -1L ? timeInSecs * 1000L : -1L;
    }

    public static void shutDownExecutorService(ExecutorService executorService, long shutdownTimeout, TimeUnit timeUnit) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(shutdownTimeout, timeUnit)) {
                logger.warn("ExecutorService is not shut down successfully within {} {}, forcing an immediate shutdown.", (Object)shutdownTimeout, (Object)timeUnit);
                executorService.shutdownNow();
                if (!executorService.awaitTermination(shutdownTimeout, timeUnit)) {
                    logger.error("ExecutorService cannot be shut down successfully.");
                }
            }
        }
        catch (InterruptedException e) {
            logger.error("Exception occurred when shutting down the ExecutorService. Forcing an immediate shutdown.", (Throwable)e);
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error("Exception occurred when shutting down the ExecutorService.", (Throwable)e);
        }
    }

    public static boolean isPossibleClientTermination(Throwable cause) {
        return cause instanceof IOException && (CLIENT_RESET_EXCEPTION_MSG.equals(cause.getMessage()) || CLIENT_BROKEN_PIPE_EXCEPTION_MSG.equals(cause.getMessage()));
    }

    public static IOException convertToClientTerminationException(Throwable cause) {
        return new IOException(CLIENT_RESET_EXCEPTION_MSG, cause);
    }

    public static long getTtlInSecsFromExpiryMs(long expiresAtMs, long creationTimeMs) {
        return expiresAtMs == -1L ? -1L : Math.max(0L, TimeUnit.MILLISECONDS.toSeconds(expiresAtMs - creationTimeMs));
    }

    public static int compareTimes(long time1, long time2) {
        if (time1 == time2) {
            return 0;
        }
        if (time1 == -1L) {
            return 1;
        }
        if (time2 == -1L) {
            return -1;
        }
        return Long.compare(time1, time2);
    }

    public static void deleteFileOrDirectory(File file) throws IOException {
        if (file.exists()) {
            Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void setFilesPermission(List<File> files, Set<PosixFilePermission> permissions) throws IOException {
        for (File file : files) {
            Files.setPosixFilePermissions(file.toPath(), permissions);
        }
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static class SchedulerThreadFactory
    implements ThreadFactory {
        private final AtomicInteger schedulerThreadId = new AtomicInteger(0);
        private final String threadNamePrefix;
        private final boolean isDaemon;

        SchedulerThreadFactory(String threadNamePrefix, boolean isDaemon) {
            this.threadNamePrefix = threadNamePrefix;
            this.isDaemon = isDaemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            return Utils.newThread(this.threadNamePrefix + this.schedulerThreadId.getAndIncrement(), r, this.isDaemon);
        }
    }

    @FunctionalInterface
    public static interface ByteBufferFunction<T extends Throwable> {
        public ByteBuffer apply(ByteBuffer var1) throws T;
    }
}

