/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.github.ambry.utils.ByteBufferPool;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleByteBufferPool
implements ByteBufferPool {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long capacity;
    private final Object lock = new Object();
    private long availableMemory;

    public SimpleByteBufferPool(long capacity) {
        this.capacity = capacity;
        this.availableMemory = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer allocate(int size, long timeToBlockInMs) throws TimeoutException, InterruptedException {
        if ((long)size > this.capacity) {
            throw new IllegalArgumentException("Requested size cannot exceed pool capacity.");
        }
        if (timeToBlockInMs < 0L) {
            throw new IllegalArgumentException("timeToBlockInMs cannot be negative.");
        }
        long startTimeInMs = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while ((long)size > this.availableMemory) {
                long timeout = timeToBlockInMs - (System.currentTimeMillis() - startTimeInMs);
                if (timeout <= 0L) {
                    throw new TimeoutException("Timed out waiting for allocation.");
                }
                this.lock.wait(timeout);
            }
            this.availableMemory -= (long)size;
            if (this.availableMemory > 0L) {
                this.lock.notify();
            }
        }
        return ByteBuffer.allocate(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate(ByteBuffer buffer) {
        Object object = this.lock;
        synchronized (object) {
            this.availableMemory += (long)buffer.capacity();
            if (this.availableMemory > this.capacity) {
                this.availableMemory = this.capacity;
                this.logger.warn("The total deallocated memory is more than that had been allocated from the buffer pool.");
            }
            this.lock.notify();
        }
    }

    public long availableMemory() {
        return this.availableMemory;
    }

    public long capacity() {
        return this.capacity;
    }
}

