/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.codahale.metrics.Meter;

public class RejectThrottler {
    private final double desiredRatePerSec;
    private final Meter meter;

    public RejectThrottler(long desiredRatePerSec, Meter meter) {
        this.desiredRatePerSec = desiredRatePerSec;
        this.meter = meter;
    }

    public RejectThrottler(long desiredRatePerSec) {
        this(desiredRatePerSec, new Meter());
    }

    public boolean shouldThrottle(long observed) {
        if (this.desiredRatePerSec < 0.0) {
            return false;
        }
        if (this.meter.getOneMinuteRate() >= this.desiredRatePerSec) {
            return true;
        }
        this.meter.mark(observed);
        return false;
    }
}

