/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocationOptions {
    public final String hardwareLayoutFilePath;
    public final String partitionLayoutFilePath;
    public final String serverPropsFilePath;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public InvocationOptions(String[] args) throws InstantiationException, IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec hardwareLayoutFilePath = parser.accepts("hardwareLayoutFilePath", "Path to hardware layout file").withRequiredArg().describedAs("hardwareLayoutFilePath").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionLayoutFilePath = parser.accepts("partitionLayoutFilePath", "Path to partition layout file").withRequiredArg().describedAs("partitionLayoutFilePath").ofType(String.class);
        ArgumentAcceptingOptionSpec serverPropsFilePath = parser.accepts("serverPropsFilePath", "Path to server properties file").withRequiredArg().describedAs("serverPropsFilePath").ofType(String.class);
        ArrayList requiredArgs = new ArrayList();
        requiredArgs.add((OptionSpec<?>)hardwareLayoutFilePath);
        requiredArgs.add((OptionSpec<?>)partitionLayoutFilePath);
        requiredArgs.add((OptionSpec<?>)serverPropsFilePath);
        OptionSet options = parser.parse(args);
        if (!this.hasRequiredOptions(requiredArgs, options)) {
            parser.printHelpOn((OutputStream)System.err);
            throw new InstantiationException("Did not receive all required arguments for starting RestServer");
        }
        this.hardwareLayoutFilePath = (String)options.valueOf((OptionSpec)hardwareLayoutFilePath);
        this.logger.trace("Hardware layout file path: {}", (Object)this.hardwareLayoutFilePath);
        this.partitionLayoutFilePath = (String)options.valueOf((OptionSpec)partitionLayoutFilePath);
        this.logger.trace("Partition layout file path: {}", (Object)this.partitionLayoutFilePath);
        this.serverPropsFilePath = (String)options.valueOf((OptionSpec)serverPropsFilePath);
        this.logger.trace("Server properties file path: {}", (Object)this.serverPropsFilePath);
    }

    private boolean hasRequiredOptions(ArrayList<OptionSpec<?>> requiredArgs, OptionSet options) {
        boolean haveAll = true;
        for (OptionSpec<?> opt : requiredArgs) {
            if (options.has(opt)) continue;
            System.err.println("Missing required argument " + opt);
            haveAll = false;
        }
        return haveAll;
    }
}

