/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;

public class FileLock {
    private final File file;
    private final FileChannel channel;
    private java.nio.channels.FileLock flock = null;

    public FileLock(File file) throws FileNotFoundException, IOException {
        this.file = file;
        file.createNewFile();
        this.channel = new RandomAccessFile(file, "rw").getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws IOException {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.flock = this.channel.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() throws IOException {
        FileLock fileLock = this;
        synchronized (fileLock) {
            try {
                this.flock = this.channel.tryLock();
                return this.flock != null;
            }
            catch (OverlappingFileLockException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws IOException {
        FileLock fileLock = this;
        synchronized (fileLock) {
            if (this.flock != null) {
                this.flock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.unlock();
            this.channel.close();
        }
    }
}

