/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.github.ambry.utils.Crc32;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrcInputStream
extends InputStream {
    private Crc32 crc;
    private InputStream stream;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CrcInputStream(InputStream in) {
        this(new Crc32(), in);
    }

    public CrcInputStream(Crc32 crc, InputStream in) {
        this.crc = crc;
        this.stream = in;
    }

    @Override
    public int read() throws IOException {
        int val = this.stream.read();
        this.crc.update((byte)(val & 0xFF));
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.stream.read(b, off, len);
        this.crc.update(b, off, ret);
        return ret;
    }

    public void updateCrc(ByteBuffer buffer) throws IOException {
        this.crc.update(buffer);
    }

    @Override
    public int available() throws IOException {
        int available = this.stream.available();
        this.logger.trace("remaining bytes {}", (Object)available);
        return available;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public long getValue() {
        return this.crc.getValue();
    }

    public InputStream getUnderlyingInputStream() {
        return this.stream;
    }
}

