/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Clock;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import java.util.concurrent.TimeUnit;

public class CachedHistogram
extends Histogram {
    private final CachedGauge<Double> cache;

    public CachedHistogram(Reservoir reservoir, long timeoutMs, double quantile) {
        this(Clock.defaultClock(), reservoir, timeoutMs, quantile);
    }

    CachedHistogram(Clock clock, Reservoir reservoir, long timeoutMs, final double quantile) {
        super(reservoir);
        this.cache = new CachedGauge<Double>(clock, timeoutMs, TimeUnit.MILLISECONDS){

            protected Double loadValue() {
                return CachedHistogram.this.getSnapshot().getValue(quantile);
            }
        };
    }

    public double getCachedValue() {
        return (Double)this.cache.getValue();
    }
}

