/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.MessageFormatException;
import com.github.ambry.messageformat.MessageFormatInputStream;
import com.github.ambry.messageformat.MessageFormatRecord;
import com.github.ambry.messageformat.SubRecord;
import com.github.ambry.messageformat.TtlUpdateSubRecord;
import com.github.ambry.messageformat.UpdateRecord;
import com.github.ambry.store.StoreKey;
import java.nio.ByteBuffer;

public class TtlUpdateMessageFormatInputStream
extends MessageFormatInputStream {
    public TtlUpdateMessageFormatInputStream(StoreKey key, short accountId, short containerId, long expiresAtMs, long updateTimeInMs) throws MessageFormatException {
        this(key, accountId, containerId, expiresAtMs, updateTimeInMs, 0);
    }

    public TtlUpdateMessageFormatInputStream(StoreKey key, short accountId, short containerId, long expiresAtMs, long updateTimeInMs, short lifeVersion) throws MessageFormatException {
        int headerSize = MessageFormatRecord.getHeaderSizeForVersion(MessageFormatRecord.headerVersionToUse);
        int recordSize = MessageFormatRecord.Update_Format_V3.getRecordSize(SubRecord.Type.TTL_UPDATE);
        this.buffer = ByteBuffer.allocate(headerSize + key.sizeInBytes() + recordSize);
        if (MessageFormatRecord.headerVersionToUse == 3) {
            MessageFormatRecord.MessageHeader_Format_V3.serializeHeader(this.buffer, lifeVersion, recordSize, -1, -1, headerSize + key.sizeInBytes(), -1, -1);
        } else {
            MessageFormatRecord.MessageHeader_Format_V2.serializeHeader(this.buffer, recordSize, -1, -1, headerSize + key.sizeInBytes(), -1, -1);
        }
        this.buffer.put(key.toBytes());
        MessageFormatRecord.Update_Format_V3.serialize(this.buffer, new UpdateRecord(accountId, containerId, updateTimeInMs, new TtlUpdateSubRecord(expiresAtMs)));
        this.messageLength = this.buffer.capacity();
        this.buffer.flip();
    }
}

