/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.store.Read;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class ReadInputStream
extends InputStream {
    private final Read readable;
    private long currentPosition;
    private long endPosition;

    ReadInputStream(Read readable, long startPosition, long endPosition) {
        this.readable = readable;
        this.currentPosition = startPosition;
        this.endPosition = endPosition;
    }

    @Override
    public int read() throws IOException {
        if (this.currentPosition + 1L > this.endPosition) {
            throw new IndexOutOfBoundsException("Trying to read outside the available read window");
        }
        ByteBuffer buf = ByteBuffer.allocate(1);
        this.readable.readInto(buf, this.currentPosition);
        ++this.currentPosition;
        buf.flip();
        return buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.currentPosition + (long)(len - off) > this.endPosition) {
            throw new IndexOutOfBoundsException("Trying to read outside the available read window");
        }
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.position(off);
        buf.limit(len);
        this.readable.readInto(buf, this.currentPosition);
        this.currentPosition += (long)(buf.position() - off);
        return buf.position() - off;
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }
}

