/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.CompositeBlobInfo;
import com.github.ambry.messageformat.MessageFormatErrorCodes;
import com.github.ambry.messageformat.MessageFormatException;
import com.github.ambry.messageformat.MessageFormatRecord;
import com.github.ambry.store.StoreKey;
import com.github.ambry.store.StoreKeyFactory;
import com.github.ambry.utils.ByteBufferInputStream;
import com.github.ambry.utils.Pair;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public class MetadataContentSerDe {
    public static ByteBuffer serializeMetadataContentV2(int chunkSize, long totalSize, List<StoreKey> keys) {
        int bufSize = MessageFormatRecord.Metadata_Content_Format_V2.getMetadataContentSize(keys.get(0).sizeInBytes(), keys.size());
        ByteBuffer outputBuf = ByteBuffer.allocate(bufSize);
        MessageFormatRecord.Metadata_Content_Format_V2.serializeMetadataContentRecord(outputBuf, chunkSize, totalSize, keys);
        return outputBuf;
    }

    public static ByteBuffer serializeMetadataContentV3(long totalSize, List<Pair<StoreKey, Long>> keysAndContentSizes) {
        int bufSize = MessageFormatRecord.Metadata_Content_Format_V3.getMetadataContentSize(((StoreKey)keysAndContentSizes.get(0).getFirst()).sizeInBytes(), keysAndContentSizes.size());
        ByteBuffer outputBuf = ByteBuffer.allocate(bufSize);
        MessageFormatRecord.Metadata_Content_Format_V3.serializeMetadataContentRecord(outputBuf, totalSize, keysAndContentSizes);
        return outputBuf;
    }

    public static CompositeBlobInfo deserializeMetadataContentRecord(ByteBuffer buf, StoreKeyFactory storeKeyFactory) throws IOException, MessageFormatException {
        short version = buf.getShort();
        switch (version) {
            case 2: {
                return MessageFormatRecord.Metadata_Content_Format_V2.deserializeMetadataContentRecord(new DataInputStream((InputStream)new ByteBufferInputStream(buf)), storeKeyFactory);
            }
            case 3: {
                return MessageFormatRecord.Metadata_Content_Format_V3.deserializeMetadataContentRecord(new DataInputStream((InputStream)new ByteBufferInputStream(buf)), storeKeyFactory);
            }
        }
        throw new MessageFormatException("Unknown version encountered for MetadataContent: " + version, MessageFormatErrorCodes.Unknown_Format_Version);
    }
}

