/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.store.MessageInfo;
import com.github.ambry.store.MessageWriteSet;
import com.github.ambry.store.StoreException;
import com.github.ambry.store.Write;
import com.github.ambry.utils.ByteBufferInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;

public class MessageFormatWriteSet
implements MessageWriteSet {
    private final InputStream streamToWrite;
    private List<MessageInfo> streamInfo;

    public MessageFormatWriteSet(InputStream streamToWrite, List<MessageInfo> streamInfo, boolean materializeStream) throws IOException {
        long sizeToWrite = 0L;
        for (MessageInfo info : streamInfo) {
            sizeToWrite += info.getSize();
        }
        this.streamInfo = streamInfo;
        this.streamToWrite = materializeStream ? new ByteBufferInputStream(streamToWrite, (int)sizeToWrite) : streamToWrite;
    }

    public long writeTo(Write writeChannel) throws StoreException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(this.streamToWrite);
        long sizeWritten = 0L;
        for (MessageInfo info : this.streamInfo) {
            writeChannel.appendFrom(readableByteChannel, info.getSize());
            sizeWritten += info.getSize();
        }
        return sizeWritten;
    }

    public List<MessageInfo> getMessageSetInfo() {
        return this.streamInfo;
    }
}

