/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.utils.CrcInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageFormatInputStream
extends InputStream {
    protected ByteBuffer buffer = null;
    protected CrcInputStream stream = null;
    protected long streamLength = 0L;
    protected long streamRead = 0L;
    ByteBuffer crc = ByteBuffer.allocate(8);
    protected long messageLength;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public int read() throws IOException {
        if (this.buffer != null && this.buffer.remaining() > 0) {
            return this.buffer.get() & 0xFF;
        }
        if (this.stream != null && this.streamRead < this.streamLength) {
            ++this.streamRead;
            return this.stream.read();
        }
        if (this.stream != null) {
            if (this.crc.position() == 0) {
                this.crc.putLong(this.stream.getValue());
                this.crc.flip();
            }
            if (this.crc.remaining() > 0) {
                return this.crc.get() & 0xFF;
            }
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesToRead;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int totalRead = 0;
        if (this.buffer != null && this.buffer.remaining() > 0) {
            bytesToRead = Math.min(this.buffer.remaining(), len);
            this.buffer.get(b, off, bytesToRead);
            totalRead += bytesToRead;
        }
        if (this.stream != null) {
            if (this.streamRead < this.streamLength && len - totalRead > 0) {
                long bytesToRead2 = Math.min(this.streamLength - this.streamRead, (long)(len - totalRead));
                int readFromStream = this.stream.read(b, off + totalRead, (int)bytesToRead2);
                this.streamRead += (long)readFromStream;
                totalRead += readFromStream;
            }
            if (this.streamRead == this.streamLength) {
                if (this.crc.position() == 0) {
                    this.crc.putLong(this.stream.getValue());
                    this.crc.flip();
                }
                bytesToRead = Math.min(this.crc.remaining(), len - totalRead);
                this.crc.get(b, off + totalRead, bytesToRead);
                totalRead += bytesToRead;
            }
        }
        return totalRead > 0 ? totalRead : -1;
    }

    @Override
    public int available() {
        return (this.buffer == null ? 0 : this.buffer.remaining()) + (int)(this.streamLength - this.streamRead) + this.crc.remaining();
    }

    public long getSize() {
        return this.messageLength;
    }
}

