/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.BlobType;
import com.github.ambry.messageformat.MessageFormatErrorCodes;
import com.github.ambry.messageformat.MessageFormatException;
import com.github.ambry.messageformat.MessageFormatInputStream;
import com.github.ambry.messageformat.MessageFormatRecord;
import com.github.ambry.utils.Crc32;
import com.github.ambry.utils.CrcInputStream;
import com.github.ambry.utils.ZeroBytesInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class HardDeleteMessageFormatInputStream
extends MessageFormatInputStream {
    private int hardDeleteStreamRelativeOffset;

    public HardDeleteMessageFormatInputStream(int userMetadataRelativeOffset, short userMetadataVersion, int userMetadataSize, short blobRecordVersion, BlobType blobType, long blobStreamSize) throws MessageFormatException, IOException {
        ByteBuffer serializedBlobPartialRecord;
        long blobRecordSize;
        ByteBuffer serializedUserMetadata;
        int userMetadataRecordSize;
        ByteBuffer userMetadata = ByteBuffer.allocate(userMetadataSize);
        ZeroBytesInputStream blobStream = new ZeroBytesInputStream(blobStreamSize);
        this.hardDeleteStreamRelativeOffset = userMetadataRelativeOffset;
        switch (userMetadataVersion) {
            case 1: {
                userMetadataRecordSize = MessageFormatRecord.UserMetadata_Format_V1.getUserMetadataSize(userMetadata);
                serializedUserMetadata = ByteBuffer.allocate(userMetadataRecordSize);
                MessageFormatRecord.UserMetadata_Format_V1.serializeUserMetadataRecord(serializedUserMetadata, userMetadata);
                serializedUserMetadata.flip();
                break;
            }
            default: {
                throw new MessageFormatException("Unknown version encountered when creating hard delete stream", MessageFormatErrorCodes.Unknown_Format_Version);
            }
        }
        switch (blobRecordVersion) {
            case 1: {
                blobRecordSize = MessageFormatRecord.Blob_Format_V1.getBlobRecordSize(blobStreamSize);
                serializedBlobPartialRecord = ByteBuffer.allocate((int)(blobRecordSize - blobStreamSize - 8L));
                MessageFormatRecord.Blob_Format_V1.serializePartialBlobRecord(serializedBlobPartialRecord, blobStreamSize);
                serializedBlobPartialRecord.flip();
                break;
            }
            case 2: {
                blobRecordSize = MessageFormatRecord.Blob_Format_V2.getBlobRecordSize(blobStreamSize);
                serializedBlobPartialRecord = ByteBuffer.allocate((int)(blobRecordSize - blobStreamSize - 8L));
                MessageFormatRecord.Blob_Format_V2.serializePartialBlobRecord(serializedBlobPartialRecord, blobStreamSize, blobType);
                serializedBlobPartialRecord.flip();
                break;
            }
            default: {
                throw new MessageFormatException("Unknown version encountered when creating hard delete stream", MessageFormatErrorCodes.Unknown_Format_Version);
            }
        }
        this.buffer = ByteBuffer.allocate(userMetadataRecordSize + (int)(blobRecordSize - blobStreamSize - 8L));
        this.buffer.put(serializedUserMetadata);
        int bufferBlobStart = this.buffer.position();
        this.buffer.put(serializedBlobPartialRecord);
        Crc32 crc = new Crc32();
        crc.update(this.buffer.array(), bufferBlobStart, this.buffer.position() - bufferBlobStart);
        this.stream = new CrcInputStream(crc, (InputStream)blobStream);
        this.streamLength = blobStreamSize;
        this.messageLength = (long)this.buffer.capacity() + this.streamLength + 8L;
        this.buffer.flip();
    }

    public int getHardDeleteStreamRelativeOffset() {
        return this.hardDeleteStreamRelativeOffset;
    }
}

