/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.DeleteSubRecord;
import com.github.ambry.messageformat.MessageFormatException;
import com.github.ambry.messageformat.MessageFormatInputStream;
import com.github.ambry.messageformat.MessageFormatRecord;
import com.github.ambry.messageformat.SubRecord;
import com.github.ambry.messageformat.UpdateRecord;
import com.github.ambry.store.StoreKey;
import java.nio.ByteBuffer;

public class DeleteMessageFormatInputStream
extends MessageFormatInputStream {
    public DeleteMessageFormatInputStream(StoreKey key, short accountId, short containerId, long deletionTimeMs) throws MessageFormatException {
        this(key, accountId, containerId, deletionTimeMs, 0);
    }

    public DeleteMessageFormatInputStream(StoreKey key, short accountId, short containerId, long deletionTimeMs, short lifeVersion) throws MessageFormatException {
        int headerSize = MessageFormatRecord.getHeaderSizeForVersion(MessageFormatRecord.headerVersionToUse);
        int deleteRecordSize = MessageFormatRecord.Update_Format_V3.getRecordSize(SubRecord.Type.DELETE);
        this.buffer = ByteBuffer.allocate(headerSize + key.sizeInBytes() + deleteRecordSize);
        if (MessageFormatRecord.headerVersionToUse == 1) {
            MessageFormatRecord.MessageHeader_Format_V1.serializeHeader(this.buffer, deleteRecordSize, -1, headerSize + key.sizeInBytes(), -1, -1);
        } else if (MessageFormatRecord.headerVersionToUse == 2) {
            MessageFormatRecord.MessageHeader_Format_V2.serializeHeader(this.buffer, deleteRecordSize, -1, -1, headerSize + key.sizeInBytes(), -1, -1);
        } else {
            MessageFormatRecord.MessageHeader_Format_V3.serializeHeader(this.buffer, lifeVersion, deleteRecordSize, -1, -1, headerSize + key.sizeInBytes(), -1, -1);
        }
        this.buffer.put(key.toBytes());
        MessageFormatRecord.Update_Format_V3.serialize(this.buffer, new UpdateRecord(accountId, containerId, deletionTimeMs, new DeleteSubRecord()));
        this.messageLength = this.buffer.capacity();
        this.buffer.flip();
    }
}

