/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.store.StoreKey;
import com.github.ambry.utils.Pair;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CompositeBlobInfo {
    private final int chunkSize;
    private final long totalSize;
    private final List<Long> offsets = new ArrayList<Long>();
    private final List<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
    private final short metadataContentVersion;

    public CompositeBlobInfo(int chunkSize, long totalSize, List<StoreKey> keys) {
        this.chunkSize = chunkSize;
        if ((long)chunkSize < 1L) {
            throw new IllegalArgumentException("chunkSize cannot be 0 or less");
        }
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("keys should not be null or empty");
        }
        long rightAmountOfKeys = totalSize / (long)chunkSize + (long)(totalSize % (long)chunkSize == 0L ? 0 : 1);
        if (rightAmountOfKeys != (long)keys.size()) {
            throw new IllegalArgumentException("keys should contain " + rightAmountOfKeys + " keys, not " + keys.size());
        }
        this.totalSize = totalSize;
        this.metadataContentVersion = (short)2;
        long last = 0L;
        for (StoreKey key : keys) {
            this.offsets.add(last);
            if (totalSize - last < 1L) {
                throw new IllegalArgumentException("CompositeBlobInfo can't be composed of blobs with size 0 or less");
            }
            this.chunkMetadataList.add(new ChunkMetadata(key, last, Math.min((long)chunkSize, totalSize - last)));
            last += (long)chunkSize;
        }
    }

    public CompositeBlobInfo(List<Pair<StoreKey, Long>> keysAndContentSizes) {
        if (keysAndContentSizes == null || keysAndContentSizes.isEmpty()) {
            throw new IllegalArgumentException("keysAndContentSizes should not be null or empty");
        }
        this.chunkSize = -1;
        long last = 0L;
        this.metadataContentVersion = (short)3;
        for (Pair<StoreKey, Long> keyAndContentSize : keysAndContentSizes) {
            if ((Long)keyAndContentSize.getSecond() < 1L) {
                throw new IllegalArgumentException("CompositeBlobInfo can't be composed of blobs with size 0 or less");
            }
            StoreKey key = (StoreKey)keyAndContentSize.getFirst();
            this.offsets.add(last);
            this.chunkMetadataList.add(new ChunkMetadata(key, last, (Long)keyAndContentSize.getSecond()));
            last += ((Long)keyAndContentSize.getSecond()).longValue();
        }
        this.totalSize = last;
    }

    public List<ChunkMetadata> getStoreKeysInByteRange(long start, long end) {
        int endIdx;
        if (end < start || start < 0L || end >= this.totalSize) {
            throw new IllegalArgumentException("Bad input parameters, start=" + start + " end=" + end + " totalSize=" + this.totalSize);
        }
        int startIdx = Collections.binarySearch(this.offsets, start);
        if (startIdx < 0) {
            startIdx = -startIdx - 2;
        }
        if ((endIdx = Collections.binarySearch(this.offsets, end)) < 0) {
            endIdx = -endIdx - 2;
        }
        return this.chunkMetadataList.subList(startIdx, ++endIdx);
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public List<StoreKey> getKeys() {
        return new AbstractList<StoreKey>(){

            @Override
            public StoreKey get(int index) {
                return ((ChunkMetadata)CompositeBlobInfo.this.chunkMetadataList.get(index)).getStoreKey();
            }

            @Override
            public int size() {
                return CompositeBlobInfo.this.chunkMetadataList.size();
            }
        };
    }

    public List<ChunkMetadata> getChunkMetadataList() {
        return this.chunkMetadataList;
    }

    public short getMetadataContentVersion() {
        return this.metadataContentVersion;
    }

    public static class ChunkMetadata {
        private final StoreKey storeKey;
        private final long offset;
        private final long size;

        public ChunkMetadata(StoreKey storeKey, long offset, long size) {
            this.storeKey = storeKey;
            this.offset = offset;
            this.size = size;
        }

        public StoreKey getStoreKey() {
            return this.storeKey;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getSize() {
            return this.size;
        }

        public boolean equals(Object that) {
            if (that instanceof ChunkMetadata) {
                ChunkMetadata thatCM = (ChunkMetadata)that;
                return this.storeKey.equals(thatCM.storeKey) && this.offset == thatCM.offset && this.size == thatCM.size;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.storeKey, this.offset, this.size);
        }
    }
}

