/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.BlobProperties;
import com.github.ambry.messageformat.MessageFormatErrorCodes;
import com.github.ambry.messageformat.MessageFormatException;
import com.github.ambry.messageformat.MessageFormatRecord;
import com.github.ambry.messageformat.ReadInputStream;
import com.github.ambry.messageformat.UpdateRecord;
import com.github.ambry.store.MessageInfo;
import com.github.ambry.store.MessageStoreRecovery;
import com.github.ambry.store.Read;
import com.github.ambry.store.StoreKey;
import com.github.ambry.store.StoreKeyFactory;
import com.github.ambry.utils.Utils;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreRecovery
implements MessageStoreRecovery {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<MessageInfo> recover(Read read, long startOffset, long endOffset, StoreKeyFactory factory) throws IOException {
        ArrayList<MessageInfo> messageRecovered = new ArrayList<MessageInfo>();
        try {
            while (startOffset < endOffset) {
                ByteBuffer headerVersion = ByteBuffer.allocate(2);
                if (startOffset + 2L > endOffset) {
                    throw new IndexOutOfBoundsException("Unable to read version. Reached end of stream");
                }
                read.readInto(headerVersion, startOffset);
                startOffset += (long)headerVersion.capacity();
                headerVersion.flip();
                short version = headerVersion.getShort();
                if (!MessageFormatRecord.isValidHeaderVersion(version)) {
                    throw new MessageFormatException("Version not known while reading message - " + version, MessageFormatErrorCodes.Unknown_Format_Version);
                }
                ByteBuffer header = ByteBuffer.allocate(MessageFormatRecord.getHeaderSizeForVersion(version));
                header.putShort(version);
                if (startOffset + (long)(header.capacity() - headerVersion.capacity()) > endOffset) {
                    throw new IndexOutOfBoundsException("Unable to read version. Reached end of stream");
                }
                read.readInto(header, startOffset);
                header.flip();
                MessageFormatRecord.MessageHeader_Format headerFormat = MessageFormatRecord.getMessageHeader(version, header);
                headerFormat.verifyHeader();
                ReadInputStream stream = new ReadInputStream(read, startOffset += (long)(header.capacity() - headerVersion.capacity()), endOffset);
                StoreKey key = factory.getStoreKey(new DataInputStream(stream));
                short lifeVersion = 0;
                if (headerFormat.hasLifeVersion()) {
                    lifeVersion = headerFormat.getLifeVersion();
                }
                if (headerFormat.isPutRecord()) {
                    if (headerFormat.hasEncryptionKeyRecord()) {
                        MessageFormatRecord.deserializeBlobEncryptionKey(stream);
                    }
                    BlobProperties properties = MessageFormatRecord.deserializeBlobProperties(stream);
                    MessageFormatRecord.deserializeUserMetadata(stream);
                    MessageFormatRecord.deserializeBlob(stream);
                    MessageInfo info = new MessageInfo(key, (long)(header.capacity() + key.sizeInBytes()) + headerFormat.getMessageSize(), false, false, false, Utils.addSecondsToEpochTime((long)properties.getCreationTimeInMs(), (long)properties.getTimeToLiveInSeconds()), null, properties.getAccountId(), properties.getContainerId(), properties.getCreationTimeInMs(), lifeVersion);
                    messageRecovered.add(info);
                } else {
                    UpdateRecord updateRecord = MessageFormatRecord.deserializeUpdateRecord(stream);
                    boolean deleted = false;
                    boolean ttlUpdated = false;
                    boolean undeleted = false;
                    switch (updateRecord.getType()) {
                        case DELETE: {
                            deleted = true;
                            break;
                        }
                        case TTL_UPDATE: {
                            ttlUpdated = true;
                            break;
                        }
                        case UNDELETE: {
                            undeleted = true;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown update record type: " + (Object)((Object)updateRecord.getType()));
                        }
                    }
                    MessageInfo info = new MessageInfo(key, (long)(header.capacity() + key.sizeInBytes()) + headerFormat.getMessageSize(), deleted, ttlUpdated, undeleted, updateRecord.getAccountId(), updateRecord.getContainerId(), updateRecord.getUpdateTimeInMs(), lifeVersion);
                    messageRecovered.add(info);
                }
                startOffset = stream.getCurrentPosition();
            }
        }
        catch (MessageFormatException e) {
            this.logger.error("Message format exception while recovering messages", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.error("Trying to read more than the available bytes");
        }
        for (MessageInfo messageInfo : messageRecovered) {
            this.logger.info("Message Recovered key {} size {} ttl {} deleted {}", new Object[]{messageInfo.getStoreKey(), messageInfo.getSize(), messageInfo.getExpirationTimeInMs(), messageInfo.isDeleted()});
        }
        return messageRecovered;
    }
}

