/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.BlobType;
import com.github.ambry.messageformat.DeserializedBlob;
import com.github.ambry.messageformat.DeserializedUserMetadata;
import com.github.ambry.messageformat.HardDeleteMessageFormatInputStream;
import com.github.ambry.messageformat.HardDeleteRecoveryMetadata;
import com.github.ambry.messageformat.MessageFormatErrorCodes;
import com.github.ambry.messageformat.MessageFormatException;
import com.github.ambry.messageformat.MessageFormatRecord;
import com.github.ambry.messageformat.MessageReadSetIndexInputStream;
import com.github.ambry.store.HardDeleteInfo;
import com.github.ambry.store.MessageReadSet;
import com.github.ambry.store.StoreKey;
import com.github.ambry.store.StoreKeyFactory;
import com.github.ambry.utils.ByteBufferInputStream;
import com.github.ambry.utils.ByteBufferOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlobStoreHardDeleteIterator
implements Iterator<HardDeleteInfo> {
    private final MessageReadSet readSet;
    private final StoreKeyFactory storeKeyFactory;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int readSetIndex = 0;
    private Map<StoreKey, HardDeleteRecoveryMetadata> recoveryInfoMap;

    BlobStoreHardDeleteIterator(MessageReadSet readSet, StoreKeyFactory storeKeyFactory, List<byte[]> recoveryInfoList) throws IOException {
        this.readSet = readSet;
        this.storeKeyFactory = storeKeyFactory;
        this.recoveryInfoMap = new HashMap<StoreKey, HardDeleteRecoveryMetadata>();
        if (recoveryInfoList != null) {
            for (byte[] recoveryInfo : recoveryInfoList) {
                HardDeleteRecoveryMetadata hardDeleteRecoveryMetadata = new HardDeleteRecoveryMetadata(recoveryInfo, storeKeyFactory);
                this.recoveryInfoMap.put(hardDeleteRecoveryMetadata.getStoreKey(), hardDeleteRecoveryMetadata);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.readSetIndex != this.readSet.count();
    }

    @Override
    public HardDeleteInfo next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getHardDeleteInfo(this.readSetIndex++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private HardDeleteInfo getHardDeleteInfo(int readSetIndex) {
        HardDeleteInfo hardDeleteInfo = null;
        try {
            BlobType blobType;
            short blobRecordVersion;
            long blobStreamSize;
            short userMetadataVersion;
            int userMetadataSize;
            ByteBuffer headerVersionBuf = ByteBuffer.allocate(2);
            this.readSet.writeTo(readSetIndex, Channels.newChannel((OutputStream)new ByteBufferOutputStream(headerVersionBuf)), 0L, 2L);
            headerVersionBuf.flip();
            short headerVersion = headerVersionBuf.getShort();
            if (!MessageFormatRecord.isValidHeaderVersion(headerVersion)) {
                throw new MessageFormatException("Unknown header version during hard delete " + headerVersion + " storeKey " + this.readSet.getKeyAt(readSetIndex), MessageFormatErrorCodes.Unknown_Format_Version);
            }
            ByteBuffer header = ByteBuffer.allocate(MessageFormatRecord.getHeaderSizeForVersion(headerVersion));
            header.putShort(headerVersion);
            this.readSet.writeTo(readSetIndex, Channels.newChannel((OutputStream)new ByteBufferOutputStream(header)), 2L, (long)(header.capacity() - 2));
            header.flip();
            MessageFormatRecord.MessageHeader_Format headerFormat = MessageFormatRecord.getMessageHeader(headerVersion, header);
            headerFormat.verifyHeader();
            StoreKey storeKey = this.storeKeyFactory.getStoreKey(new DataInputStream(new MessageReadSetIndexInputStream(this.readSet, readSetIndex, header.capacity())));
            if (storeKey.compareTo((Object)this.readSet.getKeyAt(readSetIndex)) != 0) {
                throw new MessageFormatException("Id mismatch between metadata and store - metadataId " + this.readSet.getKeyAt(readSetIndex) + " storeId " + storeKey, MessageFormatErrorCodes.Store_Key_Id_MisMatch);
            }
            if (!headerFormat.isPutRecord()) {
                throw new MessageFormatException("Cleanup operation for a non-PUT record is unsupported", MessageFormatErrorCodes.IO_Error);
            }
            HardDeleteRecoveryMetadata hardDeleteRecoveryMetadata = this.recoveryInfoMap.get(storeKey);
            int userMetadataRelativeOffset = headerFormat.getUserMetadataRecordRelativeOffset();
            if (hardDeleteRecoveryMetadata == null) {
                DeserializedUserMetadata userMetadataInfo = this.getUserMetadataInfo(this.readSet, readSetIndex, headerFormat.getUserMetadataRecordRelativeOffset(), headerFormat.getUserMetadataRecordSize());
                userMetadataSize = userMetadataInfo.getUserMetadata().capacity();
                userMetadataVersion = userMetadataInfo.getVersion();
                DeserializedBlob blobRecordInfo = this.getBlobRecordInfo(this.readSet, readSetIndex, headerFormat.getBlobRecordRelativeOffset(), headerFormat.getBlobRecordSize());
                blobStreamSize = blobRecordInfo.getBlobData().getSize();
                blobRecordVersion = blobRecordInfo.getVersion();
                blobType = blobRecordInfo.getBlobData().getBlobType();
                hardDeleteRecoveryMetadata = new HardDeleteRecoveryMetadata(headerVersion, userMetadataVersion, userMetadataSize, blobRecordVersion, blobType, blobStreamSize, storeKey);
            } else {
                this.logger.trace("Skipping crc check for user metadata and blob stream fields for key {}", (Object)storeKey);
                userMetadataVersion = hardDeleteRecoveryMetadata.getUserMetadataVersion();
                blobRecordVersion = hardDeleteRecoveryMetadata.getBlobRecordVersion();
                blobType = hardDeleteRecoveryMetadata.getBlobType();
                userMetadataSize = hardDeleteRecoveryMetadata.getUserMetadataSize();
                blobStreamSize = hardDeleteRecoveryMetadata.getBlobStreamSize();
            }
            HardDeleteMessageFormatInputStream hardDeleteStream = new HardDeleteMessageFormatInputStream(userMetadataRelativeOffset, userMetadataVersion, userMetadataSize, blobRecordVersion, blobType, blobStreamSize);
            hardDeleteInfo = new HardDeleteInfo(Channels.newChannel(hardDeleteStream), hardDeleteStream.getSize(), (long)hardDeleteStream.getHardDeleteStreamRelativeOffset(), hardDeleteRecoveryMetadata.toBytes());
        }
        catch (Exception e) {
            this.logger.error("Exception when reading blob: ", (Throwable)e);
        }
        return hardDeleteInfo;
    }

    private DeserializedUserMetadata getUserMetadataInfo(MessageReadSet readSet, int readSetIndex, int relativeOffset, int userMetadataSize) throws MessageFormatException, IOException {
        ByteBuffer userMetaData = ByteBuffer.allocate(userMetadataSize);
        readSet.writeTo(readSetIndex, Channels.newChannel((OutputStream)new ByteBufferOutputStream(userMetaData)), (long)relativeOffset, (long)userMetadataSize);
        userMetaData.flip();
        return MessageFormatRecord.deserializeAndGetUserMetadataWithVersion((InputStream)new ByteBufferInputStream(userMetaData));
    }

    private DeserializedBlob getBlobRecordInfo(MessageReadSet readSet, int readSetIndex, int relativeOffset, long blobRecordSize) throws MessageFormatException, IOException {
        ByteBuffer blobRecord = ByteBuffer.allocate((int)blobRecordSize);
        readSet.writeTo(readSetIndex, Channels.newChannel((OutputStream)new ByteBufferOutputStream(blobRecord)), (long)relativeOffset, blobRecordSize);
        blobRecord.flip();
        return MessageFormatRecord.deserializeAndGetBlobWithVersion((InputStream)new ByteBufferInputStream(blobRecord));
    }
}

