/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.messageformat;

import com.github.ambry.messageformat.BlobProperties;
import com.github.ambry.utils.Utils;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BlobPropertiesSerDe {
    static final short VERSION_1 = 1;
    static final short VERSION_2 = 2;
    static final short VERSION_3 = 3;
    private static final int VERSION_FIELD_SIZE_IN_BYTES = 2;
    private static final int TTL_FIELD_SIZE_IN_BYTES = 8;
    private static final int PRIVATE_FIELD_SIZE_IN_BYTES = 1;
    private static final int CREATION_TIME_FIELD_SIZE_IN_BYTES = 8;
    private static final int BLOB_SIZE_FIELD_SIZE_IN_BYTES = 8;
    private static final int ENCRYPTED_FIELD_SIZE_IN_BYTES = 1;

    public static int getBlobPropertiesSerDeSize(BlobProperties properties) {
        return 27 + Utils.getIntStringLength((String)properties.getContentType()) + Utils.getIntStringLength((String)properties.getOwnerId()) + Utils.getIntStringLength((String)properties.getServiceId()) + 2 + 2 + 1;
    }

    public static BlobProperties getBlobPropertiesFromStream(DataInputStream stream) throws IOException {
        short version = stream.readShort();
        if (version < 1 || version > 3) {
            throw new IllegalArgumentException("stream has unknown blob property version " + version);
        }
        long ttl = stream.readLong();
        boolean isPrivate = stream.readByte() == 1;
        long creationTime = stream.readLong();
        long blobSize = stream.readLong();
        String contentType = Utils.readIntString((DataInputStream)stream);
        String ownerId = Utils.readIntString((DataInputStream)stream);
        String serviceId = Utils.readIntString((DataInputStream)stream);
        short accountId = version > 1 ? (short)stream.readShort() : (short)-1;
        short containerId = version > 1 ? (short)stream.readShort() : (short)-1;
        boolean isEncrypted = version > 2 && stream.readByte() == 1;
        return new BlobProperties(blobSize, serviceId, ownerId, contentType, isPrivate, ttl, creationTime, accountId, containerId, isEncrypted, null);
    }

    public static void serializeBlobProperties(ByteBuffer outputBuffer, BlobProperties properties) {
        if (outputBuffer.remaining() < BlobPropertiesSerDe.getBlobPropertiesSerDeSize(properties)) {
            throw new IllegalArgumentException("Outut buffer does not have sufficient space to serialize blob properties");
        }
        outputBuffer.putShort((short)3);
        outputBuffer.putLong(properties.getTimeToLiveInSeconds());
        outputBuffer.put(properties.isPrivate() ? (byte)1 : 0);
        outputBuffer.putLong(properties.getCreationTimeInMs());
        outputBuffer.putLong(properties.getBlobSize());
        Utils.serializeNullableString((ByteBuffer)outputBuffer, (String)properties.getContentType());
        Utils.serializeNullableString((ByteBuffer)outputBuffer, (String)properties.getOwnerId());
        Utils.serializeNullableString((ByteBuffer)outputBuffer, (String)properties.getServiceId());
        outputBuffer.putShort(properties.getAccountId());
        outputBuffer.putShort(properties.getContainerId());
        outputBuffer.put(properties.isEncrypted() ? (byte)1 : 0);
    }
}

