/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.store;

public class TimeRange {
    private final long startTimeInMs;
    private final long endTimeInMs;

    public TimeRange(long referenceTimeInMs, long errorMarginInMs) {
        if (errorMarginInMs < 0L || referenceTimeInMs < 0L || referenceTimeInMs - errorMarginInMs < 0L || referenceTimeInMs > Long.MAX_VALUE - errorMarginInMs) {
            throw new IllegalArgumentException("Illegal reference time: " + referenceTimeInMs + " and/or error margin: " + errorMarginInMs);
        }
        this.startTimeInMs = referenceTimeInMs - errorMarginInMs;
        this.endTimeInMs = referenceTimeInMs + errorMarginInMs;
    }

    public long getStartTimeInMs() {
        return this.startTimeInMs;
    }

    public long getEndTimeInMs() {
        return this.endTimeInMs;
    }
}

