/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.store;

import com.github.ambry.store.StoreKey;
import java.util.Objects;

public class MessageInfo {
    private final StoreKey key;
    private final long size;
    private final long expirationTimeInMs;
    private final boolean isDeleted;
    private final boolean isTtlUpdated;
    private final boolean isUndeleted;
    private final Long crc;
    private final short accountId;
    private final short containerId;
    private final long operationTimeMs;
    private final short lifeVersion;

    public MessageInfo(StoreKey key, long size, long expirationTimeInMs, short accountId, short containerId, long operationTimeMs) {
        this(key, size, false, false, expirationTimeInMs, accountId, containerId, operationTimeMs);
    }

    public MessageInfo(StoreKey key, long size, boolean deleted, boolean ttlUpdated, short accountId, short containerId, long operationTimeMs) {
        this(key, size, deleted, ttlUpdated, -1L, accountId, containerId, operationTimeMs);
    }

    public MessageInfo(StoreKey key, long size, boolean deleted, boolean ttlUpdated, boolean undeleted, short accountId, short containerId, long operationTimeMs, short lifeVersion) {
        this(key, size, deleted, ttlUpdated, undeleted, -1L, null, accountId, containerId, operationTimeMs, lifeVersion);
    }

    public MessageInfo(StoreKey key, long size, boolean deleted, boolean ttlUpdated, long expirationTimeInMs, short accountId, short containerId, long operationTimeMs) {
        this(key, size, deleted, ttlUpdated, false, expirationTimeInMs, null, accountId, containerId, operationTimeMs, 0);
    }

    public MessageInfo(StoreKey key, long size, short accountId, short containerId, long operationTimeMs) {
        this(key, size, -1L, accountId, containerId, operationTimeMs);
    }

    public MessageInfo(StoreKey key, long size, boolean deleted, boolean ttlUpdated, long expirationTimeInMs, Long crc, short accountId, short containerId, long operationTimeMs) {
        this(key, size, deleted, ttlUpdated, false, expirationTimeInMs, crc, accountId, containerId, operationTimeMs, 0);
    }

    public MessageInfo(StoreKey key, long size, boolean deleted, boolean ttlUpdated, boolean undeleted, long expirationTimeInMs, Long crc, short accountId, short containerId, long operationTimeMs, short lifeVersion) {
        if (operationTimeMs < -1L) {
            throw new IllegalArgumentException("OperationTime cannot be negative " + operationTimeMs);
        }
        this.key = key;
        this.size = size;
        this.isDeleted = deleted;
        this.isTtlUpdated = ttlUpdated;
        this.isUndeleted = undeleted;
        this.expirationTimeInMs = expirationTimeInMs;
        this.crc = crc;
        this.accountId = accountId;
        this.containerId = containerId;
        this.operationTimeMs = operationTimeMs;
        this.lifeVersion = lifeVersion;
    }

    public StoreKey getStoreKey() {
        return this.key;
    }

    public long getSize() {
        return this.size;
    }

    public long getExpirationTimeInMs() {
        return this.expirationTimeInMs;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isTtlUpdated() {
        return this.isTtlUpdated;
    }

    public boolean isUndeleted() {
        return this.isUndeleted;
    }

    public boolean isExpired() {
        return this.getExpirationTimeInMs() != -1L && System.currentTimeMillis() > this.getExpirationTimeInMs();
    }

    public Long getCrc() {
        return this.crc;
    }

    public short getAccountId() {
        return this.accountId;
    }

    public short getContainerId() {
        return this.containerId;
    }

    public long getOperationTimeMs() {
        return this.operationTimeMs;
    }

    public short getLifeVersion() {
        return this.lifeVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageInfo that = (MessageInfo)o;
        return this.size == that.size && this.expirationTimeInMs == that.expirationTimeInMs && this.isDeleted == that.isDeleted && this.isTtlUpdated == that.isTtlUpdated && this.isUndeleted == that.isUndeleted && this.accountId == that.accountId && this.containerId == that.containerId && this.operationTimeMs == that.operationTimeMs && Objects.equals(this.key, that.key) && this.lifeVersion == that.lifeVersion && Objects.equals(this.crc, that.crc);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.size, this.expirationTimeInMs, this.isDeleted, this.isTtlUpdated, this.isUndeleted, this.crc, this.accountId, this.containerId, this.operationTimeMs, this.lifeVersion);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[MessageInfo:").append("Key-").append(this.key).append(",").append("Size-").append(this.size).append(",").append("ExpirationTimeInMs-").append(this.expirationTimeInMs).append(",").append("IsDeleted-").append(this.isDeleted).append(",").append("IsTtlUpdated-").append(this.isTtlUpdated).append(",").append("IsUndeleted-").append(this.isUndeleted).append(",").append("Crc-").append(this.crc).append(",").append("AccountId-").append(this.accountId).append(",").append("ContainerId-").append(this.containerId).append(",").append("OperationTimeMs-").append(this.operationTimeMs).append(",").append("LifeVersion-").append(this.lifeVersion).append("]");
        return stringBuilder.toString();
    }
}

