/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.rest;

import com.github.ambry.account.Account;
import com.github.ambry.account.Container;
import com.github.ambry.messageformat.BlobProperties;
import com.github.ambry.protocol.GetOption;
import com.github.ambry.rest.RequestPath;
import com.github.ambry.rest.RestRequest;
import com.github.ambry.rest.RestResponseChannel;
import com.github.ambry.rest.RestServiceErrorCode;
import com.github.ambry.rest.RestServiceException;
import com.github.ambry.router.ByteRange;
import com.github.ambry.router.ByteRanges;
import com.github.ambry.router.GetBlobOptions;
import com.github.ambry.router.GetBlobOptionsBuilder;
import com.github.ambry.utils.Crc32;
import com.github.ambry.utils.Pair;
import com.github.ambry.utils.Utils;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String BYTE_RANGE_UNITS = "bytes";
    public static final String SIGNED_ID_PREFIX = "signedId/";
    public static final String JSON_CONTENT_TYPE = "application/json";
    private static final String BYTE_RANGE_PREFIX = "bytes=";
    private static final int CRC_SIZE = 8;
    private static final short USER_METADATA_VERSION_V1 = 1;
    private static final Logger logger = LoggerFactory.getLogger(RestUtils.class);

    public static BlobProperties buildBlobProperties(Map<String, Object> args) throws RestServiceException {
        Account account = RestUtils.getAccountFromArgs(args);
        Container container = RestUtils.getContainerFromArgs(args);
        String serviceId = RestUtils.getHeader(args, "x-ambry-service-id", true);
        String contentType = RestUtils.getHeader(args, "x-ambry-content-type", true);
        String ownerId = RestUtils.getHeader(args, "x-ambry-owner-id", false);
        String externalAssetTag = RestUtils.getHeader(args, "x-ambry-external-asset-tag", false);
        long ttl = -1L;
        Long ttlFromHeader = RestUtils.getLongHeader(args, "x-ambry-ttl", false);
        if (ttlFromHeader != null) {
            if (ttlFromHeader < -1L) {
                throw new RestServiceException("x-ambry-ttl[" + ttlFromHeader + "] is not valid (has to be >= -1)", RestServiceErrorCode.InvalidArgs);
            }
            ttl = ttlFromHeader;
        }
        boolean isPrivate = !container.isCacheable();
        return new BlobProperties(-1L, serviceId, ownerId, contentType, isPrivate, ttl, account.getId(), container.getId(), container.isEncrypted(), externalAssetTag);
    }

    public static byte[] buildUserMetadata(Map<String, Object> args) throws RestServiceException {
        ByteBuffer userMetadata;
        if (args.containsKey("UserMetadata")) {
            userMetadata = (ByteBuffer)args.get("UserMetadata");
        } else {
            String key;
            HashMap<String, String> userMetadataMap = new HashMap<String, String>();
            int sizeToAllocate = 0;
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                key = entry.getKey();
                if (!key.toLowerCase().startsWith("x-ambry-um-")) continue;
                sizeToAllocate += 4;
                String keyToStore = key.substring("x-ambry-um-".length());
                sizeToAllocate += keyToStore.getBytes(StandardCharsets.US_ASCII).length;
                String value = RestUtils.getHeader(args, key, true);
                userMetadataMap.put(keyToStore, value);
                sizeToAllocate += 4;
                sizeToAllocate += value.getBytes(StandardCharsets.US_ASCII).length;
            }
            if (sizeToAllocate == 0) {
                userMetadata = ByteBuffer.allocate(0);
            } else {
                sizeToAllocate += 2;
                sizeToAllocate += 4;
                sizeToAllocate += 4;
                userMetadata = ByteBuffer.allocate(sizeToAllocate += 8);
                userMetadata.putShort((short)1);
                userMetadata.putInt(sizeToAllocate - 6 - 8);
                userMetadata.putInt(userMetadataMap.size());
                for (Map.Entry<String, Object> entry : userMetadataMap.entrySet()) {
                    key = entry.getKey();
                    Utils.serializeString((ByteBuffer)userMetadata, (String)key, (Charset)StandardCharsets.US_ASCII);
                    Utils.serializeString((ByteBuffer)userMetadata, (String)((String)entry.getValue()), (Charset)StandardCharsets.US_ASCII);
                }
                Crc32 crc = new Crc32();
                crc.update(userMetadata.array(), 0, sizeToAllocate - 8);
                userMetadata.putLong(crc.getValue());
            }
        }
        return userMetadata.array();
    }

    public static Map<String, String> buildUserMetadata(byte[] userMetadata) {
        if (userMetadata.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> toReturn = null;
        try {
            ByteBuffer userMetadataBuffer = ByteBuffer.wrap(userMetadata);
            short version = userMetadataBuffer.getShort();
            switch (version) {
                case 1: {
                    int sizeToRead = userMetadataBuffer.getInt();
                    if (sizeToRead != userMetadataBuffer.remaining() - 8) {
                        logger.trace("Size didn't match. Returning null");
                        break;
                    }
                    int entryCount = userMetadataBuffer.getInt();
                    int counter = 0;
                    if (entryCount > 0) {
                        toReturn = new HashMap<String, String>();
                    }
                    while (counter++ < entryCount) {
                        String key = Utils.deserializeString((ByteBuffer)userMetadataBuffer, (Charset)StandardCharsets.US_ASCII);
                        String value = Utils.deserializeString((ByteBuffer)userMetadataBuffer, (Charset)StandardCharsets.US_ASCII);
                        toReturn.put("x-ambry-um-" + key, value);
                    }
                    long actualCRC = userMetadataBuffer.getLong();
                    Crc32 crc32 = new Crc32();
                    crc32.update(userMetadata, 0, userMetadata.length - 8);
                    long expectedCRC = crc32.getValue();
                    if (actualCRC != expectedCRC) {
                        logger.error("corrupt data while parsing user metadata Expected CRC " + expectedCRC + " Actual CRC " + actualCRC);
                        toReturn = null;
                    }
                    break;
                }
                default: {
                    toReturn = null;
                    logger.trace("Failed to parse version in new format. Returning null");
                }
            }
        }
        catch (RuntimeException e) {
            logger.trace("Runtime Exception on parsing user metadata. Returning null");
            toReturn = null;
        }
        return toReturn;
    }

    public static GetBlobOptions buildGetBlobOptions(Map<String, Object> args, SubResource subResource, GetOption getOption, int blobSegmentIdx) throws RestServiceException {
        String rangeHeaderValue = RestUtils.getHeader(args, "Range", false);
        if (subResource != null && !subResource.equals((Object)SubResource.Segment) && rangeHeaderValue != null) {
            throw new RestServiceException("Ranges not supported for sub-resources that aren't Segment.", RestServiceErrorCode.InvalidArgs);
        }
        return new GetBlobOptionsBuilder().operationType(subResource == null || subResource == SubResource.Segment ? GetBlobOptions.OperationType.All : GetBlobOptions.OperationType.BlobInfo).getOption(getOption).blobSegment(blobSegmentIdx).range(rangeHeaderValue != null ? RestUtils.buildByteRange(rangeHeaderValue) : null).build();
    }

    public static Pair<String, Long> buildContentRangeAndLength(ByteRange range, long blobSize) throws RestServiceException {
        try {
            range = range.toResolvedByteRange(blobSize);
        }
        catch (IllegalArgumentException e) {
            throw new RestServiceException("Range provided was not satisfiable.", e, RestServiceErrorCode.RangeNotSatisfiable);
        }
        return new Pair((Object)("bytes " + range.getStartOffset() + "-" + range.getEndOffset() + "/" + blobSize), (Object)range.getRangeSize());
    }

    public static RequestPath getRequestPath(RestRequest restRequest) {
        return (RequestPath)Objects.requireNonNull(restRequest.getArgs().get("ambry-internal-key-request-path"), "ambry-internal-key-request-path not set in " + restRequest);
    }

    public static Long getTimeFromDateString(String dateString) {
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
            return dateFormatter.parse(dateString).getTime();
        }
        catch (ParseException e) {
            logger.warn("Could not parse milliseconds from an HTTP date header (" + dateString + ").");
            return null;
        }
    }

    public static long toSecondsPrecisionInMs(long ms) {
        return ms - ms % 1000L;
    }

    public static GetOption getGetOption(RestRequest restRequest, GetOption defaultGetOption) throws RestServiceException {
        GetOption option = defaultGetOption == null ? GetOption.None : defaultGetOption;
        Object value = restRequest.getArgs().get("x-ambry-get-option");
        if (value != null) {
            String str = (String)value;
            boolean foundMatch = false;
            for (GetOption getOption : GetOption.values()) {
                if (!str.equalsIgnoreCase(getOption.name())) continue;
                option = getOption;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                throw new RestServiceException("Unrecognized value for [x-ambry-get-option]: " + str, RestServiceErrorCode.InvalidArgs);
            }
        }
        return option;
    }

    public static boolean isPrivate(Map<String, Object> args) throws RestServiceException {
        return RestUtils.getBooleanHeader(args, "x-ambry-private", false);
    }

    public static boolean isChunkUpload(Map<String, Object> args) throws RestServiceException {
        return RestUtils.getBooleanHeader(args, "x-ambry-chunk-upload", false);
    }

    public static void ensureRequiredHeadersOrThrow(RestRequest restRequest, Set<String> requiredHeaders) throws RestServiceException {
        Map<String, Object> args = restRequest.getArgs();
        for (String header : requiredHeaders) {
            RestUtils.getHeader(args, header, true);
        }
    }

    public static String getHeader(Map<String, ?> args, String header, boolean required) throws RestServiceException {
        String value = null;
        if (args.containsKey(header)) {
            Object valueObj = args.get(header);
            String string = value = valueObj != null ? valueObj.toString() : null;
            if (value == null && required) {
                throw new RestServiceException("Request has null value for header: " + header, RestServiceErrorCode.InvalidArgs);
            }
        } else if (required) {
            throw new RestServiceException("Request does not have required header: " + header, RestServiceErrorCode.MissingArgs);
        }
        return value;
    }

    public static Long getLongHeader(Map<String, ?> args, String header, boolean required) throws RestServiceException {
        return RestUtils.getNumericalHeader(args, header, required, Long::parseLong);
    }

    public static <T extends Number> T getNumericalHeader(Map<String, ?> args, String header, boolean required, Function<String, T> converter) throws RestServiceException {
        String value = RestUtils.getHeader(args, header, required);
        if (value != null) {
            try {
                return (T)((Number)converter.apply(value));
            }
            catch (NumberFormatException e) {
                throw new RestServiceException("Invalid value for " + header + ": " + value, e, RestServiceErrorCode.InvalidArgs);
            }
        }
        return null;
    }

    public static boolean getBooleanHeader(Map<String, Object> args, String header, boolean required) throws RestServiceException {
        boolean booleanValue;
        String stringValue = RestUtils.getHeader(args, header, required);
        if (stringValue == null || "false".equalsIgnoreCase(stringValue)) {
            booleanValue = false;
        } else if ("true".equalsIgnoreCase(stringValue)) {
            booleanValue = true;
        } else {
            throw new RestServiceException(header + "[" + stringValue + "] has an invalid value (allowed values: true, false)", RestServiceErrorCode.InvalidArgs);
        }
        return booleanValue;
    }

    public static Account getAccountFromArgs(Map<String, Object> args) throws RestServiceException {
        Object account = args.get("ambry-internal-key-target-account");
        if (account == null) {
            throw new RestServiceException("ambry-internal-key-target-account is not set", RestServiceErrorCode.InternalServerError);
        }
        if (!(account instanceof Account)) {
            throw new RestServiceException("ambry-internal-key-target-account not instance of Account", RestServiceErrorCode.InternalServerError);
        }
        return (Account)account;
    }

    public static Container getContainerFromArgs(Map<String, Object> args) throws RestServiceException {
        Object container = args.get("ambry-internal-key-target-container");
        if (container == null) {
            throw new RestServiceException("ambry-internal-key-target-container is not set", RestServiceErrorCode.InternalServerError);
        }
        if (!(container instanceof Container)) {
            throw new RestServiceException("ambry-internal-key-target-container not instance of Container", RestServiceErrorCode.InternalServerError);
        }
        return (Container)container;
    }

    public static void accountAndContainerNamePreconditionCheck(RestRequest restRequest) throws RestServiceException {
        String accountNameFromHeader = RestUtils.getHeader(restRequest.getArgs(), "x-ambry-target-account-name", false);
        String containerNameFromHeader = RestUtils.getHeader(restRequest.getArgs(), "x-ambry-target-container-name", false);
        if (accountNameFromHeader != null) {
            Container targetContainer;
            String containerNameFromBlobId;
            Account targetAccount = RestUtils.getAccountFromArgs(restRequest.getArgs());
            String accountNameFromBlobId = targetAccount.getName();
            if (!accountNameFromHeader.equals(accountNameFromBlobId)) {
                throw new RestServiceException("Account name: " + accountNameFromHeader + " from request doesn't match the account name from Blob id : " + accountNameFromBlobId, RestServiceErrorCode.PreconditionFailed);
            }
            if (containerNameFromHeader != null && !containerNameFromHeader.equals(containerNameFromBlobId = (targetContainer = RestUtils.getContainerFromArgs(restRequest.getArgs())).getName())) {
                throw new RestServiceException("Container name: " + containerNameFromHeader + "from request doesn't match the container name from Blob id : " + containerNameFromBlobId, RestServiceErrorCode.PreconditionFailed);
            }
        } else if (containerNameFromHeader != null) {
            throw new RestServiceException("Only container name is set in request with no corresponding account name is not allowed.", RestServiceErrorCode.BadRequest);
        }
    }

    public static boolean setUserMetadataHeaders(byte[] userMetadata, RestResponseChannel restResponseChannel) throws RestServiceException {
        boolean setHeaders;
        Map<String, String> userMetadataMap = RestUtils.buildUserMetadata(userMetadata);
        boolean bl = setHeaders = userMetadataMap != null;
        if (setHeaders) {
            for (Map.Entry<String, String> entry : userMetadataMap.entrySet()) {
                restResponseChannel.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return setHeaders;
    }

    private static ByteRange buildByteRange(String rangeHeaderValue) throws RestServiceException {
        ByteRange range;
        if (!rangeHeaderValue.startsWith(BYTE_RANGE_PREFIX)) {
            throw new RestServiceException("Invalid byte range syntax; does not start with 'bytes='", RestServiceErrorCode.InvalidArgs);
        }
        try {
            int hyphenIndex = rangeHeaderValue.indexOf(45, BYTE_RANGE_PREFIX.length());
            String startOffsetStr = rangeHeaderValue.substring(BYTE_RANGE_PREFIX.length(), hyphenIndex);
            String endOffsetStr = rangeHeaderValue.substring(hyphenIndex + 1);
            range = startOffsetStr.isEmpty() ? ByteRanges.fromLastNBytes(Long.parseLong(endOffsetStr)) : (endOffsetStr.isEmpty() ? ByteRanges.fromStartOffset(Long.parseLong(startOffsetStr)) : ByteRanges.fromOffsetRange(Long.parseLong(startOffsetStr), Long.parseLong(endOffsetStr)));
        }
        catch (Exception e) {
            throw new RestServiceException("Valid byte range could not be parsed from Range header value: " + rangeHeaderValue, RestServiceErrorCode.InvalidArgs);
        }
        return range;
    }

    public static final class MultipartPost {
        public static final String BLOB_PART = "Blob";
        public static final String USER_METADATA_PART = "UserMetadata";
    }

    public static enum SubResource {
        BlobInfo,
        UserMetadata,
        Replicas,
        Segment;

    }

    public static final class InternalKeys {
        private static final String KEY_PREFIX = "ambry-internal-key-";
        public static final String TARGET_ACCOUNT_KEY = "ambry-internal-key-target-account";
        public static final String TARGET_CONTAINER_KEY = "ambry-internal-key-target-container";
        public static final String SIGNED_ID_METADATA_KEY = "ambry-internal-key-signed-id-metadata";
        public static final String KEEP_ALIVE_ON_ERROR_HINT = "ambry-internal-key-keep-alive-on-error-hint";
        public static final String SEND_TRACKING_INFO = "ambry-internal-key-send-tracking-info";
        public static final String SEND_USER_METADATA_AS_RESPONSE_BODY = "ambry-internal-key-send-user-metadata-as-response-body";
        public static final String REQUEST_PATH = "ambry-internal-key-request-path";
    }

    public static final class TrackingHeaders {
        public static final String DATACENTER_NAME = "x-ambry-datacenter";
        public static final String FRONTEND_NAME = "x-ambry-frontend";
        public static final List<String> TRACKING_HEADERS;

        static {
            Field[] fields = TrackingHeaders.class.getDeclaredFields();
            TRACKING_HEADERS = new ArrayList<String>(fields.length);
            try {
                for (Field field : fields) {
                    if (field.getType() != String.class) continue;
                    TRACKING_HEADERS.add(field.get(null).toString());
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not get values of the tracking headers", e);
            }
        }
    }

    public static final class Headers {
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String DATE = "Date";
        public static final String EXPIRES = "Expires";
        public static final String LAST_MODIFIED = "Last-Modified";
        public static final String LOCATION = "Location";
        public static final String PRAGMA = "Pragma";
        public static final String ACCEPT_RANGES = "Accept-Ranges";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String RANGE = "Range";
        public static final String COOKIE = "Cookie";
        public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
        public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
        public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
        public static final String ALLOW = "allow";
        public static final String BLOB_SIZE = "x-ambry-blob-size";
        public static final String SERVICE_ID = "x-ambry-service-id";
        public static final String TARGET_ACCOUNT_NAME = "x-ambry-target-account-name";
        public static final String TARGET_ACCOUNT_ID = "x-ambry-target-account-id";
        public static final String TARGET_CONTAINER_NAME = "x-ambry-target-container-name";
        public static final String TTL = "x-ambry-ttl";
        public static final String PRIVATE = "x-ambry-private";
        public static final String AMBRY_CONTENT_TYPE = "x-ambry-content-type";
        public static final String OWNER_ID = "x-ambry-owner-id";
        public static final String ENCRYPTED_IN_STORAGE = "x-ambry-encrypted-in-storage";
        public static final String GET_OPTION = "x-ambry-get-option";
        public static final String CREATION_TIME = "x-ambry-creation-time";
        public static final String URL_TYPE = "x-ambry-url-type";
        public static final String URL_TTL = "x-ambry-url-ttl-secs";
        public static final String MAX_UPLOAD_SIZE = "x-ambry-max-upload-size";
        public static final String EXTERNAL_ASSET_TAG = "x-ambry-external-asset-tag";
        public static final String BLOB_ID = "x-ambry-blob-id";
        public static final String SIGNED_URL = "x-ambry-signed-url";
        public static final String CHUNK_UPLOAD = "x-ambry-chunk-upload";
        public static final String SESSION = "x-ambry-session";
        public static final String USER_META_DATA_HEADER_PREFIX = "x-ambry-um-";
        public static final String NON_COMPLIANCE_WARNING = "x-ambry-non-compliance-warning";
    }
}

