/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.rest;

import com.github.ambry.router.RouterErrorCode;

public enum RestServiceErrorCode {
    Deleted,
    NotFound,
    ResourceScanInProgress,
    ResourceDirty,
    AccessDenied,
    Unauthorized,
    BadRequest,
    InvalidArgs,
    InvalidRequestState,
    InvalidAccount,
    InvalidContainer,
    MalformedRequest,
    MissingArgs,
    UnsupportedHttpMethod,
    RangeNotSatisfiable,
    InternalServerError,
    IdConverterServiceError,
    RequestChannelClosed,
    RequestResponseQueuingFailure,
    RequestTooLarge,
    ServiceUnavailable,
    TooManyRequests,
    UnsupportedRestMethod,
    InsufficientCapacity,
    PreconditionFailed,
    NotAllowed;


    public static RestServiceErrorCode getRestServiceErrorCode(RouterErrorCode routerErrorCode) {
        switch (routerErrorCode) {
            case BlobTooLarge: 
            case InvalidBlobId: 
            case InvalidPutArgument: 
            case BadInputChannel: {
                return BadRequest;
            }
            case BlobDeleted: 
            case BlobExpired: {
                return Deleted;
            }
            case BlobAuthorizationFailure: {
                return AccessDenied;
            }
            case BlobDoesNotExist: {
                return NotFound;
            }
            case BlobUpdateNotAllowed: {
                return NotAllowed;
            }
            case RangeNotSatisfiable: {
                return RangeNotSatisfiable;
            }
            case OperationTimedOut: 
            case AmbryUnavailable: 
            case RouterClosed: {
                return ServiceUnavailable;
            }
            case InsufficientCapacity: {
                return InsufficientCapacity;
            }
        }
        return InternalServerError;
    }
}

